(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    211301,       7039]*)
(*NotebookOutlinePosition[    212025,       7064]*)
(*  CellTagsIndexPosition[    211981,       7060]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[StyleBox["Bilder und Daten f\[UDoubleDot]r interaktive Tests",
  CellFrame->True,
  FontColor->RGBColor[1, 0, 0],
  Background->None]], "Title",
  TextAlignment->Center],

Cell["", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f[liste0_, 
          rng_] := \((\[IndentingNewLine]liste = 
            liste0/Sum[
                liste0[\([j]\)], {j, 1, 
                  Length[liste0]}]; \[IndentingNewLine]liste2 = 
            Table[{rng[\([k]\)], liste[\([k]\)]}, {k, 1, 
                Length[liste]}]; \[IndentingNewLine]ListPlot[liste2, 
            TextStyle \[Rule] {FontSize \[Rule] 13}, 
            PlotStyle \[Rule] {PointSize[0.05], \ \ RGBColor[1, \ 0, 0]}, 
            PlotRange \[Rule] {{Min[rng] - 1.2, 
                  Max[rng]\  + 0.8}, {\(-0.04\), Max[liste] + \ 0.1}}, 
            AxesOrigin \[Rule] {Min[rng] - 1, 0}]; \[IndentingNewLine] (*\ 
            AxesLabel \[Rule] {k, 
                Subscript[h, k]}\ *) \[IndentingNewLine]mue = 
            liste . rng; \[IndentingNewLine]sigma = 
            Sqrt[liste . \((\((rng - 
                        mue)\)^2)\)]; \
\[IndentingNewLine]{{"\<Erwartungswert\>", mue, 
              N[mue]}, {"\<Standardabweichung\>", sigma, 
              N[sigma]}})\);\)\), "\[IndentingNewLine]", 
    \(f[{1, 4, 4, 2}, {3, 4, 5, 6}]\), "\[IndentingNewLine]", 
    \(f[{1, 6, 4, 1}, {1, 2, 3, 4}]\), "\[IndentingNewLine]", 
    \(f[{1, 3, 3, 4, 5, 1}, {\(-1\), 0, 1, 2, 3, 
        4}]\), "\[IndentingNewLine]", 
    \(f[{1, 2, 5, 4, 5, 1}, {\(-4\), \(-3\), \(-2\), \(-1\), 0, 
        1}]\), "\[IndentingNewLine]", 
    \(f[{1, 2, 4, 6, 4, 2}, {\(-2\), \(-1\), 0, 1, 2, 
        3}]\), "\[IndentingNewLine]", 
    \(f[{0, 1, 2, 6, 2, 0}, {0, 1, 2, 3, 4, 5}]\), "\[IndentingNewLine]", 
    \(f[{1, 0, 0, 1}, {4, 5, 6, 7}]\), "\[IndentingNewLine]", 
    \(f[{1, 1, 1, 1}, {4, 5, 6, 7}]\), "\[IndentingNewLine]", 
    \(f[{0, 0, 0, 1, 0}, {2, 3, 4, 5, 6}]\), "\n", 
    \(f[{1, 0, 1, 1, 1}, {\(-3\), \(-2\), \(-1\), 0, 1}]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.36 0.2 0.0490857 1.22714 [
[.24 .03659 -5.90625 -15.875 ]
[.24 .03659 5.90625 0 ]
[.44 .03659 -5.90625 -15.875 ]
[.44 .03659 5.90625 0 ]
[.64 .03659 -5.90625 -15.875 ]
[.64 .03659 5.90625 0 ]
[.84 .03659 -5.90625 -15.875 ]
[.84 .03659 5.90625 0 ]
[.0275 .1718 -27.4375 -7.9375 ]
[.0275 .1718 0 7.9375 ]
[.0275 .29451 -27.4375 -7.9375 ]
[.0275 .29451 0 7.9375 ]
[.0275 .41723 -27.4375 -7.9375 ]
[.0275 .41723 0 7.9375 ]
[.0275 .53994 -27.4375 -7.9375 ]
[.0275 .53994 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.24 .04909 m
.24 .05534 L
s
gsave
.24 .03659 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.44 .04909 m
.44 .05534 L
s
gsave
.44 .03659 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.64 .04909 m
.64 .05534 L
s
gsave
.64 .03659 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.84 .04909 m
.84 .05534 L
s
gsave
.84 .03659 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
.125 Mabswid
.08 .04909 m
.08 .05284 L
s
.12 .04909 m
.12 .05284 L
s
.16 .04909 m
.16 .05284 L
s
.2 .04909 m
.2 .05284 L
s
.28 .04909 m
.28 .05284 L
s
.32 .04909 m
.32 .05284 L
s
.36 .04909 m
.36 .05284 L
s
.4 .04909 m
.4 .05284 L
s
.48 .04909 m
.48 .05284 L
s
.52 .04909 m
.52 .05284 L
s
.56 .04909 m
.56 .05284 L
s
.6 .04909 m
.6 .05284 L
s
.68 .04909 m
.68 .05284 L
s
.72 .04909 m
.72 .05284 L
s
.76 .04909 m
.76 .05284 L
s
.8 .04909 m
.8 .05284 L
s
.88 .04909 m
.88 .05284 L
s
.92 .04909 m
.92 .05284 L
s
.96 .04909 m
.96 .05284 L
s
.25 Mabswid
0 .04909 m
1 .04909 L
s
.04 .1718 m
.04625 .1718 L
s
gsave
.0275 .1718 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.04 .29451 m
.04625 .29451 L
s
gsave
.0275 .29451 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.04 .41723 m
.04625 .41723 L
s
gsave
.0275 .41723 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.04 .53994 m
.04625 .53994 L
s
gsave
.0275 .53994 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.125 Mabswid
.04 .07363 m
.04375 .07363 L
s
.04 .09817 m
.04375 .09817 L
s
.04 .12271 m
.04375 .12271 L
s
.04 .14726 m
.04375 .14726 L
s
.04 .19634 m
.04375 .19634 L
s
.04 .22089 m
.04375 .22089 L
s
.04 .24543 m
.04375 .24543 L
s
.04 .26997 m
.04375 .26997 L
s
.04 .31906 m
.04375 .31906 L
s
.04 .3436 m
.04375 .3436 L
s
.04 .36814 m
.04375 .36814 L
s
.04 .39269 m
.04375 .39269 L
s
.04 .44177 m
.04375 .44177 L
s
.04 .46631 m
.04375 .46631 L
s
.04 .49086 m
.04375 .49086 L
s
.04 .5154 m
.04375 .5154 L
s
.04 .02454 m
.04375 .02454 L
s
.04 .56449 m
.04375 .56449 L
s
.04 .58903 m
.04375 .58903 L
s
.04 .61357 m
.04375 .61357 L
s
.25 Mabswid
.04 0 m
.04 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.24 .16064 Mdot
.44 .49532 Mdot
.64 .49532 Mdot
.84 .2722 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool00:H0oooo000g0?ooo`<00000
703oool3000001L0oooo1000000J0?ooo`<000005@3oool003H0oooo00D000000?ooo`3oool0oooo
0000000L0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0F0?ooo`050000003oool0oooo0?ooo`000000503oool003X0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01H0oooo00D000000?ooo`3oool0
oooo0000000D0?ooo`00>P3oool00`000000oooo0?ooo`0F0?ooo`H000006`3oool00`000000oooo
0?ooo`0F0?ooo`050000003oool0oooo0?ooo`000000503oool003P0oooo0P00000J0?ooo`040000
003oool0oooo000001P0oooo1000000I0?ooo`@000005@3oool001d0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo000001P0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0F0?ooo`007@3oool00`000000oooo0?ooo`0F0?ooo`050000
003oool0oooo0?ooo`0000006P3oool00`000000oooo0000000H0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool05@3oool001d0oooo00<000000?ooo`3oool05`3oool3000001`0oooo
0P00000H0?ooo`D000006P3oool3000001@0oooo000M0?ooo`030000003oool0oooo08H0oooo000M
0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`03
0000003oool0oooo08H0oooo000G0?ooohl00000000M0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool05@3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?oo
o`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0
QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool0
01d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo
00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<00000
0?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0603oool30?l006/0oooo000M0?ooo`03
0000003oool0oooo01L0oooo1@3o001Z0?ooo`00103oool4000000D0oooo0P0000050?ooo`D00000
103oool00`000000oooo0?ooo`0F0?ooo`L0o`00J@3oool000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`8000001`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo01H0oooo1`3o001Y0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool2000001L0oooo1`3o001Y0?ooo`000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0G0?ooo`D0o`00JP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool30?l006/0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02@3oool3000000H0oooo00<000000?ooo`3oool0QP3oool000@0oooo1000000>
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?oo
o`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0
QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool0
01d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0K@3oool30?l001H0
oooo000M0?ooo`030000003oool0oooo06`0oooo1@3o000E0?ooo`007@3oool00`000000oooo0?oo
o`1[0?ooo`L0o`00503oool000@0oooo100000050?ooo`800000103oool5000000D0oooo00<00000
0?ooo`3oool0J`3oool70?l001@0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3oool2000000@0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0
oooo06/0oooo1`3o000D0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1/0?ooo`D0o`005@3oool000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0
oooo0P00001^0?ooo`<0o`005P3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`08
0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`260?ooo`00103oool4
000000`0oooo0`0000060?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo
08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo
000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?oo
o`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000
003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0
oooo08H0oooo00040?ooo`@000001@3oool2000000D0oooo0`0000060?ooo`030000003oool0oooo
08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0
oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo08H0oooo00030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`80
0000Q`3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0:0?ooo`8000001P3oool00`000000oooo0?ooo`260?ooo`000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00P0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo08H0oooo00040?oo
o`@00000303oool3000000H0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3o
ool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0=@3o
ool30?l001T0oooo0`3o000b0?ooo`007@3oool00`000000oooo0?ooo`0d0?ooo`D0o`005`3oool5
0?l00340oooo000M0?ooo`030000003oool0oooo03<0oooo1`3o000E0?ooo`L0o`00<03oool001d0
oooo00<000000?ooo`3oool0<`3oool70?l001D0oooo1`3o000`0?ooo`007@3oool00`000000oooo
0?ooo`0c0?ooo`L0o`005@3oool70?l00300oooo000M0?ooo`030000003oool0oooo03@0oooo1@3o
000G0?ooo`D0o`00<@3oool001d0oooo00<000000?ooo`3oool0=@3oool30?l001T0oooo0`3o000b
0?ooo`00103oool4000000D0oooo0P0000070?ooo`<00000103oool00`000000oooo0?ooo`260?oo
o`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000080?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`H00000103o
ool2000008L0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000050?ooo`030000003o
ool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool0
0`000000oooo000000050?ooo`030000003oool0oooo08H0oooo00040?ooo`@000003P3oool20000
00D0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo
00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<00000
0?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3o
ool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool00:H0oooo0000\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {0.972876, -0.110973, \
0.0351563, 0.00572979}}],

Cell[BoxData[
    \({{"Erwartungswert", 51\/11, 
        4.636363636363637`}, {"Standardabweichung", \@94\/11, 
        0.8813963377120599`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.04 0.2 0.0386271 0.965678 [
[.24 .02613 -5.90625 -15.875 ]
[.24 .02613 5.90625 0 ]
[.44 .02613 -5.90625 -15.875 ]
[.44 .02613 5.90625 0 ]
[.64 .02613 -5.90625 -15.875 ]
[.64 .02613 5.90625 0 ]
[.84 .02613 -5.90625 -15.875 ]
[.84 .02613 5.90625 0 ]
[.0275 .13519 -27.4375 -7.9375 ]
[.0275 .13519 0 7.9375 ]
[.0275 .23176 -27.4375 -7.9375 ]
[.0275 .23176 0 7.9375 ]
[.0275 .32833 -27.4375 -7.9375 ]
[.0275 .32833 0 7.9375 ]
[.0275 .4249 -27.4375 -7.9375 ]
[.0275 .4249 0 7.9375 ]
[.0275 .52147 -27.4375 -7.9375 ]
[.0275 .52147 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.24 .03863 m
.24 .04488 L
s
gsave
.24 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.44 .03863 m
.44 .04488 L
s
gsave
.44 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.64 .03863 m
.64 .04488 L
s
gsave
.64 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.84 .03863 m
.84 .04488 L
s
gsave
.84 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.125 Mabswid
.08 .03863 m
.08 .04238 L
s
.12 .03863 m
.12 .04238 L
s
.16 .03863 m
.16 .04238 L
s
.2 .03863 m
.2 .04238 L
s
.28 .03863 m
.28 .04238 L
s
.32 .03863 m
.32 .04238 L
s
.36 .03863 m
.36 .04238 L
s
.4 .03863 m
.4 .04238 L
s
.48 .03863 m
.48 .04238 L
s
.52 .03863 m
.52 .04238 L
s
.56 .03863 m
.56 .04238 L
s
.6 .03863 m
.6 .04238 L
s
.68 .03863 m
.68 .04238 L
s
.72 .03863 m
.72 .04238 L
s
.76 .03863 m
.76 .04238 L
s
.8 .03863 m
.8 .04238 L
s
.88 .03863 m
.88 .04238 L
s
.92 .03863 m
.92 .04238 L
s
.96 .03863 m
.96 .04238 L
s
.25 Mabswid
0 .03863 m
1 .03863 L
s
.04 .13519 m
.04625 .13519 L
s
gsave
.0275 .13519 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.04 .23176 m
.04625 .23176 L
s
gsave
.0275 .23176 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.04 .32833 m
.04625 .32833 L
s
gsave
.0275 .32833 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.04 .4249 m
.04625 .4249 L
s
gsave
.0275 .4249 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.04 .52147 m
.04625 .52147 L
s
gsave
.0275 .52147 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.04 .05794 m
.04375 .05794 L
s
.04 .07725 m
.04375 .07725 L
s
.04 .09657 m
.04375 .09657 L
s
.04 .11588 m
.04375 .11588 L
s
.04 .15451 m
.04375 .15451 L
s
.04 .17382 m
.04375 .17382 L
s
.04 .19314 m
.04375 .19314 L
s
.04 .21245 m
.04375 .21245 L
s
.04 .25108 m
.04375 .25108 L
s
.04 .27039 m
.04375 .27039 L
s
.04 .2897 m
.04375 .2897 L
s
.04 .30902 m
.04375 .30902 L
s
.04 .34764 m
.04375 .34764 L
s
.04 .36696 m
.04375 .36696 L
s
.04 .38627 m
.04375 .38627 L
s
.04 .40558 m
.04375 .40558 L
s
.04 .44421 m
.04375 .44421 L
s
.04 .46353 m
.04375 .46353 L
s
.04 .48284 m
.04375 .48284 L
s
.04 .50215 m
.04375 .50215 L
s
.04 .54078 m
.04375 .54078 L
s
.04 .56009 m
.04375 .56009 L
s
.04 .57941 m
.04375 .57941 L
s
.04 .59872 m
.04375 .59872 L
s
.04 .01931 m
.04375 .01931 L
s
.25 Mabswid
.04 0 m
.04 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.24 .1191 Mdot
.44 .52147 Mdot
.64 .36052 Mdot
.84 .1191 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool003L0oooo1@00000G0?ooo`D0
0000603oool3000001`0oooo0`00000D0?ooo`00>@3oool00`000000oooo0?ooo`0G0?ooo`050000
003oool0oooo0?ooo`0000005`3oool01@000000oooo0?ooo`3oool0000001`0oooo00<000000?oo
o`3oool04`3oool003T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool04`3oool003T0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01H0oooo1P00000D0?ooo`00>@3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01P0oooo0P00000J0?ooo`040000003o
ool0oooo000001D0oooo000i0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo000001D0oooo000g0?ooo`<000006@3o
ool01@000000oooo0?ooo`3oool0000001L0oooo00D000000?ooo`3oool0oooo0000000J0?ooo`03
0000003oool0000001D0oooo000M0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
603oool3000001T0oooo0`00000L0?ooo`8000005@3oool001d0oooo00<000000?ooo`3oool0QP3o
ool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0
oooo00<000000?ooo`3oool0QP3oool001L0ooooS`00000001d0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo000M0?ooo`030000003oool0
oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0
oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M
0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`03
0000003oool0oooo01P0oooo0`3o001B0?ooo`<0o`005P3oool001d0oooo00<000000?ooo`3oool0
5`3oool50?l00500oooo1@3o000E0?ooo`00103oool4000000D0oooo0P0000050?ooo`D00000103o
ool00`000000oooo0?ooo`0F0?ooo`L0o`00CP3oool70?l001@0oooo00030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool2000000L0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0F0?ooo`L0o`00CP3oool70?l001@0oooo00030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
01H0oooo1`3o001>0?ooo`L0o`00503oool000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0P00000H0?ooo`D0o`00D03oool50?l001D0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo01P0oooo0`3o001B0?ooo`<0o`005P3oool000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`09
0?ooo`<000001P3oool00`000000oooo0?ooo`260?ooo`00103oool4000000h0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00
7@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`260?ooo`00103oool4000000D0oooo0P0000040?ooo`D000001@3oool00`000000oooo
0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P00
00040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`260?ooo`000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool01@3oool2000008L0oooo00030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool0QP3oool000@0oooo1000000<0?ooo`<000001P3oool00`000000oooo0?ooo`260?ooo`007@3o
ool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`00
0000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo
0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0oooo0P000005
0?ooo`<000001P3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001@3oool0
0`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool00`3oool2000008L0oooo00030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo08H0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool2000000H0oooo
00<000000?ooo`3oool0D@3oool30?l00380oooo00030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0500oooo1@3o
000a0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0oooo04l0oooo1`3o000`0?ooo`00103oool4
000000`0oooo0`0000060?ooo`030000003oool0oooo04l0oooo1`3o000`0?ooo`007@3oool00`00
0000oooo0?ooo`1?0?ooo`L0o`00<03oool001d0oooo00<000000?ooo`3oool0D03oool50?l00340
oooo000M0?ooo`030000003oool0oooo0540oooo0`3o000b0?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?oo
o`00103oool4000000D0oooo0P0000070?ooo`<00000103oool00`000000oooo0?ooo`260?ooo`00
0`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000080?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo0P0000270?ooo`000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo1P0000040?ooo`030000003oool0
oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool01000
0000oooo0?ooo`0000050?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000050?ooo`030000003oool0
oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool00`00
0000oooo000000050?ooo`030000003oool0oooo08H0oooo00040?ooo`@000003P3oool2000000D0
oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<0
00000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?oo
o`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool000@0oooo100000050?ooo`800000
1@3oool4000000D0oooo00<000000?ooo`3oool0=@3oool30?l004h0oooo00030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03@0oooo1@3o001=0?ooo`000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0c0?ooo`L0o`00C03oool000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo0P00000d0?ooo`L0o`00C03oool000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`@000001@3oool00`000000
oooo0?ooo`0c0?ooo`L0o`00C03oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0=03oool50?l004d0oooo
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo03D0oooo0`3o001>0?ooo`00103oool4000000`0oooo1@000004
0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`03
0000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003o
ool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo
08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo
000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo0000\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {-1.02712, -0.135606, \
0.0351563, 0.00728115}}],

Cell[BoxData[
    \({{"Erwartungswert", 29\/12, 
        2.4166666666666665`}, {"Standardabweichung", \@83\/12, 
        0.7592027982620249`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.314286 0.142857 0.0569462 1.42366 [
[.17143 .04445 -10.2188 -15.875 ]
[.17143 .04445 10.2188 0 ]
[.31429 .04445 -5.90625 -15.875 ]
[.31429 .04445 5.90625 0 ]
[.45714 .04445 -5.90625 -15.875 ]
[.45714 .04445 5.90625 0 ]
[.6 .04445 -5.90625 -15.875 ]
[.6 .04445 5.90625 0 ]
[.74286 .04445 -5.90625 -15.875 ]
[.74286 .04445 5.90625 0 ]
[.88571 .04445 -5.90625 -15.875 ]
[.88571 .04445 5.90625 0 ]
[.01607 .19931 -27.4375 -7.9375 ]
[.01607 .19931 0 7.9375 ]
[.01607 .34168 -27.4375 -7.9375 ]
[.01607 .34168 0 7.9375 ]
[.01607 .48404 -27.4375 -7.9375 ]
[.01607 .48404 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17143 .05695 m
.17143 .0632 L
s
gsave
.17143 .04445 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.31429 .05695 m
.31429 .0632 L
s
gsave
.31429 .04445 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.45714 .05695 m
.45714 .0632 L
s
gsave
.45714 .04445 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.6 .05695 m
.6 .0632 L
s
gsave
.6 .04445 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.74286 .05695 m
.74286 .0632 L
s
gsave
.74286 .04445 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.88571 .05695 m
.88571 .0632 L
s
gsave
.88571 .04445 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.125 Mabswid
.05714 .05695 m
.05714 .0607 L
s
.08571 .05695 m
.08571 .0607 L
s
.11429 .05695 m
.11429 .0607 L
s
.14286 .05695 m
.14286 .0607 L
s
.2 .05695 m
.2 .0607 L
s
.22857 .05695 m
.22857 .0607 L
s
.25714 .05695 m
.25714 .0607 L
s
.28571 .05695 m
.28571 .0607 L
s
.34286 .05695 m
.34286 .0607 L
s
.37143 .05695 m
.37143 .0607 L
s
.4 .05695 m
.4 .0607 L
s
.42857 .05695 m
.42857 .0607 L
s
.48571 .05695 m
.48571 .0607 L
s
.51429 .05695 m
.51429 .0607 L
s
.54286 .05695 m
.54286 .0607 L
s
.57143 .05695 m
.57143 .0607 L
s
.62857 .05695 m
.62857 .0607 L
s
.65714 .05695 m
.65714 .0607 L
s
.68571 .05695 m
.68571 .0607 L
s
.71429 .05695 m
.71429 .0607 L
s
.77143 .05695 m
.77143 .0607 L
s
.8 .05695 m
.8 .0607 L
s
.82857 .05695 m
.82857 .0607 L
s
.85714 .05695 m
.85714 .0607 L
s
0 .05695 m
0 .0607 L
s
.91429 .05695 m
.91429 .0607 L
s
.94286 .05695 m
.94286 .0607 L
s
.97143 .05695 m
.97143 .0607 L
s
.25 Mabswid
0 .05695 m
1 .05695 L
s
.02857 .19931 m
.03482 .19931 L
s
gsave
.01607 .19931 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.02857 .34168 m
.03482 .34168 L
s
gsave
.01607 .34168 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02857 .48404 m
.03482 .48404 L
s
gsave
.01607 .48404 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.125 Mabswid
.02857 .08542 m
.03232 .08542 L
s
.02857 .11389 m
.03232 .11389 L
s
.02857 .14237 m
.03232 .14237 L
s
.02857 .17084 m
.03232 .17084 L
s
.02857 .22778 m
.03232 .22778 L
s
.02857 .25626 m
.03232 .25626 L
s
.02857 .28473 m
.03232 .28473 L
s
.02857 .3132 m
.03232 .3132 L
s
.02857 .37015 m
.03232 .37015 L
s
.02857 .39862 m
.03232 .39862 L
s
.02857 .4271 m
.03232 .4271 L
s
.02857 .45557 m
.03232 .45557 L
s
.02857 .02847 m
.03232 .02847 L
s
.02857 .51252 m
.03232 .51252 L
s
.02857 .54099 m
.03232 .54099 L
s
.02857 .56946 m
.03232 .56946 L
s
.02857 .59794 m
.03232 .59794 L
s
.25 Mabswid
.02857 0 m
.02857 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.17143 .14069 Mdot
.31429 .30818 Mdot
.45714 .30818 Mdot
.6 .39192 Mdot
.74286 .47567 Mdot
.88571 .14069 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00<`3o
ool5000000/0oooo1000000@0?ooo`D000003P3oool500000100oooo0`00000C0?ooo`<000003P3o
ool003D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool0000000l0oooo00D0
00000?ooo`3oool0oooo0000000C0?ooo`030000003oool0oooo00d0oooo000Z0?ooo`H000001@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0=0?ooo`00=@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool03@3oool6000000h0oooo000M0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`8000004@3oool01000
0000oooo0?ooo`00000?0?ooo`007@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`040000003oool0oooo
000000l0oooo000M0?ooo`030000003oool0oooo01<0oooo0`00000<0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool03@3oool300000100oooo00D000000?ooo`3oool0oooo0000000?
0?ooo`050000003oool0oooo0?ooo`0000004@3oool00`000000oooo0000000?0?ooo`007@3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0oooo1000000B0?ooo`030000003oool0
oooo00l0oooo0`00000A0?ooo`<000004`3oool2000000l0oooo000M0?ooo`030000003oool0oooo
08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo
000M0?ooo`030000003oool0oooo08H0oooo000I0?ooohd00000000M0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00h0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo
000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?oo
o`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000
003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo0100oooo0`3o001Q0?ooo`<0o`003`3o
ool001d0oooo00<000000?ooo`3oool03`3oool50?l005l0oooo1@3o000>0?ooo`007@3oool00`00
0000oooo0?ooo`0>0?ooo`L0o`00G@3oool70?l000d0oooo000M0?ooo`030000003oool0oooo00h0
oooo1`3o001M0?ooo`L0o`003@3oool001d0oooo00<000000?ooo`3oool03P3oool70?l005d0oooo
1`3o000=0?ooo`007@3oool00`000000oooo0?ooo`0?0?ooo`D0o`00G`3oool50?l000h0oooo000M
0?ooo`030000003oool0oooo0100oooo0`3o001Q0?ooo`<0o`003`3oool001d0oooo00<000000?oo
o`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool000@0oooo100000050?ooo`800000
1@3oool5000000@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`8000001`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`040?ooo`800000Q`3oool000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`<000001P3oool00`000000oooo0?oo
o`260?ooo`00103oool4000000h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`26
0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00
7@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`0T0?ooo`<0o`004@3oool30?l004/0oooo000M0?ooo`030000003oool0oooo02<0oooo
1@3o000?0?ooo`D0o`00BP3oool001d0oooo00<000000?ooo`3oool08P3oool70?l000d0oooo1`3o
00190?ooo`007@3oool00`000000oooo0?ooo`0R0?ooo`L0o`003@3oool70?l004T0oooo000M0?oo
o`030000003oool0oooo0280oooo1`3o000=0?ooo`L0o`00B@3oool001d0oooo00<000000?ooo`3o
ool08`3oool50?l000l0oooo1@3o001:0?ooo`00103oool4000000D0oooo0P0000040?ooo`D00000
1@3oool00`000000oooo0?ooo`0T0?ooo`<0o`004@3oool30?l004/0oooo00030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0oooo00D000000?ooo`3oool0oooo
000000050?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`060?ooo`800000Q`3oool000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`050000
003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`1<0?ooo`<0o`00=`3oool000@0oooo
1000000<0?ooo`<000001P3oool00`000000oooo0?ooo`1;0?ooo`D0o`00=P3oool001d0oooo00<0
00000?ooo`3oool0BP3oool70?l003D0oooo000M0?ooo`030000003oool0oooo04X0oooo1`3o000e
0?ooo`007@3oool00`000000oooo0?ooo`1:0?ooo`L0o`00=@3oool001d0oooo00<000000?ooo`3o
ool0B`3oool50?l003H0oooo000M0?ooo`030000003oool0oooo04`0oooo0`3o000g0?ooo`007@3o
ool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`00
0000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo
0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`1P0?ooo`<0o`008`3oool001d0oooo00<00000
0?ooo`3oool0G`3oool50?l00280oooo00040?ooo`@000001@3oool2000000D0oooo0`0000060?oo
o`030000003oool0oooo05h0oooo1`3o000Q0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo0?ooo`1N0?ooo`L0o`008@3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo0P00001O0?ooo`L0o`008@3oool000<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0G`3oool50?l00280oooo00030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02P3oool2000000H0oooo00<000000?ooo`3oool0H03oool30?l002<0oooo0003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0203oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0QP3oool0
00@0oooo1000000<0?ooo`<000001P3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?oo
o`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3o
ool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`00
0000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo
0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`26
0?ooo`00YP3oool00:H0oooo0000\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {-3.45386, -0.101837, \
0.0497973, 0.0049969}}],

Cell[BoxData[
    \({{"Erwartungswert", 29\/17, 
        1.7058823529411764`}, {"Standardabweichung", \(2\ \@134\)\/17, 
        1.3618631650341442`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.742857 0.142857 0.0591735 1.47934 [
[.17143 .04667 -10.2188 -15.875 ]
[.17143 .04667 10.2188 0 ]
[.31429 .04667 -10.2188 -15.875 ]
[.31429 .04667 10.2188 0 ]
[.45714 .04667 -10.2188 -15.875 ]
[.45714 .04667 10.2188 0 ]
[.6 .04667 -10.2188 -15.875 ]
[.6 .04667 10.2188 0 ]
[.74286 .04667 -5.90625 -15.875 ]
[.74286 .04667 5.90625 0 ]
[.88571 .04667 -5.90625 -15.875 ]
[.88571 .04667 5.90625 0 ]
[.01607 .20711 -27.4375 -7.9375 ]
[.01607 .20711 0 7.9375 ]
[.01607 .35504 -27.4375 -7.9375 ]
[.01607 .35504 0 7.9375 ]
[.01607 .50297 -27.4375 -7.9375 ]
[.01607 .50297 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17143 .05917 m
.17143 .06542 L
s
gsave
.17143 .04667 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.31429 .05917 m
.31429 .06542 L
s
gsave
.31429 .04667 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.45714 .05917 m
.45714 .06542 L
s
gsave
.45714 .04667 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.6 .05917 m
.6 .06542 L
s
gsave
.6 .04667 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.74286 .05917 m
.74286 .06542 L
s
gsave
.74286 .04667 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.88571 .05917 m
.88571 .06542 L
s
gsave
.88571 .04667 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.05714 .05917 m
.05714 .06292 L
s
.08571 .05917 m
.08571 .06292 L
s
.11429 .05917 m
.11429 .06292 L
s
.14286 .05917 m
.14286 .06292 L
s
.2 .05917 m
.2 .06292 L
s
.22857 .05917 m
.22857 .06292 L
s
.25714 .05917 m
.25714 .06292 L
s
.28571 .05917 m
.28571 .06292 L
s
.34286 .05917 m
.34286 .06292 L
s
.37143 .05917 m
.37143 .06292 L
s
.4 .05917 m
.4 .06292 L
s
.42857 .05917 m
.42857 .06292 L
s
.48571 .05917 m
.48571 .06292 L
s
.51429 .05917 m
.51429 .06292 L
s
.54286 .05917 m
.54286 .06292 L
s
.57143 .05917 m
.57143 .06292 L
s
.62857 .05917 m
.62857 .06292 L
s
.65714 .05917 m
.65714 .06292 L
s
.68571 .05917 m
.68571 .06292 L
s
.71429 .05917 m
.71429 .06292 L
s
.77143 .05917 m
.77143 .06292 L
s
.8 .05917 m
.8 .06292 L
s
.82857 .05917 m
.82857 .06292 L
s
.85714 .05917 m
.85714 .06292 L
s
0 .05917 m
0 .06292 L
s
.91429 .05917 m
.91429 .06292 L
s
.94286 .05917 m
.94286 .06292 L
s
.97143 .05917 m
.97143 .06292 L
s
1 .05917 m
1 .06292 L
s
.25 Mabswid
0 .05917 m
1 .05917 L
s
.02857 .20711 m
.03482 .20711 L
s
gsave
.01607 .20711 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.02857 .35504 m
.03482 .35504 L
s
gsave
.01607 .35504 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02857 .50297 m
.03482 .50297 L
s
gsave
.01607 .50297 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.125 Mabswid
.02857 .08876 m
.03232 .08876 L
s
.02857 .11835 m
.03232 .11835 L
s
.02857 .14793 m
.03232 .14793 L
s
.02857 .17752 m
.03232 .17752 L
s
.02857 .23669 m
.03232 .23669 L
s
.02857 .26628 m
.03232 .26628 L
s
.02857 .29587 m
.03232 .29587 L
s
.02857 .32545 m
.03232 .32545 L
s
.02857 .38463 m
.03232 .38463 L
s
.02857 .41421 m
.03232 .41421 L
s
.02857 .4438 m
.03232 .4438 L
s
.02857 .47339 m
.03232 .47339 L
s
.02857 .02959 m
.03232 .02959 L
s
.02857 .53256 m
.03232 .53256 L
s
.02857 .56215 m
.03232 .56215 L
s
.02857 .59173 m
.03232 .59173 L
s
.25 Mabswid
.02857 0 m
.02857 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.17143 .14136 Mdot
.31429 .22354 Mdot
.45714 .4701 Mdot
.6 .38791 Mdot
.74286 .4701 Mdot
.88571 .14136 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00=@3o
ool3000000l0oooo0`00000@0?ooo`D00000403oool5000000/0oooo1000000@0?ooo`D000003P3o
ool003H0oooo00<000000?ooo`3oool03@3oool01@000000oooo0?ooo`3oool0000000l0oooo00D0
00000?ooo`3oool0oooo0000000B0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo000Z0?ooo`H000001P3o
ool00`000000oooo0?ooo`050?ooo`H000001P3oool00`000000oooo0?ooo`050?ooo`H000000`3o
ool00`000000oooo0?ooo`080?ooo`H000001@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`00<P3oool6
00000180oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo000M0?ooo`030000003oool0oooo01<0oooo00@000000?ooo`3oool000004@3oool2
000001<0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`007@3oool00`00
0000oooo0?ooo`0C0?ooo`040000003oool0oooo000001<0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo000M0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`0000003`3oool01@000000oooo0?ooo`3oool0000000l0oooo00D00000
0?ooo`3oool0oooo0000000@0?ooo`<00000303oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00d0oooo0`00000@0?ooo`007@3oool00`000000oooo0?ooo`0E0?ooo`800000403oool3
00000140oooo0`00000C0?ooo`030000003oool0oooo00/0oooo1000000B0?ooo`030000003oool0
oooo00h0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0
oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000I
0?ooohd00000000I0?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo
00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00@000000?ooo`3oool0oooo0@00000001d0oooo00<000000?ooo`3oool0QP3o
ool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0
oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<0
00000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?oo
o`3oool0403oool30?l00640oooo0`3o000?0?ooo`007@3oool00`000000oooo0?ooo`0?0?ooo`D0
o`00G`3oool50?l000h0oooo000M0?ooo`030000003oool0oooo00h0oooo1`3o001M0?ooo`L0o`00
3@3oool001d0oooo00<000000?ooo`3oool03P3oool70?l005d0oooo1`3o000=0?ooo`007@3oool0
0`000000oooo0?ooo`0>0?ooo`L0o`00G@3oool70?l000d0oooo000M0?ooo`030000003oool0oooo
00l0oooo1@3o001O0?ooo`D0o`003P3oool001d0oooo00<000000?ooo`3oool0403oool30?l00640
oooo0`3o000?0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`00103oool4000000D0oooo0P0000050?ooo`D00000103oool00`000000oooo0?ooo`26
0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000070?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0903oool30?l005l0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`040?ooo`800000903oool50?l005h0oooo00030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0280oooo1`3o001M0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0R0?ooo`L0o`00G@3oool0
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`<000001P3oool00`00
0000oooo0?ooo`0R0?ooo`L0o`00G@3oool000@0oooo1000000>0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool08`3oool50?l005h0oooo000M0?ooo`030000003oool0oooo02@0oooo
0`3o001O0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`26
0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00
7@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0oooo0P0000040?oo
o`D000001@3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool2000008L0oooo
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo04`0oooo0`3o000g0?ooo`000`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1;
0?ooo`D0o`00=P3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?oo
o`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`1:0?ooo`L0o`00=@3oool0
00@0oooo1000000<0?ooo`<000001P3oool00`000000oooo0?ooo`1:0?ooo`L0o`00=@3oool001d0
oooo00<000000?ooo`3oool0BP3oool70?l003D0oooo000M0?ooo`030000003oool0oooo04/0oooo
1@3o000f0?ooo`007@3oool00`000000oooo0?ooo`1<0?ooo`<0o`00=`3oool001d0oooo00<00000
0?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3o
ool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3o
ool001d0oooo00<000000?ooo`3oool0>03oool30?l002D0oooo0`3o000S0?ooo`007@3oool00`00
0000oooo0?ooo`0g0?ooo`D0o`008`3oool50?l00280oooo000M0?ooo`030000003oool0oooo03H0
oooo1`3o000Q0?ooo`L0o`008@3oool001d0oooo00<000000?ooo`3oool0=P3oool70?l00240oooo
1`3o000Q0?ooo`007@3oool00`000000oooo0?ooo`0f0?ooo`L0o`008@3oool70?l00240oooo0004
0?ooo`@000001@3oool2000000D0oooo0`0000060?ooo`030000003oool0oooo03L0oooo1@3o000S
0?ooo`D0o`008P3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`800000103oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0>03oool3
0?l002D0oooo0`3o000S0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool00`3oool2000008L0oooo00030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo08H0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool2000000H0oooo
00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000001@3o
ool00`000000oooo0?ooo`260?ooo`00103oool4000000`0oooo0`0000060?ooo`030000003oool0
oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0
oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M
0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`03
0000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003o
ool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo
08H0oooo000M0?ooo`030000003oool0oooo08H0oooo002V0?ooo`00YP3oool00001\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {-6.45386, -0.0987592, \
0.0497973, 0.00480883}}],

Cell[BoxData[
    \({{"Erwartungswert", \(-\(23\/18\)\), \(-1.2777777777777777`\)}, \
{"Standardabweichung", \@533\/18, 1.2825995978461329`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.457143 0.142857 0.0542385 1.35596 [
[.17143 .04174 -10.2188 -15.875 ]
[.17143 .04174 10.2188 0 ]
[.31429 .04174 -10.2188 -15.875 ]
[.31429 .04174 10.2188 0 ]
[.45714 .04174 -5.90625 -15.875 ]
[.45714 .04174 5.90625 0 ]
[.6 .04174 -5.90625 -15.875 ]
[.6 .04174 5.90625 0 ]
[.74286 .04174 -5.90625 -15.875 ]
[.74286 .04174 5.90625 0 ]
[.88571 .04174 -5.90625 -15.875 ]
[.88571 .04174 5.90625 0 ]
[.01607 .18983 -27.4375 -7.9375 ]
[.01607 .18983 0 7.9375 ]
[.01607 .32543 -27.4375 -7.9375 ]
[.01607 .32543 0 7.9375 ]
[.01607 .46103 -27.4375 -7.9375 ]
[.01607 .46103 0 7.9375 ]
[.01607 .59662 -27.4375 -7.9375 ]
[.01607 .59662 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17143 .05424 m
.17143 .06049 L
s
gsave
.17143 .04174 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.31429 .05424 m
.31429 .06049 L
s
gsave
.31429 .04174 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.45714 .05424 m
.45714 .06049 L
s
gsave
.45714 .04174 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.6 .05424 m
.6 .06049 L
s
gsave
.6 .04174 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.74286 .05424 m
.74286 .06049 L
s
gsave
.74286 .04174 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.88571 .05424 m
.88571 .06049 L
s
gsave
.88571 .04174 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.125 Mabswid
.05714 .05424 m
.05714 .05799 L
s
.08571 .05424 m
.08571 .05799 L
s
.11429 .05424 m
.11429 .05799 L
s
.14286 .05424 m
.14286 .05799 L
s
.2 .05424 m
.2 .05799 L
s
.22857 .05424 m
.22857 .05799 L
s
.25714 .05424 m
.25714 .05799 L
s
.28571 .05424 m
.28571 .05799 L
s
.34286 .05424 m
.34286 .05799 L
s
.37143 .05424 m
.37143 .05799 L
s
.4 .05424 m
.4 .05799 L
s
.42857 .05424 m
.42857 .05799 L
s
.48571 .05424 m
.48571 .05799 L
s
.51429 .05424 m
.51429 .05799 L
s
.54286 .05424 m
.54286 .05799 L
s
.57143 .05424 m
.57143 .05799 L
s
.62857 .05424 m
.62857 .05799 L
s
.65714 .05424 m
.65714 .05799 L
s
.68571 .05424 m
.68571 .05799 L
s
.71429 .05424 m
.71429 .05799 L
s
.77143 .05424 m
.77143 .05799 L
s
.8 .05424 m
.8 .05799 L
s
.82857 .05424 m
.82857 .05799 L
s
.85714 .05424 m
.85714 .05799 L
s
0 .05424 m
0 .05799 L
s
.91429 .05424 m
.91429 .05799 L
s
.94286 .05424 m
.94286 .05799 L
s
.97143 .05424 m
.97143 .05799 L
s
.25 Mabswid
0 .05424 m
1 .05424 L
s
.02857 .18983 m
.03482 .18983 L
s
gsave
.01607 .18983 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.02857 .32543 m
.03482 .32543 L
s
gsave
.01607 .32543 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02857 .46103 m
.03482 .46103 L
s
gsave
.01607 .46103 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.02857 .59662 m
.03482 .59662 L
s
gsave
.01607 .59662 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.125 Mabswid
.02857 .08136 m
.03232 .08136 L
s
.02857 .10848 m
.03232 .10848 L
s
.02857 .1356 m
.03232 .1356 L
s
.02857 .16272 m
.03232 .16272 L
s
.02857 .21695 m
.03232 .21695 L
s
.02857 .24407 m
.03232 .24407 L
s
.02857 .27119 m
.03232 .27119 L
s
.02857 .29831 m
.03232 .29831 L
s
.02857 .35255 m
.03232 .35255 L
s
.02857 .37967 m
.03232 .37967 L
s
.02857 .40679 m
.03232 .40679 L
s
.02857 .43391 m
.03232 .43391 L
s
.02857 .48815 m
.03232 .48815 L
s
.02857 .51527 m
.03232 .51527 L
s
.02857 .54239 m
.03232 .54239 L
s
.02857 .5695 m
.03232 .5695 L
s
.02857 .02712 m
.03232 .02712 L
s
.25 Mabswid
.02857 0 m
.02857 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.17143 .12561 Mdot
.31429 .19697 Mdot
.45714 .3397 Mdot
.6 .48244 Mdot
.74286 .3397 Mdot
.88571 .19697 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00<P3oool500000100oooo1@00000;0?oo
o`@00000403oool5000000h0oooo1@00000@0?ooo`<00000403oool00380oooo00D000000?ooo`3o
ool0oooo0000000B0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00D000000?ooo`3oool0oooo0000000?
0?ooo`050000003oool0oooo0?ooo`0000003`3oool002X0oooo1P0000030?ooo`030000003oool0
oooo00P0oooo1P0000050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0=0?ooo`00=03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`00=@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool200000100
oooo000M0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool001d0oooo00<0
00000?ooo`3oool04P3oool01@000000oooo0?ooo`3oool000000100oooo0`00000<0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool03@3oool300000100oooo00D000000?ooo`3oool0
oooo0000000?0?ooo`050000003oool0oooo0?ooo`0000003`3oool001d0oooo00<000000?ooo`3o
ool04`3oool3000001<0oooo00<000000?ooo`3oool02`3oool400000180oooo00<000000?ooo`3o
ool03`3oool300000140oooo0`00000@0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3o
ool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`00
0000oooo0?ooo`260?ooo`006@3ooon=000000006@3oool01@000000oooo0?ooo`3oool0000000<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo000M0?ooo`03
0000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003o
ool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo
08H0oooo000M0?ooo`030000003oool0oooo0100oooo0`3o001c0?ooo`007@3oool00`000000oooo
0?ooo`0?0?ooo`D0o`00LP3oool001d0oooo00<000000?ooo`3oool03P3oool70?l00740oooo000M
0?ooo`030000003oool0oooo00h0oooo1`3o001a0?ooo`007@3oool00`000000oooo0?ooo`0>0?oo
o`L0o`00L@3oool001d0oooo00<000000?ooo`3oool03`3oool50?l00780oooo000M0?ooo`030000
003oool0oooo0100oooo0`3o001c0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0
oooo0P0000050?ooo`D00000103oool00`000000oooo0?ooo`0T0?ooo`<0o`00C@3oool30?l000l0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`D0o`00B`3oool50?l000h0oooo
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`040?ooo`8000008`3oool70?l004T0oooo1`3o000=0?ooo`000`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0R
0?ooo`L0o`00B@3oool70?l000d0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0280oooo1`3o00190?oo
o`L0o`003@3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool08`3oool50?l004/0oooo1@3o000>0?ooo`00
0`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo0`0000060?ooo`030000
003oool0oooo02@0oooo0`3o001=0?ooo`<0o`003`3oool000@0oooo1000000>0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool0
01d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo
00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<00000
0?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3o
ool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3o
ool001d0oooo00<000000?ooo`3oool0QP3oool000@0oooo100000050?ooo`800000103oool50000
00D0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`800000103oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?oo
o`3oool0>03oool30?l002D0oooo0`3o000S0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool2000003P0oooo1@3o000S0?ooo`D0
o`008P3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0=P3oool70?l00240oooo1`3o000Q0?ooo`000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0f0?ooo`L0o`008@3oool70?l00240oooo00030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo03H0oooo1`3o000Q0?ooo`L0o`008@3oool000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`0g
0?ooo`D0o`008`3oool50?l00280oooo00040?ooo`@00000303oool3000000H0oooo00<000000?oo
o`3oool0>03oool30?l002D0oooo0`3o000S0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00
7@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?oo
o`007@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0oooo0P0000050?ooo`<00000
1P3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo
0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool00`3oool2000004d0oooo0`3o000g0?ooo`000`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1;
0?ooo`D0o`00=P3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?oo
o`8000001P3oool00`000000oooo0?ooo`1:0?ooo`L0o`00=@3oool000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0BP3oool70?l003D0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
203oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0BP3oool70?l003D0
oooo00040?ooo`@00000303oool3000000H0oooo00<000000?ooo`3oool0B`3oool50?l003H0oooo
000M0?ooo`030000003oool0oooo04`0oooo0`3o000g0?ooo`007@3oool00`000000oooo0?ooo`26
0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00
7@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`00103oool4000000D0oooo0P0000070?ooo`<00000103oool00`000000oooo0?ooo`26
0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000080?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo0P0000270?ooo`00
0`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo1P0000040?ooo`030000
003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3o
ool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000050?ooo`030000
003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0000002>0?ooo`00103oool4000000h0oooo0P00002>0?ooo`00YP3oool00:H0
oooo002V0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {-4.45386, -0.0929969, \
0.0497973, 0.00524639}}],

Cell[BoxData[
    \({{"Erwartungswert", 16\/19, 
        0.8421052631578947`}, {"Standardabweichung", \@618\/19, 
        1.3084003047006372`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.171429 0.142857 0.0360656 0.901641 [
[.17143 .02357 -5.90625 -15.875 ]
[.17143 .02357 5.90625 0 ]
[.31429 .02357 -5.90625 -15.875 ]
[.31429 .02357 5.90625 0 ]
[.45714 .02357 -5.90625 -15.875 ]
[.45714 .02357 5.90625 0 ]
[.6 .02357 -5.90625 -15.875 ]
[.6 .02357 5.90625 0 ]
[.74286 .02357 -5.90625 -15.875 ]
[.74286 .02357 5.90625 0 ]
[.88571 .02357 -5.90625 -15.875 ]
[.88571 .02357 5.90625 0 ]
[.01607 .12623 -27.4375 -7.9375 ]
[.01607 .12623 0 7.9375 ]
[.01607 .21639 -27.4375 -7.9375 ]
[.01607 .21639 0 7.9375 ]
[.01607 .30656 -27.4375 -7.9375 ]
[.01607 .30656 0 7.9375 ]
[.01607 .39672 -27.4375 -7.9375 ]
[.01607 .39672 0 7.9375 ]
[.01607 .48689 -27.4375 -7.9375 ]
[.01607 .48689 0 7.9375 ]
[.01607 .57705 -27.4375 -7.9375 ]
[.01607 .57705 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17143 .03607 m
.17143 .04232 L
s
gsave
.17143 .02357 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.31429 .03607 m
.31429 .04232 L
s
gsave
.31429 .02357 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.45714 .03607 m
.45714 .04232 L
s
gsave
.45714 .02357 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.6 .03607 m
.6 .04232 L
s
gsave
.6 .02357 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.74286 .03607 m
.74286 .04232 L
s
gsave
.74286 .02357 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.88571 .03607 m
.88571 .04232 L
s
gsave
.88571 .02357 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.125 Mabswid
.05714 .03607 m
.05714 .03982 L
s
.08571 .03607 m
.08571 .03982 L
s
.11429 .03607 m
.11429 .03982 L
s
.14286 .03607 m
.14286 .03982 L
s
.2 .03607 m
.2 .03982 L
s
.22857 .03607 m
.22857 .03982 L
s
.25714 .03607 m
.25714 .03982 L
s
.28571 .03607 m
.28571 .03982 L
s
.34286 .03607 m
.34286 .03982 L
s
.37143 .03607 m
.37143 .03982 L
s
.4 .03607 m
.4 .03982 L
s
.42857 .03607 m
.42857 .03982 L
s
.48571 .03607 m
.48571 .03982 L
s
.51429 .03607 m
.51429 .03982 L
s
.54286 .03607 m
.54286 .03982 L
s
.57143 .03607 m
.57143 .03982 L
s
.62857 .03607 m
.62857 .03982 L
s
.65714 .03607 m
.65714 .03982 L
s
.68571 .03607 m
.68571 .03982 L
s
.71429 .03607 m
.71429 .03982 L
s
.77143 .03607 m
.77143 .03982 L
s
.8 .03607 m
.8 .03982 L
s
.82857 .03607 m
.82857 .03982 L
s
.85714 .03607 m
.85714 .03982 L
s
.91429 .03607 m
.91429 .03982 L
s
.94286 .03607 m
.94286 .03982 L
s
.97143 .03607 m
.97143 .03982 L
s
.25 Mabswid
0 .03607 m
1 .03607 L
s
.02857 .12623 m
.03482 .12623 L
s
gsave
.01607 .12623 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.02857 .21639 m
.03482 .21639 L
s
gsave
.01607 .21639 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02857 .30656 m
.03482 .30656 L
s
gsave
.01607 .30656 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.02857 .39672 m
.03482 .39672 L
s
gsave
.01607 .39672 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.02857 .48689 m
.03482 .48689 L
s
gsave
.01607 .48689 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.02857 .57705 m
.03482 .57705 L
s
gsave
.01607 .57705 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.125 Mabswid
.02857 .0541 m
.03232 .0541 L
s
.02857 .07213 m
.03232 .07213 L
s
.02857 .09016 m
.03232 .09016 L
s
.02857 .1082 m
.03232 .1082 L
s
.02857 .14426 m
.03232 .14426 L
s
.02857 .1623 m
.03232 .1623 L
s
.02857 .18033 m
.03232 .18033 L
s
.02857 .19836 m
.03232 .19836 L
s
.02857 .23443 m
.03232 .23443 L
s
.02857 .25246 m
.03232 .25246 L
s
.02857 .27049 m
.03232 .27049 L
s
.02857 .28853 m
.03232 .28853 L
s
.02857 .32459 m
.03232 .32459 L
s
.02857 .34262 m
.03232 .34262 L
s
.02857 .36066 m
.03232 .36066 L
s
.02857 .37869 m
.03232 .37869 L
s
.02857 .41475 m
.03232 .41475 L
s
.02857 .43279 m
.03232 .43279 L
s
.02857 .45082 m
.03232 .45082 L
s
.02857 .46885 m
.03232 .46885 L
s
.02857 .50492 m
.03232 .50492 L
s
.02857 .52295 m
.03232 .52295 L
s
.02857 .54098 m
.03232 .54098 L
s
.02857 .55902 m
.03232 .55902 L
s
.02857 .01803 m
.03232 .01803 L
s
.02857 .59508 m
.03232 .59508 L
s
.02857 .61312 m
.03232 .61312 L
s
.25 Mabswid
.02857 0 m
.02857 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.17143 .03607 Mdot
.31429 .11803 Mdot
.45714 .2 Mdot
.6 .52787 Mdot
.74286 .2 Mdot
.88571 .03607 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00;`3oool400000100oooo1@00000>0?oo
o`D00000403oool3000001<0oooo0`00000?0?ooo`@000003`3oool002h0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00D000000?ooo`3o
ool0oooo0000000?0?ooo`050000003oool0oooo0?ooo`0000004`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool002h0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool0303oool002h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`H0
00004`3oool00`000000oooo0?ooo`0<0?ooo`00;P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`800000
4@3oool010000000oooo0?ooo`00000@0?ooo`@000003`3oool002h0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0>0?ooo`040000003oool0oooo00000100oooo00<000000?ooo`3o
ool0403oool002h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`<00000
403oool01@000000oooo0?ooo`3oool0000000l0oooo00D000000?ooo`3oool0oooo0000000A0?oo
o`030000003oool000000100oooo00<000000?ooo`3oool0403oool001d0oooo00<000000?ooo`3o
ool03`3oool400000180oooo00<000000?ooo`3oool03`3oool300000140oooo0`00000C0?ooo`80
0000403oool5000000h0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003o
ool0oooo0100oooo0`3o001Q0?ooo`<0o`003`3oool001d0oooo00<000000?ooo`3oool03`3oool5
0?l005l0oooo1@3o000>0?ooo`007@3oool00`000000oooo0?ooo`0>0?ooo`L0o`00G@3oool70?l0
00d0oooo000I0?oooaD000001`3o001M000000L0o`003@00000001d0oooo00D000000?ooo`3oool0
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000o`000?l000050?l0
00050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000
oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0
oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00D000000?ooo`3oool0oooo000000070?l000050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`020?ooo`007@3oool00`000000oooo0?ooo`0?0?ooo`D0o`00G`3o
ool50?l000h0oooo000M0?ooo`030000003oool0oooo0100oooo0`3o001Q0?ooo`<0o`003`3oool0
01d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo
00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<00000
0?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0903oool30?l005l0oooo000M0?ooo`03
0000003oool0oooo02<0oooo1@3o001N0?ooo`00103oool4000000D0oooo0P0000050?ooo`D00000
103oool00`000000oooo0?ooo`0R0?ooo`L0o`00G@3oool000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`8000001`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0280oooo1`3o001M0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool2000002<0oooo1`3o001M0?ooo`000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0S0?ooo`D0o`00GP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0903oool30?l005l0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02@3oool3000000H0oooo00<000000?ooo`3oool0QP3oool000@0oooo1000000>
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?oo
o`3oool0QP3oool001d0oooo00<000000?ooo`3oool0>03oool30?l002D0oooo0`3o000S0?ooo`00
7@3oool00`000000oooo0?ooo`0g0?ooo`D0o`008`3oool50?l00280oooo000M0?ooo`030000003o
ool0oooo03H0oooo1`3o000Q0?ooo`L0o`008@3oool000@0oooo100000050?ooo`800000103oool5
000000D0oooo00<000000?ooo`3oool0=P3oool70?l00240oooo1`3o000Q0?ooo`000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo
0?ooo`0000001@3oool00`000000oooo0?ooo`0f0?ooo`L0o`008@3oool70?l00240oooo00030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo03L0oooo1@3o000S0?ooo`D0o`008P3oool000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo0P00000i0?ooo`<0
o`009@3oool30?l002<0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool0
1@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0QP3oool000@0oooo1000000<
0?ooo`<000001P3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?oo
o`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3o
ool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00103oool40000
00D0oooo0P0000050?ooo`<000001P3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?oo
o`0000001@3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool2000008L0oooo00030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3o
ool2000000H0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0QP3oool0
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo
0?ooo`0000001@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000`0oooo0`0000060?oo
o`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000
003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0
oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo00040?ooo`@000001@3oool2000000L0
oooo0`0000040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool2000000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool00`3oool2000008L0oooo00030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0203oool6000000@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0000000D0oooo00<000000?oo
o`3oool0QP3oool000@0oooo1000000>0?ooo`8000001@3oool00`000000oooo0?ooo`260?ooo`00
7@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0
oooo0P0000050?ooo`@000001@3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool00P3oool2000008L0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool02@3oool4000000D0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0C03oool30?l003L0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04/0oooo1@3o000f0?ooo`00103o
ool4000000`0oooo1@0000040?ooo`030000003oool0oooo04X0oooo1`3o000e0?ooo`007@3oool0
0`000000oooo0?ooo`1:0?ooo`L0o`00=@3oool001d0oooo00<000000?ooo`3oool0BP3oool70?l0
03D0oooo000M0?ooo`030000003oool0oooo04/0oooo1@3o000f0?ooo`007@3oool00`000000oooo
0?ooo`1<0?ooo`<0o`00=`3oool001d0oooo00<000000?ooo`3oool0QP3oool000@0oooo10000005
0?ooo`8000001P3oool3000000D0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`8000001@3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`000000103oool2000008L0oooo00030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`090?ooo`@000001@3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000h0oooo0`00
00040?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo002V0?oo
o`00YP3oool00001\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {-2.45386, -0.140629, \
0.0497973, 0.00788994}}],

Cell[BoxData[
    \({{"Erwartungswert", 31\/11, 
        2.8181818181818183`}, {"Standardabweichung", \(2\ \@21\)\/11, 
        0.8331955809010618`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.56 0.2 0.0386271 0.965678 [
[.24 .02613 -5.90625 -15.875 ]
[.24 .02613 5.90625 0 ]
[.44 .02613 -5.90625 -15.875 ]
[.44 .02613 5.90625 0 ]
[.64 .02613 -5.90625 -15.875 ]
[.64 .02613 5.90625 0 ]
[.84 .02613 -5.90625 -15.875 ]
[.84 .02613 5.90625 0 ]
[.0275 .13519 -27.4375 -7.9375 ]
[.0275 .13519 0 7.9375 ]
[.0275 .23176 -27.4375 -7.9375 ]
[.0275 .23176 0 7.9375 ]
[.0275 .32833 -27.4375 -7.9375 ]
[.0275 .32833 0 7.9375 ]
[.0275 .4249 -27.4375 -7.9375 ]
[.0275 .4249 0 7.9375 ]
[.0275 .52147 -27.4375 -7.9375 ]
[.0275 .52147 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.24 .03863 m
.24 .04488 L
s
gsave
.24 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.44 .03863 m
.44 .04488 L
s
gsave
.44 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.64 .03863 m
.64 .04488 L
s
gsave
.64 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
.84 .03863 m
.84 .04488 L
s
gsave
.84 .02613 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
1.000 setlinewidth
grestore
.125 Mabswid
.08 .03863 m
.08 .04238 L
s
.12 .03863 m
.12 .04238 L
s
.16 .03863 m
.16 .04238 L
s
.2 .03863 m
.2 .04238 L
s
.28 .03863 m
.28 .04238 L
s
.32 .03863 m
.32 .04238 L
s
.36 .03863 m
.36 .04238 L
s
.4 .03863 m
.4 .04238 L
s
.48 .03863 m
.48 .04238 L
s
.52 .03863 m
.52 .04238 L
s
.56 .03863 m
.56 .04238 L
s
.6 .03863 m
.6 .04238 L
s
.68 .03863 m
.68 .04238 L
s
.72 .03863 m
.72 .04238 L
s
.76 .03863 m
.76 .04238 L
s
.8 .03863 m
.8 .04238 L
s
0 .03863 m
0 .04238 L
s
.88 .03863 m
.88 .04238 L
s
.92 .03863 m
.92 .04238 L
s
.96 .03863 m
.96 .04238 L
s
.25 Mabswid
0 .03863 m
1 .03863 L
s
.04 .13519 m
.04625 .13519 L
s
gsave
.0275 .13519 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.04 .23176 m
.04625 .23176 L
s
gsave
.0275 .23176 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.04 .32833 m
.04625 .32833 L
s
gsave
.0275 .32833 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.04 .4249 m
.04625 .4249 L
s
gsave
.0275 .4249 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.04 .52147 m
.04625 .52147 L
s
gsave
.0275 .52147 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.04 .05794 m
.04375 .05794 L
s
.04 .07725 m
.04375 .07725 L
s
.04 .09657 m
.04375 .09657 L
s
.04 .11588 m
.04375 .11588 L
s
.04 .15451 m
.04375 .15451 L
s
.04 .17382 m
.04375 .17382 L
s
.04 .19314 m
.04375 .19314 L
s
.04 .21245 m
.04375 .21245 L
s
.04 .25108 m
.04375 .25108 L
s
.04 .27039 m
.04375 .27039 L
s
.04 .2897 m
.04375 .2897 L
s
.04 .30902 m
.04375 .30902 L
s
.04 .34764 m
.04375 .34764 L
s
.04 .36696 m
.04375 .36696 L
s
.04 .38627 m
.04375 .38627 L
s
.04 .40558 m
.04375 .40558 L
s
.04 .44421 m
.04375 .44421 L
s
.04 .46353 m
.04375 .46353 L
s
.04 .48284 m
.04375 .48284 L
s
.04 .50215 m
.04375 .50215 L
s
.04 .54078 m
.04375 .54078 L
s
.04 .56009 m
.04375 .56009 L
s
.04 .57941 m
.04375 .57941 L
s
.04 .59872 m
.04375 .59872 L
s
.04 .01931 m
.04375 .01931 L
s
.25 Mabswid
.04 0 m
.04 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.24 .52147 Mdot
.44 .03863 Mdot
.64 .03863 Mdot
.84 .52147 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool003T0oooo0`00000H0?ooo`@0
00006@3oool3000001/0oooo00<000000?ooo`3oool0503oool003X0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01D0oooo00D000000?ooo`3oool0
oooo0000000J0?ooo`030000003oool0oooo01@0oooo000j0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool05@3oool01@000000oooo0?ooo`3oool0000001X0oooo00<000000?ooo`3o
ool0503oool003H0oooo1P00000L0?ooo`030000003oool0oooo01D0oooo00D000000?ooo`3oool0
oooo0000000K0?ooo`030000003oool0oooo01<0oooo000g0?ooo`040000003oool0oooo000001T0
oooo1000000H0?ooo`@00000703oool00`000000oooo0?ooo`0C0?ooo`00=`3oool010000000oooo
0?ooo`00000I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool07P3oool00`000000
oooo0?ooo`0B0?ooo`00>03oool00`000000oooo0000000I0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0180oooo
000M0?ooo`030000003oool0oooo01T0oooo0P00000I0?ooo`D000006@3oool3000001L0oooo1P00
000D0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`0e0?oo
o`<0o`006@3oool30?l00380oooo000M0?ooo`030000003oool0oooo03@0oooo1@3o000G0?ooo`D0
o`00<@3oool001d0oooo00<000000?ooo`3oool0<`3oool70?l001D0oooo1`3o000`0?ooo`005`3o
ooll000000L0o`005@0000070?l003000000000G0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool01`3o00000`3oool000000?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`070?l00080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`007@3oool00`000000oooo0?ooo`0d0?ooo`D0o`005`3oool50?l0
0340oooo000M0?ooo`030000003oool0oooo03D0oooo0`3o000I0?ooo`<0o`00<P3oool001d0oooo
00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<00000
0?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3o
ool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3o
ool000@0oooo100000050?ooo`8000001@3oool5000000@0oooo00<000000?ooo`3oool0QP3oool0
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`8000001`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo08H0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`800000Q`3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?oo
o`<000001P3oool00`000000oooo0?ooo`260?ooo`00103oool4000000h0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3o
ool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`00
0000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo
0?ooo`260?ooo`00103oool4000000D0oooo0P0000040?ooo`D000001@3oool00`000000oooo0?oo
o`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P000004
0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`260?ooo`000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool01@3oool2000008L0oooo00030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo08H0
oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
QP3oool000@0oooo1000000<0?ooo`<000001P3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0oooo0P0000050?oo
o`<000001P3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool00`3oool2000008L0oooo00030?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo08H0oooo
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool2000000H0oooo00<0
00000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000001@3oool0
0`000000oooo0?ooo`260?ooo`00103oool4000000`0oooo0`0000060?ooo`030000003oool0oooo
08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo
000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?oo
o`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo00040?ooo`@00000
1@3oool2000000L0oooo0`0000040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000P0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool00`3oool2000008L0oooo00030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0203oool6000000@0oooo00<000000?ooo`3oool0QP3oool000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo0000
00D0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`090?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0QP3oool000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool0QP3oool000@0oooo1000000>0?ooo`8000001@3oool00`000000oooo
0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`26
0?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00
7@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0oooo0P0000050?ooo`@000001@3o
ool00`000000oooo0?ooo`0H0?ooo`<0o`00DP3oool30?l001H0oooo00030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo01L0oooo1@3o001@0?ooo`D0o`005@3oool0
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool05P3oool70?l004h0oooo1`3o000D0?ooo`000`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool2000001L0
oooo1`3o001>0?ooo`L0o`00503oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`090?ooo`@000001@3oool00`000000oooo0?ooo`0F0?ooo`L0o`00CP3oool70?l001@0oooo
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01L0oooo1@3o001@0?ooo`D0o`005@3oool000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0603oool30?l00580oooo0`3o000F0?ooo`00103oool4000000`0oooo1@0000040?oo
o`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000
003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0
oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0
oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M
0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo0000\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {1.97288, -0.135606, \
0.0351563, 0.00728115}}],

Cell[BoxData[
    \({{"Erwartungswert", 11\/2, 5.5`}, {"Standardabweichung", 3\/2, 
        1.5`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.56 0.2 0.0633881 1.5847 [
[.24 .05089 -5.90625 -15.875 ]
[.24 .05089 5.90625 0 ]
[.44 .05089 -5.90625 -15.875 ]
[.44 .05089 5.90625 0 ]
[.64 .05089 -5.90625 -15.875 ]
[.64 .05089 5.90625 0 ]
[.84 .05089 -5.90625 -15.875 ]
[.84 .05089 5.90625 0 ]
[.0275 .14262 -35.25 -7.9375 ]
[.0275 .14262 0 7.9375 ]
[.0275 .22186 -27.4375 -7.9375 ]
[.0275 .22186 0 7.9375 ]
[.0275 .30109 -35.25 -7.9375 ]
[.0275 .30109 0 7.9375 ]
[.0275 .38033 -27.4375 -7.9375 ]
[.0275 .38033 0 7.9375 ]
[.0275 .45956 -35.25 -7.9375 ]
[.0275 .45956 0 7.9375 ]
[.0275 .5388 -27.4375 -7.9375 ]
[.0275 .5388 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.24 .06339 m
.24 .06964 L
s
gsave
.24 .05089 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.44 .06339 m
.44 .06964 L
s
gsave
.44 .05089 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.64 .06339 m
.64 .06964 L
s
gsave
.64 .05089 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
.84 .06339 m
.84 .06964 L
s
gsave
.84 .05089 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
1.000 setlinewidth
grestore
.125 Mabswid
.08 .06339 m
.08 .06714 L
s
.12 .06339 m
.12 .06714 L
s
.16 .06339 m
.16 .06714 L
s
.2 .06339 m
.2 .06714 L
s
.28 .06339 m
.28 .06714 L
s
.32 .06339 m
.32 .06714 L
s
.36 .06339 m
.36 .06714 L
s
.4 .06339 m
.4 .06714 L
s
.48 .06339 m
.48 .06714 L
s
.52 .06339 m
.52 .06714 L
s
.56 .06339 m
.56 .06714 L
s
.6 .06339 m
.6 .06714 L
s
.68 .06339 m
.68 .06714 L
s
.72 .06339 m
.72 .06714 L
s
.76 .06339 m
.76 .06714 L
s
.8 .06339 m
.8 .06714 L
s
0 .06339 m
0 .06714 L
s
.88 .06339 m
.88 .06714 L
s
.92 .06339 m
.92 .06714 L
s
.96 .06339 m
.96 .06714 L
s
.25 Mabswid
0 .06339 m
1 .06339 L
s
.04 .14262 m
.04625 .14262 L
s
gsave
.0275 .14262 -96.25 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
1.000 setlinewidth
grestore
.04 .22186 m
.04625 .22186 L
s
gsave
.0275 .22186 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.04 .30109 m
.04625 .30109 L
s
gsave
.0275 .30109 -96.25 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
1.000 setlinewidth
grestore
.04 .38033 m
.04625 .38033 L
s
gsave
.0275 .38033 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.04 .45956 m
.04625 .45956 L
s
gsave
.0275 .45956 -96.25 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
1.000 setlinewidth
grestore
.04 .5388 m
.04625 .5388 L
s
gsave
.0275 .5388 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.125 Mabswid
.04 .07924 m
.04375 .07924 L
s
.04 .09508 m
.04375 .09508 L
s
.04 .11093 m
.04375 .11093 L
s
.04 .12678 m
.04375 .12678 L
s
.04 .15847 m
.04375 .15847 L
s
.04 .17432 m
.04375 .17432 L
s
.04 .19016 m
.04375 .19016 L
s
.04 .20601 m
.04375 .20601 L
s
.04 .23771 m
.04375 .23771 L
s
.04 .25355 m
.04375 .25355 L
s
.04 .2694 m
.04375 .2694 L
s
.04 .28525 m
.04375 .28525 L
s
.04 .31694 m
.04375 .31694 L
s
.04 .33279 m
.04375 .33279 L
s
.04 .34863 m
.04375 .34863 L
s
.04 .36448 m
.04375 .36448 L
s
.04 .39618 m
.04375 .39618 L
s
.04 .41202 m
.04375 .41202 L
s
.04 .42787 m
.04375 .42787 L
s
.04 .44372 m
.04375 .44372 L
s
.04 .47541 m
.04375 .47541 L
s
.04 .49126 m
.04375 .49126 L
s
.04 .5071 m
.04375 .5071 L
s
.04 .52295 m
.04375 .52295 L
s
.04 .55465 m
.04375 .55465 L
s
.04 .57049 m
.04375 .57049 L
s
.04 .58634 m
.04375 .58634 L
s
.04 .60219 m
.04375 .60219 L
s
.04 .04754 m
.04375 .04754 L
s
.04 .03169 m
.04375 .03169 L
s
.04 .01585 m
.04375 .01585 L
s
.25 Mabswid
.04 0 m
.04 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.24 .45956 Mdot
.44 .45956 Mdot
.64 .45956 Mdot
.84 .45956 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3o
ool00:H0oooo000o0?ooo`<000005P3oool4000001P0oooo0`00000I0?ooo`030000003oool0oooo
01<0oooo00100?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0D0?ooo`050000003oool0oooo0?ooo`000000603oool00`000000oooo0?ooo`0C0?oo
o`00@03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01@0oooo00D000000?ooo`3o
ool0oooo0000000H0?ooo`030000003oool0oooo01<0oooo000l0?ooo`H000006P3oool00`000000
oooo0?ooo`0D0?ooo`050000003oool0oooo0?ooo`0000006@3oool00`000000oooo0?ooo`0B0?oo
o`00903oool00`000000oooo0?ooo`0F0?ooo`040000003oool0oooo000001L0oooo1000000G0?oo
o`@000006P3oool00`000000oooo0?ooo`0B0?ooo`00903oool00`000000oooo0?ooo`0F0?ooo`04
0000003oool0oooo000001L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo0140oooo000T0?ooo`800000603oool00`000000oooo0000000G0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0140oooo000T0?ooo`030000003oool0oooo01P0oooo0P00000G0?ooo`D00000
603oool3000001D0oooo1P00000C0?ooo`00903oool200000800oooo000T0?ooo`030000003oool0
oooo07l0oooo000T0?ooo`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool001l0oooo
Q`00000001l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool002@0oooo0P0000200?ooo`00903oool00`00
0000oooo0?ooo`1o0?ooo`00903oool200000800oooo000T0?ooo`030000003oool0oooo07l0oooo
000T0?ooo`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool000@0oooo100000050?oo
o`8000001@3oool4000000@0oooo100000040?ooo`030000003oool0oooo07l0oooo00030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo0?ooo`800000P03oool0
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000840oooo00030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0P0000200?ooo`000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`3oool4000000@0oooo00<000000?ooo`3oool0O`3oool000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000070?ooo`800000P03oool000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000007
0?ooo`030000003oool0oooo07l0oooo00040?ooo`@00000303oool4000000@0oooo1@0000030?oo
o`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool002@0oooo0P0000200?ooo`00903o
ool00`000000oooo0?ooo`1o0?ooo`002`3oool4000000D0oooo0P0000050?ooo`D00000103oool2
00000800oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool20000
00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1o0?ooo`002P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool200000800
oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo07l0oooo000:0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`800000P03oool000X0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0O`3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?oo
o`<000001P3oool00`000000oooo0?ooo`1o0?ooo`002`3oool4000000h0oooo00<000000?ooo`3o
ool0103oool200000800oooo000T0?ooo`030000003oool0oooo07l0oooo000T0?ooo`800000P03o
ool002@0oooo00<000000?ooo`3oool0O`3oool000@0oooo100000050?ooo`8000001@3oool50000
00<0oooo100000040?ooo`800000P03oool000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`8000001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000210?ooo`000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`3oool20000
0800oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`000000P@3oool000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo100000040?ooo`80
0000P03oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1o0?ooo`000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo0`0000050?ooo`030000003o
ool0oooo00D0oooo0P0000200?ooo`00103oool4000000h0oooo00<000000?ooo`3oool00`3oool5
000000<0oooo00<000000?ooo`3oool0O`3oool002@0oooo0P0000200?ooo`00903oool00`000000
oooo0?ooo`1o0?ooo`002`3oool4000000D0oooo0P0000040?ooo`D000001@3oool200000800oooo
000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0oooo00D0
00000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo07l0oooo000:0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo07l0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`050?ooo`800000P03oool000X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0O`3oool000X0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0
oooo0P0000200?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo
00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo07l0oooo000;0?ooo`@00000
303oool3000000H0oooo0P0000200?ooo`00903oool00`000000oooo0?ooo`1o0?ooo`00903oool2
00000800oooo000T0?ooo`030000003oool0oooo07l0oooo00040?ooo`@000001@3oool2000000@0
oooo1@0000040?ooo`@00000103oool2000001L0oooo103o000G0?ooo`@0o`005`3oool40?l001L0
oooo103o000D0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
0P0000040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000005`3oool60?l001D0oooo1P3o000E0?ooo`H0o`005@3oool60?l0
01<0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`090?ooo`040000003oool0oooo0?ooo`8000005P3oool60?l001D0oooo1P3o000E0?oo
o`H0o`005@3oool60?l001<0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000005`3oool60?l0
01D0oooo1P3o000E0?ooo`H0o`005@3oool60?l001<0oooo00030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`@00000103oool2000001H0
oooo1P3o000E0?ooo`H0o`005@3oool60?l001D0oooo1P3o000C0?ooo`000`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo01H0oooo103o000G0?ooo`@0o`005`3oool40?l001L0oooo
103o000D0?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00D0oooo0P0000200?ooo`00103o
ool4000000`0oooo0`0000050?ooo`D000000`3oool00`000000oooo0?ooo`1o0?ooo`00903oool0
0`000000oooo0?ooo`1o0?ooo`00903oool200000800oooo000;0?ooo`@000001@3oool2000000D0
oooo0`0000060?ooo`030000003oool0oooo07l0oooo000:0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool2000000@0oooo00D000000?ooo`3oool0oooo000000050?ooo`80
0000P03oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0O`3oool000X0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo0P0000200?ooo`002P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo0P0000060?ooo`030000003oool0
oooo07l0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`030?ooo`800000P03oool000X0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`1o0?oo
o`002`3oool4000000`0oooo0`0000060?ooo`800000P03oool002@0oooo00<000000?ooo`3oool0
O`3oool002@0oooo0P0000200?ooo`00903oool00`000000oooo0?ooo`1o0?ooo`00903oool20000
0800oooo000T0?ooo`030000003oool0oooo07l0oooo000T0?ooo`030000003oool0oooo07l0oooo
002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool00001\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {1.62403, -0.106103, \
0.0372609, 0.00470258}}],

Cell[BoxData[
    \({{"Erwartungswert", 11\/2, 5.5`}, {"Standardabweichung", \@5\/2, 
        1.118033988749895`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.133333 0.166667 0.0216854 0.542135 [
[.2 .00919 -5.90625 -15.875 ]
[.2 .00919 5.90625 0 ]
[.36667 .00919 -5.90625 -15.875 ]
[.36667 .00919 5.90625 0 ]
[.53333 .00919 -5.90625 -15.875 ]
[.53333 .00919 5.90625 0 ]
[.7 .00919 -5.90625 -15.875 ]
[.7 .00919 5.90625 0 ]
[.86667 .00919 -5.90625 -15.875 ]
[.86667 .00919 5.90625 0 ]
[.02083 .13011 -27.4375 -7.9375 ]
[.02083 .13011 0 7.9375 ]
[.02083 .23854 -27.4375 -7.9375 ]
[.02083 .23854 0 7.9375 ]
[.02083 .34697 -27.4375 -7.9375 ]
[.02083 .34697 0 7.9375 ]
[.02083 .45539 -27.4375 -7.9375 ]
[.02083 .45539 0 7.9375 ]
[.02083 .56382 -11.8125 -7.9375 ]
[.02083 .56382 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2 .02169 m
.2 .02794 L
s
gsave
.2 .00919 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.36667 .02169 m
.36667 .02794 L
s
gsave
.36667 .00919 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.53333 .02169 m
.53333 .02794 L
s
gsave
.53333 .00919 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.7 .02169 m
.7 .02794 L
s
gsave
.7 .00919 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.86667 .02169 m
.86667 .02794 L
s
gsave
.86667 .00919 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
.125 Mabswid
.06667 .02169 m
.06667 .02544 L
s
.1 .02169 m
.1 .02544 L
s
.13333 .02169 m
.13333 .02544 L
s
.16667 .02169 m
.16667 .02544 L
s
.23333 .02169 m
.23333 .02544 L
s
.26667 .02169 m
.26667 .02544 L
s
.3 .02169 m
.3 .02544 L
s
.33333 .02169 m
.33333 .02544 L
s
.4 .02169 m
.4 .02544 L
s
.43333 .02169 m
.43333 .02544 L
s
.46667 .02169 m
.46667 .02544 L
s
.5 .02169 m
.5 .02544 L
s
.56667 .02169 m
.56667 .02544 L
s
.6 .02169 m
.6 .02544 L
s
.63333 .02169 m
.63333 .02544 L
s
.66667 .02169 m
.66667 .02544 L
s
.73333 .02169 m
.73333 .02544 L
s
.76667 .02169 m
.76667 .02544 L
s
.8 .02169 m
.8 .02544 L
s
.83333 .02169 m
.83333 .02544 L
s
.9 .02169 m
.9 .02544 L
s
.93333 .02169 m
.93333 .02544 L
s
.96667 .02169 m
.96667 .02544 L
s
.25 Mabswid
0 .02169 m
1 .02169 L
s
.03333 .13011 m
.03958 .13011 L
s
gsave
.02083 .13011 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.03333 .23854 m
.03958 .23854 L
s
gsave
.02083 .23854 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.03333 .34697 m
.03958 .34697 L
s
gsave
.02083 .34697 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.03333 .45539 m
.03958 .45539 L
s
gsave
.02083 .45539 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.03333 .56382 m
.03958 .56382 L
s
gsave
.02083 .56382 -72.8125 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.03333 .04879 m
.03708 .04879 L
s
.03333 .0759 m
.03708 .0759 L
s
.03333 .10301 m
.03708 .10301 L
s
.03333 .15722 m
.03708 .15722 L
s
.03333 .18433 m
.03708 .18433 L
s
.03333 .21143 m
.03708 .21143 L
s
.03333 .26565 m
.03708 .26565 L
s
.03333 .29275 m
.03708 .29275 L
s
.03333 .31986 m
.03708 .31986 L
s
.03333 .37407 m
.03708 .37407 L
s
.03333 .40118 m
.03708 .40118 L
s
.03333 .42829 m
.03708 .42829 L
s
.03333 .4825 m
.03708 .4825 L
s
.03333 .50961 m
.03708 .50961 L
s
.03333 .53671 m
.03708 .53671 L
s
.03333 .59093 m
.03708 .59093 L
s
.03333 .61803 m
.03708 .61803 L
s
.25 Mabswid
.03333 0 m
.03333 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.2 .02169 Mdot
.36667 .02169 Mdot
.53333 .02169 Mdot
.7 .56382 Mdot
.86667 .02169 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00<@3oool5000001@0oooo0`00000F0?oo
o`<000004`3oool4000001@0oooo0`00000B0?ooo`00<@3oool01@000000oooo0?ooo`3oool00000
01<0oooo00D000000?ooo`3oool0oooo0000000F0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`050000003oool0oooo0?ooo`0000004@3o
ool00380oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0403oool01@000000oooo0?ooo`3oool000000140oooo000c
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool6000001L0oooo00<00000
0?ooo`3oool0403oool01@000000oooo0?ooo`3oool000000140oooo000d0?ooo`030000003oool0
oooo01@0oooo0P00000D0?ooo`040000003oool0oooo000001@0oooo1000000C0?ooo`@000004P3o
ool003D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0A0?ooo`040000003oool0
oooo000001@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0C0?ooo`00<@3oool0
1@000000oooo0?ooo`3oool0000001<0oooo00D000000?ooo`3oool0oooo0000000D0?ooo`030000
003oool0000001@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0B0?ooo`00<P3o
ool3000001D0oooo0`00000F0?ooo`800000503oool5000001@0oooo0`00000A0?ooo`00YP3oool0
01d0oooo00<000000?ooo`3oool04`3oool30?l001D0oooo0`3o000D0?ooo`<0o`00;03oool30?l0
0180oooo000M0?ooo`030000003oool0oooo0180oooo1@3o000C0?ooo`D0o`004P3oool50?l002X0
oooo1@3o000A0?ooo`007@3oool00`000000oooo0?ooo`0A0?ooo`L0o`004@3oool70?l00100oooo
1`3o000X0?ooo`L0o`00403oool001P0oooo6@0000070?l0014000001`3o000@000000L0o`00:000
00070?l001000000000M0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo0080oooo00<000000?l0003o00001@3o00000`3oool000000?oo
o`030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?l000060?l000030?oo
o`000000oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003o0000o`0000D0o`0000<0oooo0000003oool00`3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`020?ooo`030000003o0000o`0000D0o`0000<0oooo0000
003oool00`3oool01@000000oooo0?ooo`3oool0000000D0oooo000M0?ooo`030000003oool0oooo
0180oooo1@3o000C0?ooo`D0o`004P3oool50?l002X0oooo1@3o000A0?ooo`007@3oool00`000000
oooo0?ooo`0C0?ooo`<0o`005@3oool30?l001@0oooo0`3o000/0?ooo`<0o`004P3oool001d0oooo
00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<00000
0?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3o
ool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3o
ool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool000@0
oooo100000050?ooo`800000103oool5000000D0oooo00<000000?ooo`3oool0QP3oool000<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000103oool01@000000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo0P0000270?ooo`000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`260?ooo`000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0
oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo08H0oooo00040?ooo`@0
0000303oool3000000H0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0
QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool0
01d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo
00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool000@0oooo10000005
0?ooo`8000001`3oool3000000@0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000203oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo08H0oooo00030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0203oool6000000@0oooo0P0000270?ooo`000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool00000
1@3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00T0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`260?ooo`000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`260?ooo`00103oool4000000h0oooo0P0000050?ooo`030000003oool0
oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0
oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M
0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`03
0000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo00040?ooo`@000001@3o
ool2000000H0oooo0`0000050?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool2000000D0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000000@0oooo0P0000270?ooo`000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool02@3oool4000000D0oooo00<000000?ooo`3oool0QP3oool000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0QP3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0QP3oool000@0oooo1000000>0?ooo`<00000
103oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool0
0`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000
oooo0?ooo`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`007@3oool00`000000oooo0?oo
o`260?ooo`007@3oool00`000000oooo0?ooo`260?ooo`00103oool4000000D0oooo0P0000050?oo
o`@000001@3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo0P0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`260?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000
Q`3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`260?ooo`000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo100000050?ooo`030000003oool0
oooo08H0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0QP3oool000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`260?ooo`00103oool4000000`0oooo
100000050?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M
0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`03
0000003oool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000M0?ooo`030000003o
ool0oooo08H0oooo000M0?ooo`030000003oool0oooo08H0oooo000C0?ooo`D000001@3oool00`00
0000oooo0?ooo`1J0?ooo`<0o`00:@3oool001D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`1I0?ooo`D0o`00:03oool001D0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`1H0?ooo`L0o`009`3oool001D0oooo00<000000?ooo`3oool01@3oool2000005T0oooo1`3o
000W0?ooo`005@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05P0oooo1`3o000W
0?ooo`005@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05T0oooo1@3o000X0?oo
o`004`3oool3000000L0oooo00<000000?ooo`3oool0FP3oool30?l002T0oooo000E0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3o
ool001d0oooo00<000000?ooo`3oool0QP3oool001d0oooo00<000000?ooo`3oool0QP3oool00001
\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {-0.248731, -0.230773, \
0.0425619, 0.0130847}}],

Cell[BoxData[
    \({{"Erwartungswert", 5, 5.`}, {"Standardabweichung", 0, 
        0.`}}\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.7 0.166667 0.0633881 1.5847 [
[.2 .05089 -10.2188 -15.875 ]
[.2 .05089 10.2188 0 ]
[.36667 .05089 -10.2188 -15.875 ]
[.36667 .05089 10.2188 0 ]
[.53333 .05089 -10.2188 -15.875 ]
[.53333 .05089 10.2188 0 ]
[.7 .05089 -5.90625 -15.875 ]
[.7 .05089 5.90625 0 ]
[.86667 .05089 -5.90625 -15.875 ]
[.86667 .05089 5.90625 0 ]
[.02083 .14262 -35.25 -7.9375 ]
[.02083 .14262 0 7.9375 ]
[.02083 .22186 -27.4375 -7.9375 ]
[.02083 .22186 0 7.9375 ]
[.02083 .30109 -35.25 -7.9375 ]
[.02083 .30109 0 7.9375 ]
[.02083 .38033 -27.4375 -7.9375 ]
[.02083 .38033 0 7.9375 ]
[.02083 .45956 -35.25 -7.9375 ]
[.02083 .45956 0 7.9375 ]
[.02083 .5388 -27.4375 -7.9375 ]
[.02083 .5388 0 7.9375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2 .06339 m
.2 .06964 L
s
gsave
.2 .05089 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.36667 .06339 m
.36667 .06964 L
s
gsave
.36667 .05089 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.53333 .06339 m
.53333 .06964 L
s
gsave
.53333 .05089 -71.2188 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
71.625 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.7 .06339 m
.7 .06964 L
s
gsave
.7 .05089 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.86667 .06339 m
.86667 .06964 L
s
gsave
.86667 .05089 -66.9063 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.06667 .06339 m
.06667 .06714 L
s
.1 .06339 m
.1 .06714 L
s
.13333 .06339 m
.13333 .06714 L
s
.16667 .06339 m
.16667 .06714 L
s
.23333 .06339 m
.23333 .06714 L
s
.26667 .06339 m
.26667 .06714 L
s
.3 .06339 m
.3 .06714 L
s
.33333 .06339 m
.33333 .06714 L
s
.4 .06339 m
.4 .06714 L
s
.43333 .06339 m
.43333 .06714 L
s
.46667 .06339 m
.46667 .06714 L
s
.5 .06339 m
.5 .06714 L
s
.56667 .06339 m
.56667 .06714 L
s
.6 .06339 m
.6 .06714 L
s
.63333 .06339 m
.63333 .06714 L
s
.66667 .06339 m
.66667 .06714 L
s
.73333 .06339 m
.73333 .06714 L
s
.76667 .06339 m
.76667 .06714 L
s
.8 .06339 m
.8 .06714 L
s
.83333 .06339 m
.83333 .06714 L
s
0 .06339 m
0 .06714 L
s
.9 .06339 m
.9 .06714 L
s
.93333 .06339 m
.93333 .06714 L
s
.96667 .06339 m
.96667 .06714 L
s
1 .06339 m
1 .06714 L
s
.25 Mabswid
0 .06339 m
1 .06339 L
s
.03333 .14262 m
.03958 .14262 L
s
gsave
.02083 .14262 -96.25 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
1.000 setlinewidth
grestore
.03333 .22186 m
.03958 .22186 L
s
gsave
.02083 .22186 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.03333 .30109 m
.03958 .30109 L
s
gsave
.02083 .30109 -96.25 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
1.000 setlinewidth
grestore
.03333 .38033 m
.03958 .38033 L
s
gsave
.02083 .38033 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.03333 .45956 m
.03958 .45956 L
s
gsave
.02083 .45956 -96.25 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
1.000 setlinewidth
grestore
.03333 .5388 m
.03958 .5388 L
s
gsave
.02083 .5388 -88.4375 -11.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 13.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
1.000 setlinewidth
grestore
.125 Mabswid
.03333 .07924 m
.03708 .07924 L
s
.03333 .09508 m
.03708 .09508 L
s
.03333 .11093 m
.03708 .11093 L
s
.03333 .12678 m
.03708 .12678 L
s
.03333 .15847 m
.03708 .15847 L
s
.03333 .17432 m
.03708 .17432 L
s
.03333 .19016 m
.03708 .19016 L
s
.03333 .20601 m
.03708 .20601 L
s
.03333 .23771 m
.03708 .23771 L
s
.03333 .25355 m
.03708 .25355 L
s
.03333 .2694 m
.03708 .2694 L
s
.03333 .28525 m
.03708 .28525 L
s
.03333 .31694 m
.03708 .31694 L
s
.03333 .33279 m
.03708 .33279 L
s
.03333 .34863 m
.03708 .34863 L
s
.03333 .36448 m
.03708 .36448 L
s
.03333 .39618 m
.03708 .39618 L
s
.03333 .41202 m
.03708 .41202 L
s
.03333 .42787 m
.03708 .42787 L
s
.03333 .44372 m
.03708 .44372 L
s
.03333 .47541 m
.03708 .47541 L
s
.03333 .49126 m
.03708 .49126 L
s
.03333 .5071 m
.03708 .5071 L
s
.03333 .52295 m
.03708 .52295 L
s
.03333 .55465 m
.03708 .55465 L
s
.03333 .57049 m
.03708 .57049 L
s
.03333 .58634 m
.03708 .58634 L
s
.03333 .60219 m
.03708 .60219 L
s
.03333 .04754 m
.03708 .04754 L
s
.03333 .03169 m
.03708 .03169 L
s
.03333 .01585 m
.03708 .01585 L
s
.25 Mabswid
.03333 0 m
.03333 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.05 w
.2 .45956 Mdot
.36667 .06339 Mdot
.53333 .45956 Mdot
.7 .45956 Mdot
.86667 .45956 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{166.75, 103},
  ImageMargins->{{40, 0}, {0, 74.875}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002V0000Ib000`400?l00000o`00003oYP3oool0
0:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00YP3o
ool00:H0oooo000m0?ooo`<000004P3oool500000180oooo1@00000=0?ooo`@000004`3oool50000
00l0oooo000l0?ooo`050000003oool0oooo0?ooo`0000004@3oool01@000000oooo0?ooo`3oool0
000001@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool03`3oool003<0oooo1P0000070?ooo`030000003oool0oooo
00L0oooo1P0000030?ooo`030000003oool0oooo00X0oooo1P0000050?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
00l0oooo00100?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0?0?ooo`00903oool00`000000oooo0?ooo`0G0?ooo`8000005@3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo00l0oooo000T0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo000T
0?ooo`8000005P3oool01@000000oooo0?ooo`3oool000000140oooo00D000000?ooo`3oool0oooo
0000000B0?ooo`<000003P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo
0`00000A0?ooo`00903oool00`000000oooo0?ooo`0F0?ooo`<000004`3oool3000001D0oooo00<0
00000?ooo`3oool03@3oool4000001D0oooo00<000000?ooo`3oool03`3oool002@0oooo0P000020
0?ooo`00903oool00`000000oooo0?ooo`1o0?ooo`00903oool2000002T0oooo103o001C0?ooo`00
903oool00`000000oooo0?ooo`0W0?ooo`H0o`00DP3oool00200oooo;P0000060?l005800000000P
0?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000@0oooo
00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0oooo0?ooo`000000103oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o00001@3o00000`3oool000000?ooo`03
0?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo
00@000000?ooo`3oool0oooo0@00000002@0oooo0P00000X0?ooo`H0o`00DP3oool002@0oooo00<0
00000?ooo`3oool0:03oool40?l005<0oooo000T0?ooo`030000003oool0oooo07l0oooo000T0?oo
o`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool002@0oooo0P0000200?ooo`00103o
ool4000000D0oooo0P0000050?ooo`@00000103oool4000000@0oooo00<000000?ooo`3oool0O`3o
ool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000103oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool0oooo
0P0000200?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000
P@3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool200000800oooo
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`020?ooo`040000003oool0oooo0?ooo`@00000103oool00`000000oooo0?ooo`1o0?ooo`000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool0000000L0oooo0P0000200?ooo`000`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool0000000L0oooo00<000000?ooo`3oool0O`3oool000@0oooo1000000<0?ooo`@00000103o
ool5000000<0oooo0P0000200?ooo`00903oool00`000000oooo0?ooo`1o0?ooo`00903oool20000
0800oooo000T0?ooo`030000003oool0oooo07l0oooo000;0?ooo`@000001@3oool2000000D0oooo
1@0000040?ooo`800000P03oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`8000001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo07l0oooo000:
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`04
0?ooo`800000P03oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0O`3oool000X0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0O`3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00@0oooo0P0000200?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00T0oooo0`0000060?ooo`030000003oool0oooo07l0oooo000;0?ooo`@000003P3oool0
0`000000oooo0?ooo`040?ooo`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool002@0
oooo0P0000200?ooo`00903oool00`000000oooo0?ooo`1o0?ooo`00103oool4000000D0oooo0P00
00050?ooo`D000000`3oool4000000@0oooo0P0000200?ooo`000`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo0P0000070?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000840oooo00030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`040000003oool0
oooo0?ooo`800000P03oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo000000210?ooo`000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00`3oool4
000000@0oooo0P0000200?ooo`000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
07l0oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool3000000D0
oooo00<000000?ooo`3oool01@3oool200000800oooo00040?ooo`@000003P3oool00`000000oooo
0?ooo`030?ooo`D000000`3oool00`000000oooo0?ooo`1o0?ooo`00903oool200000800oooo000T
0?ooo`030000003oool0oooo07l0oooo000;0?ooo`@000001@3oool2000000@0oooo1@0000050?oo
o`800000P03oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`80
0000103oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0O`3oool000X0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0O`3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00D0oooo0P0000200?ooo`002P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`1o0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool00`3oool200000800oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0203oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0O`3oool0
00/0oooo1000000<0?ooo`<000001P3oool200000800oooo000T0?ooo`030000003oool0oooo07l0
oooo000T0?ooo`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool000@0oooo10000005
0?ooo`800000103oool5000000@0oooo100000040?ooo`8000004`3oool40?l002P0oooo103o000B
0?ooo`@0o`004`3oool40?l00100oooo00030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3oool2000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo0000000C0?ooo`H0o`009P3oool60?l00100oooo1P3o
000A0?ooo`H0o`003`3oool000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool0oooo0P00000B0?ooo`H0o`009P3o
ool60?l00100oooo1P3o000A0?ooo`H0o`003`3oool000<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000
000C0?ooo`H0o`009P3oool60?l00100oooo1P3o000A0?ooo`H0o`003`3oool000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo10000004
0?ooo`8000004P3oool60?l002H0oooo1P3o000@0?ooo`H0o`004@3oool60?l000l0oooo00030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool40?l002P0oooo103o000B0?oo
o`@0o`004`3oool40?l00100oooo00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0203oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01@3oool20000
0800oooo00040?ooo`@00000303oool3000000D0oooo1@0000030?ooo`030000003oool0oooo07l0
oooo000T0?ooo`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool000/0oooo10000005
0?ooo`8000001@3oool3000000H0oooo00<000000?ooo`3oool0O`3oool000X0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000103oool01@000000oooo0?ooo`3oool0
000000D0oooo0P0000200?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1o0?ooo`002P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool200000800
oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool2000000H0oooo
00<000000?ooo`3oool0O`3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00<0oooo0P0000200?ooo`002P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003o
ool0oooo07l0oooo000;0?ooo`@00000303oool3000000H0oooo0P0000200?ooo`00903oool00`00
0000oooo0?ooo`1o0?ooo`00903oool200000800oooo000T0?ooo`030000003oool0oooo07l0oooo
000T0?ooo`800000P03oool002@0oooo00<000000?ooo`3oool0O`3oool002@0oooo00<000000?oo
o`3oool0O`3oool00:H0oooo002V0?ooo`00YP3oool00:H0oooo002V0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 165.75}, {102, 0}} -> {-5.66198, -0.108004, \
0.0450197, 0.00473484}}],

Cell[BoxData[
    \({{"Erwartungswert", \(-\(3\/4\)\), \(-0.75`\)}, {"Standardabweichung", \
\@35\/4, 1.479019945774904`}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowToolbars->"EditBar",
WindowSize->{902, 648},
WindowMargins->{{43, Automatic}, {Automatic, 0}},
Magnification->1,
StyleDefinitions -> "DemoText.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 183, 4, 70, "Title"],
Cell[1940, 57, 16, 0, 29, "Text"],

Cell[CellGroupData[{
Cell[1981, 61, 1799, 33, 400, "Input"],
Cell[3783, 96, 17147, 577, 194, 9955, 484, "GraphicsData", "PostScript", \
"Graphics"],
Cell[20933, 675, 155, 3, 67, "Output"],
Cell[21091, 680, 19381, 644, 194, 11120, 538, "GraphicsData", "PostScript", \
"Graphics"],
Cell[40475, 1326, 156, 3, 67, "Output"],
Cell[40634, 1331, 19026, 646, 194, 11624, 550, "GraphicsData", "PostScript", \
"Graphics"],
Cell[59663, 1979, 164, 3, 67, "Output"],
Cell[59830, 1984, 20208, 673, 194, 12278, 571, "GraphicsData", "PostScript", \
"Graphics"],
Cell[80041, 2659, 155, 2, 67, "Output"],
Cell[80199, 2663, 21326, 705, 194, 12881, 596, "GraphicsData", "PostScript", \
"Graphics"],
Cell[101528, 3370, 157, 3, 67, "Output"],
Cell[101688, 3375, 24297, 809, 194, 14800, 687, "GraphicsData", "PostScript", \
"Graphics"],
Cell[125988, 4186, 163, 3, 67, "Output"],
Cell[126154, 4191, 19403, 647, 194, 11147, 541, "GraphicsData", "PostScript", \
"Graphics"],
Cell[145560, 4840, 112, 2, 62, "Output"],
Cell[145675, 4844, 21213, 712, 194, 12329, 598, "GraphicsData", "PostScript", \
"Graphics"],
Cell[166891, 5558, 128, 2, 67, "Output"],
Cell[167022, 5562, 20415, 672, 194, 12230, 566, "GraphicsData", "PostScript", \
"Graphics"],
Cell[187440, 6236, 103, 2, 49, "Output"],
Cell[187546, 6240, 23600, 792, 194, 14379, 674, "GraphicsData", "PostScript", \
"Graphics"],
Cell[211149, 7034, 136, 2, 67, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

