// Definitionen fr Puzzle/einheitlicher Code fr alle Browser
// es werden Funkionen aus defs.js verwendet

// WICHTIG: alle div-Elemente mssen ganz von einer Tabelle berdeckt sein,
// um einen Bug im IE bezglich des Werts von window.event.y zu umgehen!


function definiere_layers()
{
   if (document.releaseEvents) { document.releaseEvents(Event.MOUSEMOVE); } // browserabhngig
   // (Die Rolle dessen ist nicht ganz klar - aber es verhindert, dass der sich Cursor in NN4 ber Links 
   // manchmal nicht in eine Hand verwandelt).

   // einige browserabhngige Definitionen: // browserabhngig
   if (isOpera)
   {
      shift_Y_zusatz = 0;
      shift_Ytot_zusatz = -10;
   }
   else if (document.all)
   { 
      shift_Y_zusatz = 30;
      shift_Ytot_zusatz = 0;
   }
   else if (document.layers)
   {
      shift_Y_zusatz = 0;
      shift_Ytot_zusatz = 0;
   } 
   else if (document.getElementById)
   {
      shift_Y_zusatz = 15; 
      shift_Ytot_zusatz = -20;
   }

   zufall();


   // WARNUNG und HINWEIS fr Netscape 6/Mozilla // browserabhngig
   if (problemHinweisAnzeigen==1 && !document.all && document.getElementById && navigator.appName.toLowerCase().indexOf("netscape") != -1)
   {
      fensterBrowserHinweis = window.open("../defs/browserProblemeHinweis.html","Fenster_browserHinweis","width=500,height=275,resizable=yes,status=no,menubar=no,location=no,scrollbars=yes");
      fensterBrowserHinweis.focus();
   }


   // Seitenkopf definieren:

   // folgender Kopf mit Logo kann weggelassen werden:
   zunaechst ='<br><center><table cellpadding="0" cellspacing="0" border="0" width="90%">\n'+
   '<td align="left">\n'+ 
   '  <a href="../../tests.html"><IMG SRC="../../grafiken/testskopf.gif"\n'+ 
   '   width="224" height="59" alt="Interactive tests - Table of contents" border="0"></A>\n'+
   '</td><td align="right"><a href="../../index.html">\n'+
   '<img src="../../grafiken/pfeile.gif" width="145" height="91" alt="Zur Welcome Page" border="0"></A>\n'+
   '</td></table></center><br>\n'+
   '<br><font face="Arial,Helvetica" size="-1">\n'+
   '<center><font size="+0"><b>Puzzle</b></font><br><br>\n'+
   '<font size="+3">' + titel + '</font></center>\n';

   createDivSimple("Seitenkopf",zunaechst+text_Seitenkopf);

   // Effekt des Seitenkopfs: um folgenden Y-Betrag wird alles Weitere nach unten verschoben:
   shift_Y = divOben("Seitenkopf") + divHoehe("Seitenkopf") + shift_Y_zusatz;

   // alle anderen Layer definieren:

   // die fixen Felder:
   for (i=1;i<=n;i++)
   { 
      createDivNr(texte_fixeFelder[i-1],fixeFelder[0]+(i-1)*(fixeFelder[2]-fixeFelder[0]),fixeFelder[1]+(i-1)*(fixeFelder[3]-fixeFelder[1])+shift_Y,Felder_Groesse_fix[0],Felder_Groesse_fix[1]);
   }

   // die Markierungen_Ziel:
   for (i=1;i<=n;i++)
   {
      createDivNrBlank("&nbsp;",Markierungen_Ziel[0]+(i-1)*(Markierungen_Ziel[2]-Markierungen_Ziel[0]),Markierungen_Ziel[1]+(i-1)*(Markierungen_Ziel[3]-Markierungen_Ziel[1]) + shift_Y,Felder_Groesse_bew[0],Felder_Groesse_bew[1],"#ffffee");
   }

   // die Markierungen_Beginn:
   for (i=1;i<=n;i++)
   {
      createDivNrBlank("&nbsp;",Markierungen_Beginn[0]+(i-1)*(Markierungen_Beginn[2]-Markierungen_Beginn[0]),Markierungen_Beginn[1]+(i-1)*(Markierungen_Beginn[3]-Markierungen_Beginn[1])+shift_Y,Felder_Groesse_bew[0],Felder_Groesse_bew[1],"#ffffee");
   }

   // die beweglichen Felder:
   for (i=1;i<=n;i++)
   {
      createDivNr(texte_beweglicheFelder[i-1],Markierungen_Beginn[0]+(i-1)*(Markierungen_Beginn[2]-Markierungen_Beginn[0]),Markierungen_Beginn[1]+(i-1)*(Markierungen_Beginn[3]-Markierungen_Beginn[1]) + shift_Y,Felder_Groesse_bew[0],Felder_Groesse_bew[1]);
   }

   // die Richtig-Markierungen (unsichtbar):
   if (richtigfalsch01 == 1)
   {
      for (i=1;i<=n;i++)
      {
         createDivNrInvisible(texte_richtigfalsch[0],richtigfalsch[0]+(i-1)*(richtigfalsch[2]-richtigfalsch[0]),richtigfalsch[1]+(i-1)*(richtigfalsch[3]-richtigfalsch[1]) + shift_Y,richtigfalsch_Groesse[0],richtigfalsch_Groesse[1]);
      }
   }

   // die Falsch-Markierungen (unsichtbar):
   if (richtigfalsch01 == 1)
   {
      for (i=1;i<=n;i++)
      {
         createDivNrInvisible(texte_richtigfalsch[1],richtigfalsch[0]+(i-1)*(richtigfalsch[2]-richtigfalsch[0]),richtigfalsch[1]+(i-1)*(richtigfalsch[3]-richtigfalsch[1]) + shift_Y,richtigfalsch_Groesse[0],richtigfalsch_Groesse[1]);
      }
   }

   // die Gleichzeichen-Felder:
   if (istgleich01 == 1)
   {
      for (i=1;i<=n;i++)
      {
         createDivNr(text_istgleich,istgleich[0]+(i-1)*(istgleich[2]-istgleich[0]),istgleich[1]+(i-1)*(istgleich[3]-istgleich[1]) + shift_Y,istgleich_Groesse[0],istgleich_Groesse[1]);
      }
   }

   // Seitenende:
   if (seitenende01 == 1) 
   {
      aux1 = divNrOben(n);
      aux2 = divNrHoehe(n);
      aux3 = divNrOben(2*n);
      aux4 = divNrHoehe(2*n);
      aux5 = divNrOben(3*n);
      aux6 = divNrHoehe(3*n);
      shift_Ytot = Math.max(Math.max(aux1 + aux2 + 25,aux3 + aux4 + 25),aux5 + aux6 + 25) + shift_Ytot_zusatz;
      createDivTop("Ende",text_Seitenende,shift_Ytot);
   }

   // alle Puzzle-relevanten Felder:
   ALLE_layer = new Array()
   for (i=1;i<(4+2*richtigfalsch01+istgleich01)*n+1;i++)
   {
      ALLE_layer[i] = objNr(i);
   }

} // function definiere_layers() ENDE


function zufall() 
{
   // Die Arrays texte_beweglicheFelder und rf simultan (per Zufalls-Permutation) umordnen:
   aux_text = new Array();
   aux_rf = new Array();
   permutation = new Array();

   // (dieser Teil ist fast identisch mit Puzzle-Applets)
   for (var a=1;a<=n;a++)
   {   
      zufalltest=0;
      while (zufalltest==0 || zufallszahl==0 || zufallszahl==n+1)
      { 
         zufallszahl=Math.floor(n*Math.random()+1);  // zwischen 1 und n
         permutation[a]=zufallszahl;
         zufalltest=1;
         for (i=1;i<=a-1;i++)
         {
            if(permutation[i] == zufallszahl) { zufalltest=0; }   // schauen, ob zufallszahl schon vorkommt
         }
      }  
   }
   for (i=1;i<=n;i++) 
   { 
      aux_text[i] = texte_beweglicheFelder[i-1];
      aux_rf[i] = rf[i-1];
   }
   for (i=1;i<=n;i++) 
   { 
      texte_beweglicheFelder[i-1] = aux_text[permutation[i]];
      rf[i-1] =  aux_rf[permutation[i]];
   }
}


// Punktesystem:
// n(n+1)/2 = Maximalzahl der Punkte = Zahl der Schritte, mit der das Puzzle
// bei richtigfalsch01 == 1 auf jeden Fall gelst werden kann
// das ist quivalent zu: bei jedem falsch wird ein Punkt abgezogen!
// bei Random-Versuch -> im statistischen Mittel die halbe Maximalpunktezahl

var punktezahl = 0;          
var bereits_richtig = 0
var versuch =0;   // soundsovielter Versuch, die nchste richtige zu finden
warschon = new Array();
for (i=n+1;i<2*n+1;i++) { warschon[i] = 0; }

current_layer = null;
var i_current;
last_layer = null;
herkunft_layer = null
var i_herkunft=null;
var getroffen = 0;
var geparkt = 1;
besetzt=new Array();
var indexzaehl=3;

for (i=n+1;i<2*n+1;i++) { besetzt[i] = 0; }
for (i=2*n+1;i<3*n+1;i++) { besetzt[i] = 1; }

function begin_event(e) 
{
   for (i=3*n+1;i<4*n+1;i++) // checke die beweglichen Felder
   {
      var test_layer = ALLE_layer[i];
      var the_x = divLinksObj(test_layer);
      var the_width = divBreiteObj(test_layer);
      var the_y = divObenObj(test_layer);
      var the_height = divHoeheObj(test_layer);
      var correct_width = check_width(eX(e),the_x,the_width);
      var correct_height = check_height(eY(e),the_y,the_height);

      if (correct_width && correct_height)
      {
         current_layer = test_layer;
         i_current = i;
         oldX = eX(e);
         oldY = eY(e);
         indexzaehl = indexzaehl + 1; // knnte im NN immer gleich (z.B. 3) bleiben
         zIndexDivObj(current_layer,indexzaehl);
         geparkt = 0; 
         if (document.captureEvents) { document.captureEvents(Event.MOUSEMOVE); } // browserabhngig
         break;
      }
   }

   // Herkunft ermitteln
   for (i=n+1;i<3*n+1;i++) // checke alle Markierungen
   {
      test_layer = ALLE_layer[i];
      the_x = divLinksObj(test_layer);
      the_width = divBreiteObj(test_layer);
      the_y = divObenObj(test_layer);
      the_height = divHoeheObj(test_layer);
      correct_width = check_width(eX(e),the_x,the_width);
      correct_height = check_height(eY(e),the_y,the_height);

      if (correct_width && correct_height) // hier IE-Bug: falsches window.event.y -> in der Definition von eY(e) in defs.js korrigiert!
      {
         herkunft_layer = test_layer; 
         i_herkunft = i;
         besetzt[i_herkunft] = 0;
      }
   }
   return true;
} //function begin_event(e) ENDE

function drag_event(e)
{
   if (current_layer != null) 
   {
      moveDivObj(current_layer,eX(e)-oldX,eY(e)-oldY); // hier IE-Bug: falsches window.event.y -> in der Definition von eY(e) in defs.js korrigiert!
      oldX = eX(e);
      oldY = eY(e); 
   }
   return false;
} // function drag_event(e) ENDE

function end_event(e)
{
   if (current_layer != null)
   {
      last_layer = current_layer;
      if (document.releaseEvents) { document.releaseEvents(Event.MOUSEMOVE); } // browserabhngig

      // Einschnapp-Mechanismus
      for (i=n+1;i<3*n+1;i++) // checke alle Markierungen
      {
         var einschnapp_layer = ALLE_layer[i];
         var the_x = divLinksObj(einschnapp_layer);
         var the_width = divBreiteObj(einschnapp_layer);
         var the_y = divObenObj(einschnapp_layer);
         var the_height = divHoeheObj(einschnapp_layer);
         var correct_width = check_width(eX(e),the_x,the_width);
         var correct_height = check_height(eY(e),the_y,the_height);

         if (correct_width && correct_height && besetzt[i]==0) 
         {
            setDivObj(current_layer,divLinksObj(einschnapp_layer),divObenObj(einschnapp_layer));
            getroffen=1;
            besetzt[i]=1;

            if (richtigfalsch01 == 1 && i_herkunft>n && i_herkunft<2*n+1 )  // falls von Zielfeld
            {
               visibleDivObj(ALLE_layer[i_herkunft+3*n],0);  // Richtig- und
               visibleDivObj(ALLE_layer[i_herkunft+4*n],0);  // Falsch-Layer wieder weg
            }

            if (richtigfalsch01 == 1 && i>n && i<2*n+1 )  // falls auf Zielfeld
            {
               visibleDivObj(ALLE_layer[i+3*n],0);  // frhere Richtig- und
               visibleDivObj(ALLE_layer[i+4*n],0);  // Falsch-Layer zunchst weg 

               // falls richtig:
               if ( rf[i_current-3*n-1] == i-n )
               {
                  visibleDivObj(ALLE_layer[i+3*n],1);  // Richtig-Layer 
		  if (warschon[i]==0)
		   {
                      if (punktezahl + n - bereits_richtig - versuch > punktezahl)  // damit keine Punkte abgezogen werden
                      { punktezahl = punktezahl + n - bereits_richtig - versuch; }
                      if (bereits_richtig < n) bereits_richtig = bereits_richtig + 1;
                      { versuch = 0; }
                      warschon[i] = 1;
                   }
                }
                // falls falsch:
                else
                {
                   visibleDivObj(ALLE_layer[i+4*n],1);  // Falsch-Layer
                   versuch = versuch + 1;
                }
             } 
          }
       }

       if (getroffen==0 && geparkt==0) // zurcksetzen
       {
          setDivObj(current_layer,divLinksObj(herkunft_layer),divObenObj(herkunft_layer));
          besetzt[i_herkunft] = 1;
       }
       getroffen = 0; geparkt = 1;
       current_layer = null;
   } // if (current_layer != null) ENDE
   return true;
} // function end_event(e) ENDE


function check_width(page_x,the_x,the_width)
{
   if (page_x >= the_x && page_x <= the_x + the_width) { return true; }
   else { return false; }
}

function check_height(page_y,the_y,the_height)
{
   if (page_y >= the_y && page_y <= the_y + the_height) { return true; }
   else {return false; }
}

if (document.captureEvents) // browserabhngig
{
   document.captureEvents(Event.MOUSEDOWN | Event.MOUSEDRAG | Event.MOUSEUP); 
}
document.onmousedown=begin_event;
document.onmousemove=drag_event;
document.onmouseup=end_event;


function open_info_punkte_puzzle() // browserabhngig
{
   if (document.all)
   {
      var fenster_info_punkte_P;
      if ((fenster_info_punkte_P == null)||(fenster_info_punkte_P.closed)) 
      { 
         fenster_info_punkte_P = window.open("../defs/info_puzzle.html","Fenster_info_punkte_P","width=600,height=425,resizable=yes,status=no,menubar=no,location=no,scrollbars=yes");
         fenster_info_punkte_P.opener = top;
         fenster_info_punkte_P.focus(); 
      } 
      else { fenster_info_punkte_P.focus(); }
   }
   else
   {
      fenster_info_punkte_P = window.open("../defs/info_puzzle.html","Fenster_info_punkte_P","width=600,height=415,resizable=yes,status=no,menubar=no,location=no,scrollbars=yes");
      fenster_info_punkte_P.focus();
   }
}

function zuruecksetzen() // browserabhngig
{
   if (document.all) { window.document.all.tags("div").item("Ende").document.ausw.auswert.value=""; }
   else if (document.layers) { window.document.layers["Ende"].document.ausw.auswert.value=""; }
   else if (document.getElementById) { document.ausw.auswert.value=""; }
}
