// -----------------------------------------------------------------------------------------------------
// defs.js (s.a. dom.js)
//
// eleMent(objname),  eleMentNr(zahl)
// divLinks(objname), divOben(objname), divBreite(objname), divHoehe(objname)
// divNrLinks(zahl),  divNrOben(zahl),  divNrBreite(zahl),  divNrHoehe(zahl)
// setDiv(objname,xKoord,yKoord),     moveDiv(objname,delta_xKoord,delta_yKoord)
//     visibleDiv(objname,1 oder 0),  zIndexDiv(objname,zind)
// setDivNr(zahl,xKoord,yKoord),      moveDivNr(zahl,delta_xKoord,delta_yKoord)
//     visibleDivNr(zahl,1 oder 0),   zIndexDivNr(zahl,zind)
// divLinksObj(obj), divObenObj(obj), divBreiteObj(obj), divHoeheObj(obj)
// setDivObj(obj,xKoord,yKoord),      moveDivObj(obj,delta_xKoord,delta_yKoord)
// visibleDivObj(obj,modus),          zIndexDivObj(obj,zind)
// eX(e), eY(e)
//
// Erzeugung von <div>s bzw.<layer>s:
// createDivSimple(iD,inhaltTxt)                            ... mit id, ohne Positionierung
// createDivNr(inhaltTxt,linKS,obEN,breiTE,hoeHE)           ... ohne id, absolute Positionierung
// createDivNrFarbe(inhalt,linKS,obEN,breiTE,hoeHE,farBE)   ... ohne id, absolute Positionierung, mit Hintergrundfarbe
// createDivNrInvisible(inhaltTxt,linKS,obEN,breiTE,hoeHE)  ... ohne id, absolute Positionierung, unsichtbar
// createDivTop(iD,inhaltTxt,obEN)                          ... mit id,  absolute Positionierung, nur Abstand zu oben wird angegeben
//
// Browser werden unterschieden mittels:
//    if (document.all) -> Internet Explorer, Opera
//    if (document.layers) -> Netscape Navigator 4
//    if (document.getElementById) -> Netscape Navigator ab 6, Mozilla
// Falls ntig, zu Opera zu unterscheiden: wird extra erkannt (boolesche Variable isOpera)
//
// Fr Event-Handler:
//    if (window.Event) -> Netscape Navigator (siehe die nachfolgende Bemerkung)
//    besser aber ist:
//    if (document.captureEvents) oder if (document.releaseEvents) -> Netscape und Opera
//
// Achtung: Event-Handler werden via
//    if (document.captureEvents) { document.captureEvents(Event.MOUSEDOWN | Event.MOUSEMOVE | Event.MOUSEDRAG | Event.MOUSEUP); }
//    document.onmousedown=begin_event; document.onmousemove=drag_event; document.onmouseup=end_event;
// eingeschaltet. Z u v o r  aber mssen die Funktionen begin_event, drag_event und end_event
// definiert sein! Diese zwei Zeilen daher immer als letztes im html-File oder einem js-File
// inkludieren!
// Falls notwendig, auch
// if (document.releaseEvents) { document.releaseEvents(Event.MOUSEMOVE); }
// einbauen.
// -----------------------------------------------------------------------------------------------------
// Opera-Browser erkennen:
if (navigator.userAgent.toLowerCase().indexOf("opera") != -1) { isOpera = true; }
else { isOpera = false; }
// -----------------------------------------------------------------------------------------------------

// OBJEKTE AUS ID UND NUMMERN DEFINIEREN:

function obJ(objname)
{
 if (document.all) { return eval("document.all." + objname); }
 else if (document.layers) { return eval("document." + objname); }
 else if (document.getElementById) { return document.getElementById(objname); }
}

function objNr(zahl)
{
 if (document.all) { return document.all.tags("div").item(zahl); }
 else if (document.layers) { return document.layers[zahl]; }
 else if (document.getElementById) { return document.getElementsByTagName("div")[zahl]; }
}

function eleMent(objname) // definiert Objekt aus seinem Namen (id)
{
 if (document.all) { return eval("document.all." + objname + ".style"); }
 else if (document.layers) { return eval("document." + objname); }
 // oder, quivalent:
 // else if (document.layers) { return document.layers[objname]; }
 else if (document.getElementById) { return document.getElementById(objname).style; }
}

function eleMentNr(zahl) // definiert Objekt aus seiner Nummer (das zahl-te <div> auf der Seite)
{
 if (document.all) { return document.all.tags("div").item(zahl).style; }
 else if (document.layers) { return document.layers[zahl]; }
 else if (document.getElementById) { return document.getElementsByTagName("div")[zahl].style; }
}

// -----------------------------------------------------------------------------------------------------

// DIV-EIGENSCHAFTEN LESEN:
//
// IE: Fr ein Element der id "a" ist
//     document.all.a.offsetWidth  = document.all.a.style.posWidth   ... = divBreite("a");
//     document.all.a.offsetHeight = document.all.a.style.posHeight  ... = divHoehe("a");
// NN4: Fr ein Element der id "a" ist
//     document.a.pageX = document.a.left                            ... = divLinks("a");
//     document.a.pageY = document.a.top                             ... = divOben("a");
// NN5: Fr ein Element der id "a" ist
//     document.getElementById("a").offsetWidth  = parseInt(document.getElementById("a").style.width)  ... = divBreite("a");
//     document.getElementById("a").offsetHeight = parseInt(document.getElementById("a").style.height) ... = divHoehe("a");
//     (falls Gre von <div> nicht explizit festgelegt, sind nur die beiden ersten definiert!)

function divLinks(objname) // liest x-Koordinate des linken oberen Eckpunkts
{  
  var obj = eleMent(objname);
  if (isOpera) { return obj.pixelLeft; }
  else if (document.all) { return obj.posLeft; }
  // else if (document.layers || document.getElementById) { return parseInt(obj.left); }
  // obiges funktioniert im NN5 nicht, wenn <div> nicht positioniert ist
  else if (document.layers) { return obj.left; }
  else if (document.getElementById) { return document.getElementById(objname).offsetLeft; }
}

function divOben(objname) // liest y-Koordinate des linken oberen Eckpunkts
{
  var obj = eleMent(objname);
  if (isOpera) { return obj.pixelTop; }
  else if (document.all) { return obj.posTop; }
  // else if (document.layers || document.getElementById) { return parseInt(obj.top); }
  // obiges funktioniert im NN5 nicht, wenn <div> nicht positioniert ist
  else if (document.layers) { return obj.top; }
  else if (document.getElementById) { return document.getElementById(objname).offsetTop; }
}

function divBreite(objname) // liest Breite des Elements
{
  var obj = eleMent(objname);
  if (isOpera) { return obj.pixelWidth; }
  // else if (document.all) { return obj.posWidth; }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.all) { return eval("document.all." + objname + ".offsetWidth"); }
  else if (document.layers) { return obj.clip.width; }
  // else if (document.getElementById) { return parseInt(obj.width); }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.getElementById) { return document.getElementById(objname).offsetWidth; }
}

function divHoehe(objname) // liest Hhe des Elements
{
  var obj = eleMent(objname);
  if (isOpera) { return obj.pixelHeight; }
  // else if (document.all) { return obj.posHeight; }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.all) { return eval("document.all." + objname + ".offsetHeight"); }
  else if (document.layers) { return obj.clip.height; }
  // else if (document.getElementById) {return parseInt(obj.height); }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.getElementById) { return document.getElementById(objname).offsetHeight; }
}

function divNrLinks(zahl) // liest x-Koordinate des linken oberen Eckpunkts
{
  var obj = eleMentNr(zahl);
  if (isOpera) { return obj.pixelLeft; }
  else if (document.all) { return obj.posLeft; }
  // else if (document.layers || document.getElementById) { return parseInt(obj.left); }
  // obiges funktioniert nicht, wenn <div> nicht positioniert ist
  else if (document.layers) { return obj.pageX; }
  else if (document.getElementById) { return document.getElementsByTagName("div")[zahl].offsetLeft; }
}

function divNrOben(zahl) // liest y-Koordinate des linken oberen Eckpunkts
{
  var obj = eleMentNr(zahl);
  if (isOpera) { return obj.pixelTop; }
  else if (document.all) { return obj.posTop; }
  // else if (document.layers || document.getElementById) { return parseInt(obj.top); }
  // obiges funktioniert nicht, wenn <div> nicht positioniert ist
  else if (document.layers) { return obj.pageY; }
  else if (document.getElementById) { return document.getElementsByTagName("div")[zahl].offsetTop; }
}

function divNrBreite(zahl) // liest Breite des Elements
{
  var obj = eleMentNr(zahl);
  if (isOpera) { return obj.pixelWidth; }
  // else if (document.all) { return obj.posWidth; }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.all) { return document.all.tags("div").item(zahl).offsetWidth; }
  else if (document.layers) { return obj.clip.width; }
  // else if (document.getElementById) { return parseInt(obj.width); }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.getElementById) { return document.getElementsByTagName("div")[zahl].offsetWidth; }
}

function divNrHoehe(zahl) // liest Hhe des Elements
{
  var obj = eleMentNr(zahl);
  if (isOpera) { return obj.pixelHeight; }
  // else if (document.all) { return obj.posHeight; }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.all) { return document.all.tags("div").item(zahl).offsetHeight; }
  else if (document.layers) { return obj.clip.height; }
  // else if (document.getElementById) {return parseInt(obj.height); }
  // obiges funktioniert nicht, wenn die Gre von <div> nicht explizit festgelegt ist
  else if (document.getElementById) { return document.getElementsByTagName("div")[zahl].offsetHeight; }
}

// Fr positionierte <div>s:

function divLinksObj(obj)
{
   if (isOpera) { return obj.style.pixelLeft; }
   else if (document.all) { return obj.style.posLeft; }
   else if (document.layers) { return obj.left; }
   else if (document.getElementById) { return parseInt(obj.style.left); }
}

function divObenObj(obj)
{
   if (isOpera) { return obj.style.pixelTop; }
   else if (document.all) { return obj.style.posTop; }
   else if (document.layers) { return obj.top; }
   else if (document.getElementById) { return parseInt(obj.style.top); }
}

function divBreiteObj(obj)
{
   if (isOpera) { return obj.style.pixelWidth; }
   else if (document.all) { return obj.style.posWidth; }
   else if (document.layers) { return obj.clip.width; }
   else if (document.getElementById) { return parseInt(obj.style.width); }
}

function divHoeheObj(obj)
{
   if (isOpera) { return obj.style.pixelHeight; }
   else if (document.all) { return obj.style.posHeight; }
   else if (document.layers) { return obj.clip.height; }
   else if (document.getElementById) { return parseInt(obj.style.height); }
}

// -----------------------------------------------------------------------------------------------------

// DIV-EIGENSCHAFTEN NDERN:

function setDiv(objname,xKoord,yKoord) // setzt x- und y-Koordinate des linken oberen Eckpunkts
{
  var obj = eleMent(objname);
  if (isOpera) { obj.pixelLeft = xKoord; obj.pixelTop = yKoord; }
  else if (document.all) { obj.posLeft = xKoord; obj.posTop = yKoord; }
  else if (document.layers || document.getElementById) { obj.left = xKoord; obj.top = yKoord; }
}

function moveDiv(objname,delta_xKoord,delta_yKoord) // verschiebt x- und y-Koordinate des linken oberen Eckpunkts
{
  var obj = eleMent(objname);
  if (isOpera) { obj.pixelLeft += delta_xKoord; obj.pixelTop += delta_yKoord; }
  else if (document.all) { obj.posLeft += delta_xKoord; obj.posTop += delta_yKoord; }
  else if (document.layers || document.getElementById) { obj.left = parseInt(obj.left) + delta_xKoord; obj.top = parseInt(obj.top) + delta_yKoord; }
}

function visibleDiv(objname,modus) // macht das Element sichtbar (modus=1) bzw. unsichtbar (modus=0)
{
  var obj = eleMent(objname);
  var txt;
  if (document.all || document.getElementById) { if (modus == 1) { txt = "visible"; } else if (modus == 0) { txt = "hidden"; } }
  else if (document.layers) { if (modus == 1) { txt = "show"; } else if (modus == 0) { txt = "hide"; } }
  obj.visibility = txt;
}

function zIndexDiv(objname,zind) // setzt z-Index des Elements
{
  var obj = eleMent(objname);
  obj.zIndex = zind;
}

function setDivNr(zahl,xKoord,yKoord) // setzt x- und y-Koordinate des linken oberen Eckpunkts
{
  var obj = eleMentNr(zahl);
  if (isOpera) { obj.pixelLeft = xKoord; obj.pixelTop = yKoord; }
  else if (document.all) { obj.posLeft = xKoord; obj.posTop += yKoord; }
  else if (document.layers || document.getElementById) { obj.left = xKoord; obj.top = yKoord; }
}

function moveDivNr(zahl,delta_xKoord,delta_yKoord) // verschiebt x- und y-Koordinate des linken oberen Eckpunkts
{
  var obj = eleMentNr(zahl);
  if (isOpera) { obj.pixelLeft += delta_xKoord; obj.pixelTop += delta_yKoord; }
  else if (document.all) { obj.posLeft += delta_xKoord; obj.posTop += delta_yKoord; }
  else if (document.layers || document.getElementById) { obj.left = parseInt(obj.left) + delta_xKoord; obj.top = parseInt(obj.top) + delta_yKoord; }
}

function visibleDivNr(zahl,modus) // macht das Element sichtbar (modus=1) bzw. unsichtbar (modus=0)
{
  var obj = eleMentNr(zahl);
  var txt;
  if (document.all || document.getElementById) { if (modus == 1) { txt = "visible"; } else if (modus == 0) { txt = "hidden"; } }
  else if (document.layers) { if (modus == 1) { txt = "show"; } else if (modus == 0) { txt = "hide"; } }
  obj.visibility = txt;
}

function zIndexDivNr(zahl,zind) // setzt z-Index des Elements
{
  var obj = eleMentNr(zahl);
  obj.zIndex = zind;
}

// Fr positionierte <div>s:

function setDivObj(obj,xKoord,yKoord)
{
   if (isOpera) { obj.style.pixelLeft = xKoord; obj.style.pixelTop = yKoord; }
   else if (document.all) { obj.style.posLeft = xKoord; obj.style.posTop = yKoord; }
   else if (document.layers) { obj.left = xKoord; obj.top = yKoord; }
   else if (document.getElementById) { obj.style.left = xKoord; obj.style.top = yKoord; }
}

function moveDivObj(obj,delta_xKoord,delta_yKoord)
{
   if (isOpera) { obj.style.pixelLeft += delta_xKoord; obj.style.pixelTop += delta_yKoord; }
   if (document.all) { obj.style.posLeft += delta_xKoord; obj.style.posTop += delta_yKoord; }
   else if (document.layers) { obj.left += delta_xKoord; obj.top += delta_yKoord; }
   else if (document.getElementById) { obj.style.left = parseInt(obj.style.left) + delta_xKoord + "px"; obj.style.top = parseInt(obj.style.top) + delta_yKoord + "px"; }
}

function visibleDivObj(obj,modus)
{
   if (document.all || document.getElementById)
   { 
      if (modus == 1) { obj.style.visibility = "visible"; } 
      else if (modus == 0) { obj.style.visibility = "hidden"; }
   }
   else if (document.layers)
   { 
      if (modus == 1) { obj.visibility = "show"; }
      else if (modus == 0) { obj.visibility = "hide"; } 
   }
}

function zIndexDivObj(obj,zind)
{
   if (document.all || document.getElementById) { obj.style.zIndex = zind; }
   else if (document.layers) { obj.zIndex = zind; }
}

// -----------------------------------------------------------------------------------------------------

// EVENT-KOORDINATEN: ABSTAND ZUM LINKEN/OBEREN RAND DES DOKUMENTS
//
// IE: 
// window.event.clientX, window.event.clientY ... Abstnde zum sichtbaren linken/oberen Rand
// window.document.body.scrollLeft, window.document.body.scrollTop ... Ausma des gescrollten Fensters
// Die Summe beider sollte window.event.x, window.event.y = Abstand zum linke/oberen Rand sein
// aber Bug: window.event.y ist flschlicherweise nur window.event.clientY, daher statt dessen
//           die Summe window.event.clientY + window.document.body.scrollTop verwenden!
// Nicht verwendet:
// window.event.offsetX und window.event.offsetY ... Koordinaten, innerhalb des jeweiligen Elements

// NN:
// e.pageX, e.pageY

// Opera:
// window.event.clientX, window.event.clientY


function eX(e)
{
  if (isOpera) { return window.event.clientX; }
  else if (document.all) { return window.event.clientX + window.document.body.scrollLeft; }
  else if (document.layers || document.getElementById) { return e.pageX; }
}

function eY(e)
{
  if (isOpera) { return window.event.clientY; }
  else if (document.all) { return window.event.clientY + window.document.body.scrollTop; }
  else if (document.layers || document.getElementById) { return e.pageY; }
}

// -----------------------------------------------------------------------------------------------------

// DEFINITION VON <div>s (im NN4: <layer>s)

function createDivSimple(iD,inhaltTxt)
{
  if (document.all || document.getElementById)
  {
    document.write('<div id="' + iD + '">' + inhaltTxt + '</div>\n');
  }
  else if (document.layers)
  {
    document.write('<layer id="' + iD + '">' + inhaltTxt + '</layer>\n');
  }
}

function createDivNr(inhaltTxt,linKS,obEN,breiTE,hoeHE)
{
  if (document.all || document.getElementById)
  {
    document.write('<div style="position:absolute; left:' + linKS + ';\n'+ 
    'top:' + obEN + '; width:' + breiTE + '; height:' + hoeHE + ';">' + inhaltTxt + '</div>');
  }
  else if (document.layers)
  {
    document.write('<layer left="' + linKS + '"\n'+ 
    'top="' + obEN + '" width="' + breiTE + '" height="' + hoeHE + '">' + inhaltTxt + '</layer>');
  }
}

function createDivNrFarbe(inhaltTxT,linKS,obEN,breiTE,hoeHE,farBE)
{
  if (document.all) // wegen eines IE-Bugs mit Tabelle berdecken
  {
    document.write('<div style="position:absolute; left:' + linKS + ';\n'+ 
    'top:' + obEN + '; width:' + breiTE + '; height:'+ hoeHE + ';">\n'+
    '<table bgcolor="'+farBE+'" border=0 width="100%" height="100%"\ncellpadding="0" cellspacing="0"><td>' + inhaltTxT + '</td></table>\n</div>');
  }
  else if (document.getElementById) // funktioniert mit Tabelle in Netscape 6 und Mozilla nicht
  {
   document.write('<div style="position:absolute; left:' + linKS + '; top:' + obEN + '; width:' + breiTE + '; height:' + hoeHE + ';\n'+
   'background-color:' + farBE + '; layer-background-color:' + farBE + '"\n'+
   '>' + inhaltTxT + '</div>');
  }
  else if (document.layers)
  {
    document.write('<layer bgcolor="'+farBE+'" left="' + linKS + '"\n'+ 
    'top="' + obEN + '" width="' + breiTE + '" height="' + hoeHE + '">' + inhaltTxT + '</layer>');
  }
}

function createDivNrInvisible(inhaltTxt,linKS,obEN,breiTE,hoeHE)
{
  if (document.all || document.getElementById)
  {
    document.write('<div style="position:absolute; left:' + linKS + ';\n'+ 
    'top:' + obEN + '; width:' + breiTE + '; height:' + hoeHE + '; visibility:hidden">' + inhaltTxt + '</div>');
  }
  else if (document.layers)
  {
    document.write('<layer left="' + linKS + '"\n'+ 
    'top="' + obEN + '" width="' + breiTE + '" height="' + hoeHE + '" visibility="hidden">' + inhaltTxt + '</layer>');
  }
}

function createDivTop(iD,inhaltTxt,obEN)
{
  if (document.all || document.getElementById)
  {
    document.write('<div id="' + iD + '" style="position:absolute; top:' + obEN + ';">' + inhaltTxt + '</div>');
  }
  else if (document.layers)
  {
    document.write('<layer top="' + obEN + '" id="' + iD + '">' + inhaltTxt + '</layer>');
  }
}

