(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8166,        172]*)
(*NotebookOutlinePosition[      8850,        196]*)
(*  CellTagsIndexPosition[      8806,        192]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \( (*\ Mathematica - Grafiken\ *) \n\n
    \n (*\ Hintergrund : \ \nFARBE\  = \ Hue[0.67, 0.56, 0.28]; \ \ 
      waere\ dunkelblau, \ 
      entspricht\ HSV - 
        System\n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 240\ 
          \((von\ 359)\), \ 56\ \((von\ 100)\), \ 28\ \((von\ 100)\), \n\t
      ist\ aber\ nach\ HTML - Konvertierung\ viel\ zu\ dunkel, \ 
      daher\ schwarz\n\tund\ nachher\ im\ PaintShopPro\ \ schwarz\  -> \ 
        RGB : 27, 30, 
      65\ \((im\ 256  er - System)\)\n\tersetzen\ 
        \((Palette\ galerie1 . pal, \ das\ Quadrat\ links\ oben)\), \n\t
      das\ entspricht\ dann\ komischerweise\ genau\ der\ \n\t
          galeriekachel . jpg - Farbe\ \(RGB : 32\), 32, 
      72\ \((im\ 256  er - System)\)\ \ \ \ *) \n\n
    FARBE\  = \ GrayLevel[0]\ ; 
    \  (*\ 0\  = \ schwarz, \ 1\  = \ wei\[SZ], \ 
      0.9\  = \ schoenes\ grau\ *) \n\n
    \n (*\ Brauche\ folgenden\ leeren\ String, \ 
      damit\ die\ Textbeschriftung\ nicht\ \n\t\tauf\ der\ Achsenbeschriftung
        \ pickt\ *) \n
    leererString = 
      "\<                                                                 \>"\
\n\n (*\ \(--\(--\(--\(--\(--\(--\(--\(-\ Grafik\)\)\)\)\)\)\)\) - 
        Routine\ \(\(\(\(\(\(grafik\ --\)--\)--\)--\)--\)--\) - \ *) \n\), 
    \(grafik[f_, xvontot_, xbistot_, yvonplot_, ybisplot_, schrift_, 
        TICKS_] := \n
      Plot[\ \ f[x], \ \ \ {x, xvontot, xbistot}, \n\t\t
        PlotRange -> {{xvontot*1.05, xbistot*1.05}, {yvonplot*1.05, 
              ybisplot*1.05}}, \n\t\tAxesOrigin -> {0, \ 0}, \t\n\t\t
        ImageSize -> {450, 300}, 
        \t\t\t (*\ Pixelgroesse\ des\ gesamten\ Bildes\ *) \n\t\t
        DefaultColor -> GrayLevel[0.85], 
        \ \ \ \ \  (*\ Achsen\ und\ Beschriftungen, \ \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\t\t\t0\  = \ schwarz, \ 1\  = \ wei\[SZ]\ *) \n\t\t
        PlotStyle\  -> \ RGBColor[1, \ 0, \ 0], \ \  (*\ Graph\ *) \n\t\t
        Background\  -> \ FARBE, \n\t\tTicks\  -> \ \ TICKS, \n\t\t
        AxesLabel -> {StyleForm["\<x  \>", Section], \ 
            StyleForm["\<y\>", Section]}, \n\t\t
        PlotLabel -> 
          StyleForm[\n\t\t\t\t\tStringJoin[leererString, schrift], Section, 
            FontSize -> 16], \n\t\t
        TextStyle -> {FontSlant -> "\<Plain\>", \ 
            FontFamily -> "\<Courier\>", \ FontSize -> 13}\n
        \ \ \ \ \ \ \ \ \ \ \ \ ]; \n\n
    \n (*\ \(--\(--\(--\(--\(-\ Routine\)\)\)\)\)\ grafiken\ f\[UDoubleDot]r\ 
        singul\[ADoubleDot]re\ \(\(\(Funktionen\ --\)--\)--\)\ *) \n
    grafiken[f_, xvontot_, xbistot_, xvonplot_, xbisplot_, yvon_, ybis_, 
        schrift_, TICKS_] := \n
      Plot[\ \ f[x], \ \ \ {x, xvonplot, xbisplot}, \n\t\t
        PlotRange -> {{xvontot*1.05, xbistot*1.05}, {yvon*1.05, ybis*1.05}}, 
        \n\t\tAxesOrigin -> {0, \ 0}, \t\n\t\tImageSize -> {450, 300}, 
        \t\t\t (*\ Pixelgroesse\ des\ gesamten\ Bildes\ *) \n\t\t
        DefaultColor -> GrayLevel[0.85], 
        \ \ \ \ \  (*\ Achsen\ und\ Beschriftungen, \ \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\t\t\t0\  = \ schwarz, \ 1\  = \ wei\[SZ]\ *) \n\t\t
        PlotStyle\  -> \ RGBColor[1, \ 0, \ 0], \ \  (*\ Graph\ *) \n\t\t
        Background\  -> \ FARBE, \n\t\tTicks\  -> \ \ TICKS, \n\t\t
        AxesLabel -> {StyleForm["\<x  \>", Section], \ 
            StyleForm["\<y\>", Section]}, \n\t\t
        PlotLabel -> 
          StyleForm[\n\t\t\t\t\tStringInsert[leererString, schrift, \(-1\)], 
            Section, FontSize -> 16], \n\t\t
        TextStyle -> {FontSlant -> "\<Plain\>", \ 
            FontFamily -> "\<Courier\>", \ FontSize -> 13}\n
        \ \ \ \ \ \ \ \ \ \ \ \ ]; \n\n
    T4 = {{\(-4\), \(-3\), \(-2\), \(-1\), 1, 2, 3, 4}, {\(-4\), \(-3\), 
          \(-2\), \(-1\), 1, 2, 3, 4}}; \nSTR[1] = "\<1\>"; STR[2] = "\<2\>"; 
    STR[3] = "\<3\>"; STR[4] = "\<4\>"; \n\ 
    einsdurch[n_] := 
      Show[\n\t\t
        grafiken[Function[x, 1/x^n], \(-4\), 4, \(-4\), 0, \(-4\), 4, 
          StringJoin["\<y = 1 / x^  \>", STR[n]], T4], \n\t\ \ 
        grafiken[\n\t\t\t\tFunction[x, 1/x^n], \(-4\), 4, 0, 4, \(-4\), 4, 
          StringJoin["\<y = 1 / x^  \>", STR[n]], T4]\n
        \t\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ ]; \n
    einsdurch[1] := 
      Show[\n\t\t
        grafiken[Function[x, 1/x], \(-4\), 4, \(-4\), 0, \(-4\), 4, 
          "\<y = 1 / x\>", T4], \n\t\ \ 
        grafiken[\n\t\t\t\tFunction[x, 1/x], \(-4\), 4, 0, 4, \(-4\), 4, 
          "\<y = 1 / x\>", T4]\n
        \t\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ ]; \ \ \ \ \ \ \ \ \ \n\n (*\ konkrete\ Grafiken\ *) \n
    Beispiele := {\n
        grafik[Sin, \(-6.5\), 6.5, \(-1.1\), 1.1, 
          "\<y = sin(x)\>", {Automatic, Automatic}]; \n
        grafik[Function[x, Sin[x]/x], \(-15\), 20, \(-1.1\), 1.1, 
          "\<y = sin(x)/x\>", {Automatic, Automatic}]; }\n (*\ 
      \(--\(--\(--
            \(--\(--\(--
                  \(--\(--
                      \(--\(--
                          \(--\(--
                              \(--\(--
                                  \(--\(--
                                      \(--\(--
                                        \(--\(--
                                        \(-\(-\(--\(---
                                        \)\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)\
\)\)\)\)\)\ *) \n\), 
    \(auxiliary = 1; 
    \  (*\ damit\ er\ zu\ beginn\ was\ rechnet\ \(?? ?\)\ *) \n\n
    Potenzen := {\n
        grafiken[Function[x, x], \(-4\), 4, \(-3.8\), 3.8, \(-4\), 4, 
          "\<y = x\>", T4]; \n
        grafiken[Function[x, \(-x\)], \(-4\), 4, \(-3.8\), 3.8, \(-4\), 4, 
          "\<y = - x\>", T4]; \n
        grafik[Function[x, x^2], \(-4\), 4, \(-4\), 4, "\<y = x^  2\>", T4]; 
        \ngrafik[Function[x, \(-x^2\)], \(-4\), 4, \(-4\), 4, 
          "\<y = - x^  2\>", T4]; \n
        grafik[Function[x, x^3], \(-4\), 4, \(-4\), 4, "\<y = x^  3\>", T4]; 
        \ngrafik[Function[x, x^4], \(-4\), 4, \(-4\), 4, "\<y = x^  4\>", 
          T4]; \neinsdurch[1]; \n
        grafik[Function[x, 1/x^2], \(-4\), 4, \(-4\), 4, "\<y = 1 / x^  2\>", 
          T4]; \neinsdurch[3]; \n
        grafik[Function[x, 1/x^4], \(-4\), 4, \(-4\), 4, "\<y = 1 / x^  4\>", 
          T4]; \ }\n\), 
    \(\(Potenzen; \)\t\ \ \ \)}], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 550}},
WindowSize->{615, 464},
WindowMargins->{{15, Automatic}, {Automatic, 5}},
StyleDefinitions -> "DemoText.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 6453, 121, 1920, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

