/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class a_defbild
extends Applet
implements Runnable {
    Thread mStartup;
    ImageWarper mWarper;
    String mImageName;
    Image mImage;
    int[] mPixels;
    int[] mOldPixels;
    int mWidth;
    int mHeight;
    String mStatus = "";
    Point mFromPoint;
    Point mToPoint;
    boolean mReady = false;
    boolean mCanUndo = false;
    boolean mRedo = false;
    Button mUndoButton;
    final int kHOffset = 30;
    final int kVOffset = 35;

    public void run() {
        this.Initialize();
        while (this.mStartup != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.mReady) continue;
            this.mStatus = String.valueOf(this.mStatus) + ".";
            this.showStatus(this.mStatus);
        }
    }

    void Initialize() {
        this.mStatus = "Loading image...";
        this.showStatus(this.mStatus);
        this.mReady = false;
        this.mCanUndo = false;
        this.mRedo = false;
        this.mUndoButton.disable();
        this.mImage = this.getImage(this.getCodeBase(), this.mImageName);
        while ((this.mWidth = this.mImage.getWidth(this)) < 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while ((this.mHeight = this.mImage.getHeight(this)) < 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mPixels = new int[this.mWidth * this.mHeight];
        this.mOldPixels = new int[this.mWidth * this.mHeight];
        PixelGrabber pixelGrabber = new PixelGrabber(this.mImage, 0, 0, this.mWidth, this.mHeight, this.mPixels, 0, this.mWidth);
        boolean bl = false;
        do {
            try {
                bl = pixelGrabber.grabPixels(500L);
            }
            catch (InterruptedException interruptedException) {
                this.mStatus = "a_defbild interrupted.";
                this.showStatus(this.mStatus);
                return;
            }
            this.mStatus = String.valueOf(this.mStatus) + ".";
            this.showStatus(this.mStatus);
        } while (!bl);
        if ((pixelGrabber.status() & 0x80) != 0) {
            this.mStatus = "a_defbild interrupted.";
            this.showStatus(this.mStatus);
            return;
        }
        this.mReady = true;
        this.mStatus = "Ready for warping. Click and drag in the image to warp it.";
        this.showStatus(this.mStatus);
        this.repaint();
    }

    void DoneWithWarping() {
        this.mImage = this.createImage(new MemoryImageSource(this.mWidth, this.mHeight, this.mPixels, 0, this.mWidth));
        this.mUndoButton.enable();
        this.mUndoButton.setLabel("Undo");
        this.mRedo = false;
        this.mCanUndo = true;
        this.repaint();
        this.mReady = true;
        this.mWarper = null;
        this.mStatus = "Ready for warping. Click and drag in the image to warp it.";
        this.showStatus(this.mStatus);
    }

    public void paint(Graphics graphics) {
        if (this.mImage != null) {
            graphics.drawImage(this.mImage, 30, 35, this);
        }
        if (this.mFromPoint != null && this.mToPoint != null) {
            graphics.setColor(Color.red);
            graphics.drawLine(this.mFromPoint.x, this.mFromPoint.y, this.mToPoint.x, this.mToPoint.y);
            graphics.setColor(Color.black);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void start() {
        this.setBackground(new Color(25, 25, 69));
        if (this.mImage == null) {
            Button button = new Button("Undo");
            button.setFont(new Font("Helvetica", 0, 15));
            button.setBackground(new Color(230, 230, 230));
            this.add(button);
            button.disable();
            this.mUndoButton = button;
            button = new Button("Stop");
            button.setFont(new Font("Helvetica", 0, 15));
            button.setBackground(new Color(230, 230, 230));
            this.add(button);
            button = new Button("Reset");
            button.setFont(new Font("Helvetica", 0, 15));
            button.setBackground(new Color(230, 230, 230));
            this.add(button);
            this.mImageName = this.getParameter("image");
            if (this.mImageName == null) {
                this.mImageName = "warp.gif";
            }
            this.mStartup = new Thread(this);
            this.mStartup.start();
        }
    }

    public void stop() {
        if (this.mStartup != null) {
            this.mStartup.stop();
        }
        this.mStartup = null;
        if (this.mWarper != null) {
            this.mWarper.stop();
        }
        this.mWarper = null;
    }

    public boolean action(Event event, Object object) {
        if ("Undo".equals(object) || "Redo".equals(object)) {
            int[] nArray = this.mPixels;
            this.mPixels = this.mOldPixels;
            this.mOldPixels = nArray;
            this.mImage = this.createImage(new MemoryImageSource(this.mWidth, this.mHeight, this.mPixels, 0, this.mWidth));
            this.mRedo = !this.mRedo;
            this.mUndoButton.setLabel(this.mRedo ? "Redo" : "Undo");
            this.repaint();
            return true;
        }
        if ("Stop".equals(object)) {
            if (this.mWarper != null) {
                this.mWarper.stop();
                this.mWarper = null;
                this.mReady = true;
                this.mCanUndo = false;
                this.mUndoButton.disable();
                this.repaint();
                this.mStatus = "Ready for warping. Click and drag in the image to warp it.";
                this.showStatus(this.mStatus);
            }
            return true;
        }
        if ("Reset".equals(object)) {
            if (this.mWarper != null) {
                this.mWarper.stop();
                this.mWarper = null;
            }
            if (this.mStartup != null) {
                this.mStartup.stop();
                this.mStartup = new Thread(this);
                this.mStartup.start();
            }
            return true;
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.PointInImage(n, n2) || !this.mReady) {
            return false;
        }
        this.mFromPoint = new Point(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.mFromPoint == null) {
            return false;
        }
        if (this.mToPoint == null || !this.mToPoint.equals(this.mFromPoint)) {
            this.mToPoint = this.ClipToImage(this.mFromPoint, n, n2);
            this.repaint();
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.mFromPoint == null) {
            return false;
        }
        this.mReady = false;
        this.mStatus = "Warping...";
        this.showStatus(this.mStatus);
        int[] nArray = this.mOldPixels;
        this.mOldPixels = this.mPixels;
        this.mPixels = nArray;
        Point point = this.ClipToImage(this.mFromPoint, n, n2);
        this.mWarper = new ImageWarper(this, this.mOldPixels, this.mPixels, this.mWidth, this.mHeight, new Point(point.x - 30, point.y - 35), new Point(this.mFromPoint.x - 30, this.mFromPoint.y - 35));
        this.mWarper.start();
        this.mToPoint = null;
        this.mFromPoint = null;
        return true;
    }

    boolean PointInImage(int n, int n2) {
        return n >= 30 && n < 30 + this.mWidth && n2 >= 35 && n2 < 35 + this.mHeight;
    }

    Point ClipToImage(Point point, int n, int n2) {
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        if (n3 == 0) {
            if (n2 < 35) {
                n2 = 35;
            }
            if (n2 >= 35 + this.mHeight) {
                n2 = 35 + this.mHeight - 1;
            }
        } else if (n4 == 0) {
            if (n < 30) {
                n = 30;
            }
            if (n >= 30 + this.mWidth) {
                n = 30 + this.mWidth - 1;
            }
        } else {
            double d = (double)n4 / (double)n3;
            if (n < 30) {
                n = 30;
                n2 = point.y + (int)(d * (double)(n - point.x));
            }
            if (n >= 30 + this.mWidth) {
                n = 30 + this.mWidth - 1;
                n2 = point.y + (int)(d * (double)(n - point.x));
            }
            if (n2 < 35) {
                n2 = 35;
                n = point.x + (int)((double)(n2 - point.y) / d);
            }
            if (n2 >= 35 + this.mHeight) {
                n2 = 35 + this.mHeight - 1;
                n = point.x + (int)((double)(n2 - point.y) / d);
            }
        }
        return new Point(n, n2);
    }
}

