/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.App1;
import expr.App2;
import expr.Literal;
import expr.Var_ref;
import expr.Variable;

public abstract class Expr {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int ABS = 100;
    public static final int ACOS = 101;
    public static final int ASIN = 102;
    public static final int ATAN = 103;
    public static final int CEIL = 104;
    public static final int COS = 105;
    public static final int EXP = 106;
    public static final int FLOOR = 107;
    public static final int LOG = 108;
    public static final int NEG = 109;
    public static final int ROUND = 110;
    public static final int SIN = 111;
    public static final int SQRT = 112;
    public static final int TAN = 113;

    public abstract double value();

    public static Expr make_literal(double d) {
        return new Literal(d);
    }

    public static Expr make_var_ref(Variable variable) {
        return new Var_ref(variable);
    }

    public static Expr make_app1(int n, Expr expr) {
        App1 app1 = new App1(n, expr);
        if (expr instanceof Literal) {
            return new Literal(((Expr)app1).value());
        }
        return app1;
    }

    public static Expr make_app2(int n, Expr expr, Expr expr2) {
        App2 app2 = new App2(n, expr, expr2);
        if (expr instanceof Literal && expr2 instanceof Literal) {
            return new Literal(((Expr)app2).value());
        }
        return app2;
    }
}

