/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.freehep.util.io.IndentPrintWriter;
import org.freehep.xml.util.XMLCharacterProperties;
import org.freehep.xml.util.XMLTagWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter
implements XMLTagWriter {
    protected boolean closed = true;
    private String dtdName = null;
    private Hashtable attributes = new Hashtable();
    private Stack openTags = new Stack();
    protected IndentPrintWriter writer;
    protected String defaultNameSpace;

    public XMLWriter(Writer writer, String string, String string2) {
        this.writer = new IndentPrintWriter(writer);
        this.writer.setIndentString(string);
        this.defaultNameSpace = string2;
    }

    public XMLWriter(Writer writer, String string) {
        this(writer, string, "");
    }

    public XMLWriter(Writer writer) {
        this(writer, "  ");
    }

    public void close() throws IOException {
        this.closeDoc();
        this.writer.close();
    }

    public void openDoc() {
        this.openDoc("1.0", "", false);
    }

    public void openDoc(String string, String string2, boolean bl) {
        String string3 = this.writer.getIndentString();
        this.writer.setIndentString(string3);
        this.closed = false;
        if (!XMLCharacterProperties.validVersionNum(string)) {
            throw new RuntimeException("Invalid version number: " + string);
        }
        this.writer.print("<?xml version=\"");
        this.writer.print(string);
        this.writer.print("\" ");
        if (string2 != null && !string2.equals("")) {
            if (!XMLCharacterProperties.validEncName(string2)) {
                throw new RuntimeException("Invalid encoding name: " + string2);
            }
            this.writer.print("encoding=\"");
            this.writer.print(string2);
            this.writer.print("\" ");
        }
        if (bl) {
            this.writer.print("standalone=\"yes\" ");
        }
        this.writer.println("?>");
        this.writer.setIndentString(string3);
    }

    public void referToDTD(String string, String string2, String string3) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = string;
        this.writer.println("<!DOCTYPE " + string + " PUBLIC \"" + string2 + "\" \"" + string3 + "\">");
    }

    public void referToDTD(String string, String string2) {
        if (this.dtdName != null) {
            throw new RuntimeException("ReferToDTD cannot be called twice");
        }
        this.dtdName = string;
        this.writer.println("<!DOCTYPE " + string + " SYSTEM \"" + string2 + "\">");
    }

    public void closeDoc() {
        if (!this.closed) {
            if (!this.openTags.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("Not all tags were closed before closing XML document:\n");
                while (!this.openTags.isEmpty()) {
                    stringBuffer.append("   </");
                    stringBuffer.append((String)this.openTags.pop());
                    stringBuffer.append(">\n");
                }
                throw new RuntimeException(stringBuffer.toString());
            }
            this.closed = true;
        }
        this.writer.flush();
    }

    public void printComment(String string) {
        if (string.indexOf("--") >= 0) {
            throw new RuntimeException("'--' sequence not allowed in comment");
        }
        this.writer.print("<!--");
        this.writer.print(XMLWriter.normalizeText(string));
        this.writer.println("-->");
    }

    public void print(String string) {
        this.writer.print(XMLWriter.normalizeText(string));
    }

    public void println(String string) {
        this.print(string);
        this.writer.println();
    }

    public void openTag(String string, String string2) {
        if (string.equals(this.defaultNameSpace)) {
            this.openTag(string2);
        } else {
            this.openTag(string + ":" + string2);
        }
    }

    public void openTag(String string) {
        this.checkNameValid(string);
        if (this.openTags.isEmpty() && this.dtdName != null && !this.dtdName.equals(string)) {
            throw new RuntimeException("First tag: '" + string + "' not equal to DTD id: '" + this.dtdName + "'");
        }
        this.writer.print("<" + string);
        this.printAttributes(string.length());
        this.writer.println(">");
        this.writer.indent();
        this.openTags.push(string);
    }

    public void closeTag() {
        if (this.openTags.isEmpty()) {
            this.writer.close();
            throw new RuntimeException("No open tags");
        }
        Object e2 = this.openTags.pop();
        this.writer.outdent();
        this.writer.print("</");
        this.writer.print(e2);
        this.writer.println(">");
    }

    public void printTag(String string, String string2) {
        if (string.equals(this.defaultNameSpace)) {
            this.printTag(string2);
        } else {
            this.printTag(string + ":" + string2);
        }
    }

    public void printTag(String string) {
        this.checkNameValid(string);
        this.writer.print("<" + string);
        this.printAttributes(string.length());
        this.writer.println("/>");
    }

    public void setAttribute(String string, String string2) {
        if (string != null && string2 != null) {
            this.attributes.put(string, string2);
        }
    }

    public void setAttribute(String string, String string2, String string3) {
        if (string != null && string2 != null) {
            this.attributes.put(string + ":" + string2, string3);
        }
    }

    public void setAttribute(String string, byte by) {
        this.setAttribute(string, String.valueOf(by));
    }

    public void setAttribute(String string, char c2) {
        this.setAttribute(string, String.valueOf(c2));
    }

    public void setAttribute(String string, long l2) {
        this.setAttribute(string, String.valueOf(l2));
    }

    public void setAttribute(String string, int n2) {
        this.setAttribute(string, String.valueOf(n2));
    }

    public void setAttribute(String string, short s2) {
        this.setAttribute(string, String.valueOf(s2));
    }

    public void setAttribute(String string, boolean bl) {
        this.setAttribute(string, String.valueOf(bl));
    }

    public void setAttribute(String string, float f2) {
        this.setAttribute(string, String.valueOf(f2));
    }

    public void setAttribute(String string, double d2) {
        this.setAttribute(string, String.valueOf(d2));
    }

    public void setAttribute(String string, Color color) {
        this.setAttribute(string, String.valueOf(color));
    }

    public void setAttribute(String string, String string2, byte by) {
        this.setAttribute(string + ":" + string2, String.valueOf(by));
    }

    public void setAttribute(String string, String string2, char c2) {
        this.setAttribute(string + ":" + string2, String.valueOf(c2));
    }

    public void setAttribute(String string, String string2, long l2) {
        this.setAttribute(string + ":" + string2, String.valueOf(l2));
    }

    public void setAttribute(String string, String string2, int n2) {
        this.setAttribute(string + ":" + string2, String.valueOf(n2));
    }

    public void setAttribute(String string, String string2, short s2) {
        this.setAttribute(string + ":" + string2, String.valueOf(s2));
    }

    public void setAttribute(String string, String string2, boolean bl) {
        this.setAttribute(string + ":" + string2, String.valueOf(bl));
    }

    public void setAttribute(String string, String string2, float f2) {
        this.setAttribute(string + ":" + string2, String.valueOf(f2));
    }

    public void setAttribute(String string, String string2, double d2) {
        this.setAttribute(string + ":" + string2, String.valueOf(d2));
    }

    public void setAttribute(String string, String string2, Color color) {
        this.setAttribute(string + ":" + string2, String.valueOf(color));
    }

    protected void printAttributes(int n2) {
        int n3 = n2 + 1;
        boolean bl = false;
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            this.checkNameValid(string);
            String string2 = XMLWriter.normalize(this.attributes.get(string).toString());
            int n4 = string.length() + string2.length() + 3;
            if (n3 > 0 && n3 + n4 + 2 * this.writer.getIndent() > 60) {
                n3 = 0;
                this.writer.println();
                if (!bl) {
                    this.writer.indent();
                    bl = true;
                }
            } else {
                n3 += n4;
                this.writer.print(' ');
            }
            this.writer.print(string);
            this.writer.print("=\"");
            this.writer.print(string2);
            this.writer.print("\"");
        }
        this.attributes.clear();
        if (bl) {
            this.writer.outdent();
        }
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short s2 = node.getNodeType();
        switch (s2) {
            case 9: {
                throw new RuntimeException("No support for printing nodes of type Document");
            }
            case 1: {
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                    Node node2 = namedNodeMap.item(i2);
                    this.setAttribute(node2.getNodeName(), node2.getNodeValue());
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) {
                    this.printTag(node.getNodeName());
                    break;
                }
                this.openTag(node.getNodeName());
                int n2 = nodeList.getLength();
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.print(nodeList.item(i3));
                }
                this.closeTag();
                break;
            }
            case 5: {
                this.writer.print('&');
                this.writer.print(node.getNodeName());
                this.writer.print(';');
                break;
            }
            case 4: {
                this.writer.print("<![CDATA[");
                this.writer.print(node.getNodeValue());
                this.writer.print("]]>");
                break;
            }
            case 3: {
                this.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.writer.print("<?");
                this.writer.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.writer.print(' ');
                    this.writer.print(string);
                }
                this.writer.print("?>");
            }
        }
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string != null ? string.length() : 0;
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c2));
                    stringBuffer.append(';');
                    continue block7;
                }
                default: {
                    if (c2 > '\u00ff') {
                        String string2 = "0000" + Integer.toHexString(c2);
                        stringBuffer.append("&#x");
                        stringBuffer.append(string2.substring(string2.length() - 4));
                        stringBuffer.append(';');
                        continue block7;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String normalizeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string != null ? string.length() : 0;
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block5;
                }
                default: {
                    if (c2 > '\u007f') {
                        String string2 = "0000" + Integer.toHexString(c2);
                        stringBuffer.append("&#x");
                        stringBuffer.append(string2.substring(string2.length() - 4));
                        stringBuffer.append(';');
                        continue block5;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected void checkNameValid(String string) {
        if (!XMLCharacterProperties.validName(string)) {
            throw new RuntimeException("Invalid name: " + string);
        }
    }
}

