/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.menus;

import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.parsers.SAXParserFactory;
import org.freehep.util.images.ImageHandler;
import org.freehep.xml.util.BadXMLException;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.freehep.xml.util.SAXErrorHandler;
import org.freehep.xml.util.SAXTraverser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLMenuBuilder {
    public static final String LOCATION_PROPERTY = "Location";
    private static ClassLoader defaultLoader;
    private Class defaultMenuBarClass = JMenuBar.class;
    private Class defaultToolBarClass = JToolBar.class;
    private Class defaultMenuItemClass = JMenuItem.class;
    private Class defaultRadioButtonMenuItemClass = JRadioButtonMenuItem.class;
    private Class defaultCheckBoxMenuItemClass = JCheckBoxMenuItem.class;
    private Class defaultPopupMenuClass = JPopupMenu.class;
    private Class defaultToolBarButtonClass = JButton.class;
    private Class defaultMenuClass = JMenu.class;
    private URL baseURL;
    private Hashtable menuBarHash = new Hashtable();
    private Hashtable toolBarHash = new Hashtable();
    private Hashtable popupMenuHash = new Hashtable();
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public XMLMenuBuilder() {
        UIManager.addPropertyChangeListener(new UIListener(this));
    }

    public void build(URL uRL) throws SAXException, IOException {
        XMLReader xMLReader;
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (SecurityException securityException) {
            try {
                String string = System.getProperty("org.xml.sax.driver");
                if (string == null) {
                    System.getProperties().setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
                }
            }
            catch (SecurityException securityException2) {
                // empty catch block
            }
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error creating XML Parser", exception);
        }
        this.build(uRL, xMLReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(URL uRL, XMLReader xMLReader) throws SAXException, IOException {
        xMLReader.setFeature("http://xml.org/sax/features/validation", true);
        xMLReader.setEntityResolver(new ClassPathEntityResolver(XMLMenuBuilder.class, "http://java.freehep.org/schemas/menus/"));
        MenuSystemTraverser menuSystemTraverser = new MenuSystemTraverser();
        menuSystemTraverser.setReader(xMLReader);
        xMLReader.setErrorHandler(new SAXErrorHandler());
        this.baseURL = uRL;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            InputSource inputSource = new InputSource(bufferedInputStream);
            inputSource.setSystemId(uRL.toString());
            inputSource.setPublicId(uRL.getFile());
            xMLReader.parse(inputSource);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public void setDefaultMenuBarClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultMenuBarClass = this.setDefaultClass(JMenuBar.class, clazz);
    }

    public void setDefaultMenuClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultMenuClass = this.setDefaultClass(JMenu.class, clazz);
    }

    public void setDefaultMenuItemClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultMenuItemClass = this.setDefaultClass(JMenuItem.class, clazz);
    }

    public void setDefaultRadioMenuItemClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultRadioButtonMenuItemClass = this.setDefaultClass(JMenuItem.class, clazz);
    }

    public void setDefaultCheckBoxMenuItemClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultCheckBoxMenuItemClass = this.setDefaultClass(JMenuItem.class, clazz);
    }

    public void setDefaultPopupMenuClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultPopupMenuClass = this.setDefaultClass(JPopupMenu.class, clazz);
    }

    public void setDefaultToolBarClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultToolBarClass = this.setDefaultClass(JToolBar.class, clazz);
    }

    public void setDefaultToolBarItemClass(Class clazz) throws IllegalDefaultClassException {
        this.defaultToolBarButtonClass = this.setDefaultClass(JButton.class, clazz);
    }

    protected JMenuBar createMenuBar(String string) throws SAXException {
        Class clazz = string == null ? this.defaultMenuBarClass : this.findClass(string);
        return (JMenuBar)this.createObject(clazz, JMenuBar.class);
    }

    protected JMenu createMenu(String string) throws SAXException {
        Class clazz = string == null ? this.defaultMenuClass : this.findClass(string);
        return (JMenu)this.createObject(clazz, JMenu.class);
    }

    protected JMenuItem createMenuItem(String string, String string2, String string3, String string4) throws SAXException {
        Class clazz = string == null ? (string3.equals("checkbox") ? this.defaultCheckBoxMenuItemClass : (string3.equals("radio") ? this.defaultRadioButtonMenuItemClass : this.defaultMenuItemClass)) : this.findClass(string);
        JMenuItem jMenuItem = (JMenuItem)this.createObject(clazz, JMenuItem.class);
        jMenuItem.setText(string2);
        if (string4 != null) {
            jMenuItem.setActionCommand(string4);
        }
        return jMenuItem;
    }

    protected JPopupMenu createPopupMenu(String string) throws SAXException {
        Class clazz = string == null ? this.defaultPopupMenuClass : this.findClass(string);
        return (JPopupMenu)this.createObject(clazz, JPopupMenu.class);
    }

    protected JToolBar createToolBar(String string) throws SAXException {
        Class clazz = string == null ? this.defaultToolBarClass : this.findClass(string);
        return (JToolBar)this.createObject(clazz, JToolBar.class);
    }

    protected AbstractButton createToolBarItem(String string, String string2, String string3, String string4) throws SAXException {
        Class clazz = string == null ? this.defaultToolBarButtonClass : this.findClass(string);
        clazz = string3.equals("checkbox") ? JToggleButton.class : JButton.class;
        AbstractButton abstractButton = (AbstractButton)this.createObject(clazz, AbstractButton.class);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        if (string4 != null) {
            abstractButton.setActionCommand(string4);
        }
        return abstractButton;
    }

    protected Icon createIcon(String string) throws SAXException {
        try {
            URL uRL = null;
            if (string.startsWith("/")) {
                uRL = this.getClass().getResource(string);
            }
            if (uRL == null) {
                uRL = new URL(this.baseURL, string);
            }
            return ImageHandler.getIcon(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BadXMLException("Could not load image: " + string, (Throwable)malformedURLException);
        }
    }

    private void merge(JComponent jComponent, JComponent jComponent2) {
        if (jComponent2 instanceof JMenu) {
            jComponent2 = ((JMenu)jComponent2).getPopupMenu();
        }
        if (jComponent instanceof JMenu) {
            jComponent = ((JMenu)jComponent).getPopupMenu();
        }
        block0: for (int i2 = 0; i2 < jComponent2.getComponentCount(); ++i2) {
            JComponent jComponent3;
            Integer n2;
            Component component = jComponent2.getComponent(i2);
            if (component instanceof JComponent && (n2 = (Integer)(jComponent3 = (JComponent)component).getClientProperty(LOCATION_PROPERTY)) != null) {
                int n3 = jComponent.getComponentCount();
                for (int i3 = 0; i3 < n3; ++i3) {
                    JComponent jComponent4;
                    Integer n4;
                    Component component2 = jComponent.getComponent(i3);
                    if (!(component2 instanceof JComponent) || (n4 = (Integer)(jComponent4 = (JComponent)component2).getClientProperty(LOCATION_PROPERTY)) == null) continue;
                    if (n4.equals(n2)) {
                        this.merge(jComponent4, jComponent3);
                        continue block0;
                    }
                    if (n4.compareTo(n2) <= 0) continue;
                    jComponent.add((Component)jComponent3, i3);
                    --i2;
                    continue block0;
                }
            }
            jComponent.add(component);
            --i2;
        }
    }

    public JMenuBar getMenuBar(String string) {
        return (JMenuBar)this.menuBarHash.get(string);
    }

    public JToolBar getToolBar(String string) {
        return (JToolBar)this.toolBarHash.get(string);
    }

    public JPopupMenu getPopupMenu(String string) {
        return (JPopupMenu)this.popupMenuHash.get(string);
    }

    public JPopupMenu mergePopupMenu(String string, JPopupMenu jPopupMenu) {
        try {
            JPopupMenu jPopupMenu2 = this.getPopupMenu(string);
            if (jPopupMenu == null) {
                return jPopupMenu2;
            }
            Component[] componentArray = jPopupMenu2.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (componentArray[i2] instanceof JSeparator) {
                    jPopupMenu.addSeparator();
                    continue;
                }
                jPopupMenu.add(this.deepCopy(componentArray[i2]));
            }
            return jPopupMenu;
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Error parsing XML", sAXException);
        }
    }

    private Component deepCopy(Component component) throws SAXException {
        if (component instanceof JMenu) {
            JMenu jMenu = (JMenu)component;
            JMenu jMenu2 = this.createMenu(jMenu.getClass().getName());
            Component[] componentArray = jMenu.getPopupMenu().getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (componentArray[i2] instanceof JSeparator) {
                    jMenu2.addSeparator();
                    continue;
                }
                jMenu2.add(this.deepCopy(componentArray[i2]));
            }
            jMenu2.setText(jMenu.getText());
            jMenu2.setMnemonic(jMenu.getMnemonic());
            return jMenu2;
        }
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            JMenuItem jMenuItem2 = this.createMenuItem(jMenuItem.getClass().getName(), jMenuItem.getText(), null, jMenuItem.getActionCommand());
            jMenuItem2.setToolTipText(jMenuItem.getToolTipText());
            jMenuItem2.setIcon(jMenuItem.getIcon());
            jMenuItem2.setMnemonic(jMenuItem.getMnemonic());
            jMenuItem2.setAccelerator(jMenuItem.getAccelerator());
            return jMenuItem2;
        }
        return component;
    }

    private Object createObject(Class clazz, Class clazz2) throws SAXException {
        try {
            if (!clazz2.isAssignableFrom(clazz)) {
                throw new SAXException("Illegal class " + clazz);
            }
            return clazz.newInstance();
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new BadXMLException("Could not create " + clazz, (Throwable)exception);
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        defaultLoader = classLoader;
    }

    private Class findClass(String string) throws SAXException {
        try {
            ClassLoader classLoader = defaultLoader;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BadXMLException("Can not find class " + string, (Throwable)classNotFoundException);
        }
    }

    private Class setDefaultClass(Class clazz, Class clazz2) throws IllegalDefaultClassException {
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz2;
        }
        throw new IllegalDefaultClassException("Cannot assign into " + clazz + " from " + clazz2);
    }

    private class AcceleratorTraverser
    extends SAXTraverser {
        protected KeyStroke key;

        private AcceleratorTraverser() {
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            boolean bl;
            String string = attributes.getValue("key");
            String string2 = System.getProperty("os.name").toLowerCase();
            boolean bl2 = string2.startsWith("mac os x");
            String string3 = attributes.getValue("command");
            boolean bl3 = string3 == null;
            boolean bl4 = !bl3 && this.toBoolean(string3);
            boolean bl5 = !bl2 && bl4 || this.toBoolean(attributes.getValue("ctrl"));
            boolean bl6 = this.toBoolean(attributes.getValue("alt"));
            boolean bl7 = this.toBoolean(attributes.getValue("shift"));
            boolean bl8 = bl = bl2 && bl4 || this.toBoolean(attributes.getValue("meta"));
            if (bl3 && bl2) {
                boolean bl9 = bl5;
                bl5 = bl;
                bl = bl9;
            }
            try {
                this.key = KeyStroke.getKeyStroke((class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = XMLMenuBuilder.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField(string).getInt(null), (bl5 ? 2 : 0) + (bl6 ? 8 : 0) + (bl7 ? 1 : 0) + (bl ? 4 : 0));
            }
            catch (Exception exception) {
                throw new BadXMLException("Illegal accelerator key: " + string);
            }
        }

        KeyStroke getAccelerator() {
            return this.key;
        }
    }

    private abstract class ComponentTraverser
    extends MenuSystemTraverser {
        private ComponentTraverser() {
        }

        protected void handleSubElement(SAXTraverser sAXTraverser) {
            if (sAXTraverser instanceof AcceleratorTraverser) {
                this.setAccelerator(((AcceleratorTraverser)sAXTraverser).getAccelerator());
            }
        }

        abstract void setAccelerator(KeyStroke var1);
    }

    public static class IllegalDefaultClassException
    extends RuntimeException {
        IllegalDefaultClassException(String string) {
            super(string);
        }
    }

    private class MenuBarTraverser
    extends MenuSystemTraverser {
        private JMenuBar menuBar;
        private String id;

        private MenuBarTraverser() {
        }

        protected void handleSubElement(SAXTraverser sAXTraverser) throws SAXException {
            if (sAXTraverser instanceof MenuTraverser) {
                this.menuBar.add(((MenuTraverser)sAXTraverser).getMenu());
            }
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue("class");
            this.menuBar = XMLMenuBuilder.this.createMenuBar(string);
            this.id = attributes.getValue("id");
        }

        protected void handleEndElement(String string) {
            JMenuBar jMenuBar = (JMenuBar)XMLMenuBuilder.this.menuBarHash.get(this.id);
            if (jMenuBar == null) {
                XMLMenuBuilder.this.menuBarHash.put(this.id, this.menuBar);
            } else {
                XMLMenuBuilder.this.merge(jMenuBar, this.menuBar);
            }
        }
    }

    private class MenuItemTraverser
    extends ComponentTraverser {
        private JMenuItem item;

        private MenuItemTraverser() {
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            String string;
            String string2;
            String string3 = attributes.getValue("class");
            String string4 = attributes.getValue("name");
            String string5 = attributes.getValue("type");
            String string6 = attributes.getValue("command");
            this.item = XMLMenuBuilder.this.createMenuItem(string3, string4, string5, string6);
            String string7 = attributes.getValue("mnemonic");
            if (string7 != null) {
                this.item.setMnemonic(string7.charAt(0));
            }
            if ((string2 = attributes.getValue("location")) != null) {
                this.item.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(string2));
            }
            if ((string = attributes.getValue("description")) == null) {
                string = string4;
            }
            this.item.setToolTipText(string);
            String string8 = attributes.getValue("icon");
            if (string8 != null) {
                this.item.setIcon(XMLMenuBuilder.this.createIcon(string8));
            }
        }

        protected void setAccelerator(KeyStroke keyStroke) {
            this.item.setAccelerator(keyStroke);
        }

        JMenuItem getMenuItem() {
            return this.item;
        }
    }

    private class MenuSystemTraverser
    extends SAXTraverser {
        private MenuSystemTraverser() {
        }

        protected SAXTraverser handleElement(String string, Attributes attributes) throws SAXException {
            if (string == "MenuSystem") {
                return this;
            }
            if (string == "MenuBar") {
                return new MenuBarTraverser();
            }
            if (string == "ToolBar") {
                return new ToolBarTraverser();
            }
            if (string == "PopupMenu") {
                return new PopupMenuTraverser();
            }
            if (string == "Menu") {
                return new MenuTraverser();
            }
            if (string == "Component") {
                return new MenuItemTraverser();
            }
            if (string == "Accelerator") {
                return new AcceleratorTraverser();
            }
            if (string == "Separator") {
                return new SeparatorTraverser();
            }
            return super.handleElement(string, attributes);
        }
    }

    private class MenuTraverser
    extends MenuSystemTraverser {
        private JMenu menu;

        private MenuTraverser() {
        }

        protected void handleSubElement(SAXTraverser sAXTraverser) {
            if (sAXTraverser instanceof MenuItemTraverser) {
                this.menu.add(((MenuItemTraverser)sAXTraverser).getMenuItem());
            } else if (sAXTraverser instanceof MenuTraverser) {
                this.menu.add(((MenuTraverser)sAXTraverser).getMenu());
            } else if (sAXTraverser instanceof SeparatorTraverser) {
                JPopupMenu.Separator separator = new JPopupMenu.Separator();
                String string = ((SeparatorTraverser)sAXTraverser).getLocation();
                if (string != null) {
                    separator.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(string));
                }
                this.menu.add(separator);
            }
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            String string;
            String string2 = attributes.getValue("class");
            this.menu = XMLMenuBuilder.this.createMenu(string2);
            this.menu.setText(attributes.getValue("name"));
            String string3 = attributes.getValue("mnemonic");
            if (string3 != null) {
                this.menu.setMnemonic(string3.charAt(0));
            }
            if ((string = attributes.getValue("location")) != null) {
                this.menu.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(string));
            }
        }

        JMenu getMenu() {
            return this.menu;
        }
    }

    private class PopupMenuTraverser
    extends MenuSystemTraverser {
        private JPopupMenu menu;
        private String id;

        private PopupMenuTraverser() {
        }

        protected void handleSubElement(SAXTraverser sAXTraverser) throws SAXException {
            if (sAXTraverser instanceof MenuItemTraverser) {
                this.menu.add(((MenuItemTraverser)sAXTraverser).getMenuItem());
            } else if (sAXTraverser instanceof MenuTraverser) {
                this.menu.add(((MenuTraverser)sAXTraverser).getMenu());
            } else if (sAXTraverser instanceof SeparatorTraverser) {
                JPopupMenu.Separator separator = new JPopupMenu.Separator();
                String string = ((SeparatorTraverser)sAXTraverser).getLocation();
                if (string != null) {
                    separator.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(string));
                }
                this.menu.add(separator);
            }
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue("class");
            this.menu = XMLMenuBuilder.this.createPopupMenu(string);
            this.menu.setName(attributes.getValue("name"));
            this.id = attributes.getValue("id");
        }

        protected void handleEndElement(String string) {
            XMLMenuBuilder.this.popupMenuHash.put(this.id, this.menu);
        }
    }

    private class SeparatorTraverser
    extends MenuSystemTraverser {
        private String location;

        private SeparatorTraverser() {
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            this.location = attributes.getValue("location");
        }

        String getLocation() {
            return this.location;
        }
    }

    private class ToolBarItemTraverser
    extends ComponentTraverser {
        private AbstractButton item;

        private ToolBarItemTraverser() {
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            String string;
            String string2;
            String string3 = attributes.getValue("class");
            String string4 = attributes.getValue("name");
            String string5 = attributes.getValue("type");
            String string6 = attributes.getValue("command");
            this.item = XMLMenuBuilder.this.createToolBarItem(string3, string4, string5, string6);
            String string7 = attributes.getValue("mnemonic");
            if (string7 != null) {
                this.item.setMnemonic(string7.charAt(0));
            }
            if ((string2 = attributes.getValue("location")) != null) {
                this.item.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, string2);
            }
            if ((string = attributes.getValue("description")) == null) {
                string = string4;
            }
            this.item.setToolTipText(string);
            String string8 = attributes.getValue("icon");
            if (string8 != null) {
                this.item.setIcon(XMLMenuBuilder.this.createIcon(string8));
            }
        }

        protected void setAccelerator(KeyStroke keyStroke) {
        }

        AbstractButton getToolBarItem() {
            return this.item;
        }
    }

    private class ToolBarTraverser
    extends MenuSystemTraverser {
        private String id;
        private JToolBar toolBar;

        private ToolBarTraverser() {
        }

        protected SAXTraverser handleElement(String string, Attributes attributes) throws SAXException {
            if (string == "Component") {
                return new ToolBarItemTraverser();
            }
            return super.handleElement(string, attributes);
        }

        protected void handleSubElement(SAXTraverser sAXTraverser) {
            if (sAXTraverser instanceof ToolBarItemTraverser) {
                this.toolBar.add(((ToolBarItemTraverser)sAXTraverser).getToolBarItem());
            } else if (sAXTraverser instanceof SeparatorTraverser) {
                JToolBar.Separator separator = new JToolBar.Separator();
                separator.setOrientation(1);
                String string = ((SeparatorTraverser)sAXTraverser).getLocation();
                if (string != null) {
                    separator.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(string));
                }
                this.toolBar.add(separator);
            }
        }

        protected void handleElementAttributes(Attributes attributes) throws SAXException {
            this.id = attributes.getValue("id");
            String string = attributes.getValue("class");
            this.toolBar = XMLMenuBuilder.this.createToolBar(string);
            this.toolBar.setName(attributes.getValue("name"));
            this.toolBar.setRollover(this.toBoolean(attributes.getValue("rollover")));
        }

        protected void handleEndElement(String string) {
            XMLMenuBuilder.this.toolBarHash.put(this.id, this.toolBar);
        }
    }

    private static class UIListener
    implements PropertyChangeListener {
        WeakReference link;

        UIListener(XMLMenuBuilder xMLMenuBuilder) {
            this.link = new WeakReference<XMLMenuBuilder>(xMLMenuBuilder);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            XMLMenuBuilder xMLMenuBuilder = (XMLMenuBuilder)this.link.get();
            if (xMLMenuBuilder == null) {
                UIManager.removePropertyChangeListener(this);
            } else if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                Enumeration enumeration = xMLMenuBuilder.popupMenuHash.elements();
                while (enumeration.hasMoreElements()) {
                    JComponent jComponent = (JComponent)enumeration.nextElement();
                    SwingUtilities.updateComponentTreeUI(jComponent);
                }
            }
        }
    }
}

