/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.freehep.xml.io.DefaultXMLIORegistry;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOFileManager;
import org.freehep.xml.io.XMLIOProxy;
import org.freehep.xml.io.XMLIORegistry;
import org.freehep.xml.io.XMLIOStreamManager;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XMLIOManager {
    private Hashtable objIdHash = new Hashtable();
    private Hashtable idHash = new Hashtable();
    private Hashtable nodeHash = new Hashtable();
    private Hashtable classHash = new Hashtable();
    private Hashtable refTable = new Hashtable();
    private XMLIORegistry xmlioRegistry;
    private XMLIOStreamManager xmlioStreamManager;
    private boolean useId = true;

    public XMLIOManager(String string) {
        this(new DefaultXMLIORegistry(), new XMLIOFileManager(string), true);
    }

    private XMLIOManager(XMLIORegistry xMLIORegistry, XMLIOStreamManager xMLIOStreamManager, boolean bl) {
        this.setXMLIORegistry(xMLIORegistry);
        this.setXMLIOStreamManager(xMLIOStreamManager);
        this.useId = bl;
    }

    protected void setXMLIORegistry(XMLIORegistry xMLIORegistry) {
        this.xmlioRegistry = xMLIORegistry;
    }

    public XMLIORegistry getXMLIORegistry() {
        return this.xmlioRegistry;
    }

    public void setXMLIOStreamManager(XMLIOStreamManager xMLIOStreamManager) {
        this.xmlioStreamManager = xMLIOStreamManager;
    }

    public XMLIOStreamManager getXMLIOStreamManager() {
        return this.xmlioStreamManager;
    }

    public Object restore(Object object, Element element) {
        String string = element.getAttributeValue("objIdRef");
        if (string != null && this.useId) {
            if (this.isObjIdRegistered(string)) {
                return this.getObj(string);
            }
            return this.restore(object, (Element)this.refTable.get(string));
        }
        String string2 = element.getAttributeValue("objId");
        if (this.useId && this.isObjIdRegistered(string2)) {
            return this.getObj(string2);
        }
        Class clazz = this.classHash.containsKey(element.getName()) ? (Class)this.classHash.get(element.getName()) : this.xmlioRegistry.getIdClass(element.getName());
        if (object == null) {
            object = this.getXMLIOFactory(clazz).createObject(clazz);
        }
        if (this.useId) {
            this.registerObj(object, string2);
        }
        if (object instanceof XMLIO) {
            ((XMLIO)object).restore(this, element);
        } else {
            this.getXMLIOProxy(clazz).restore(object, this, element);
        }
        return object;
    }

    public Object restore(Element element) {
        return this.restore(null, element);
    }

    public Element saveAs(Object object, Class clazz) {
        String string = this.nodeHash.containsKey(clazz) ? (String)this.nodeHash.get(clazz) : this.xmlioRegistry.getClassId(clazz);
        Element element = new Element(string);
        if (this.isObjRegistered(object)) {
            element.setAttribute("objIdRef", this.getObjId(object));
        } else {
            if (this.useId) {
                element.setAttribute("objId", this.registerObj(object));
            }
            if (object instanceof XMLIO) {
                ((XMLIO)object).save(this, element);
            } else {
                this.getXMLIOProxy(clazz).save(object, this, element);
            }
        }
        return element;
    }

    public Element save(Object object) {
        return this.saveAs(object, object.getClass());
    }

    public void saveToXML(Object[] objectArray, Element element) {
        this.resetObjId();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            element.addContent((Content)this.save(objectArray[i2]));
        }
        try {
            this.xmlioStreamManager.saveRootElement(element);
        }
        catch (IOException iOException) {
            System.out.println(" Problem with file " + iOException.getMessage());
        }
    }

    public Object[] restoreFromXML() {
        this.resetObjId();
        Object[] objectArray = null;
        try {
            Element element = this.xmlioStreamManager.getRootElement();
            List list = element.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.loadRefTable((Element)iterator.next());
            }
            objectArray = new Object[list.size()];
            int n2 = 0;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                objectArray[n2++] = this.restore((Element)iterator2.next());
            }
        }
        catch (JDOMException jDOMException) {
            System.out.println(" Problem with restoring " + jDOMException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(" Problem with file " + iOException.getMessage());
        }
        return objectArray;
    }

    public void setClassId(Class clazz, String string) {
        this.nodeHash.put(clazz, string);
        this.classHash.put(string, clazz);
    }

    protected void loadRefTable(Element element) {
        String string = element.getAttributeValue("objId");
        if (string != null) {
            this.refTable.put(string, element);
        }
        List list = element.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.loadRefTable((Element)iterator.next());
        }
    }

    private String makeObjId(Object object) {
        String string = object.getClass().getName();
        String string2 = object.getClass().getPackage().getName();
        String string3 = string.substring(string2.length() + 1, string.length()).trim();
        while (string3.indexOf(36) != -1) {
            string3 = string3.substring(string3.indexOf(36) + 1, string3.length()).trim();
        }
        int n2 = 1;
        if (this.idHash.containsKey(string3)) {
            n2 = (Integer)this.idHash.get(string3) + 1;
        }
        this.idHash.put(string3, new Integer(n2));
        String string4 = string3 + n2;
        return string4;
    }

    private String registerObj(Object object) {
        if (this.objIdHash.contains(object)) {
            return this.getObjId(object);
        }
        String string = this.makeObjId(object);
        this.objIdHash.put(string, object);
        return string;
    }

    private void registerObj(Object object, String string) {
        if (this.objIdHash.containsKey(string)) {
            return;
        }
        this.objIdHash.put(string, object);
    }

    private String getObjId(Object object) {
        Enumeration enumeration = this.objIdHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.objIdHash.get(string).equals(object)) continue;
            return string;
        }
        return (String)object;
    }

    private Object getObj(String string) {
        if (this.objIdHash.containsKey(string)) {
            return this.objIdHash.get(string);
        }
        return string;
    }

    private boolean isObjRegistered(Object object) {
        return this.objIdHash.contains(object);
    }

    private boolean isObjIdRegistered(String string) {
        return this.objIdHash.containsKey(string);
    }

    public void resetObjId() {
        this.objIdHash.clear();
        this.idHash.clear();
        this.refTable.clear();
    }

    protected XMLIOFactory getXMLIOFactory(Class clazz) {
        return this.xmlioRegistry.getXMLIOFactory(clazz);
    }

    protected XMLIOProxy getXMLIOProxy(Class clazz) {
        return this.xmlioRegistry.getXMLIOProxy(clazz);
    }
}

