/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.wbxml;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.wbxml.WBXMLParser;
import org.freehep.wbxml.WBXMLTagWriter;

public class WBXMLWriter
implements WBXMLTagWriter {
    private DataOutputStream os;
    private String dtd;
    private String version;
    private boolean writtenHeader;
    private int tagPage;
    private int attributePage;
    private boolean hasAttributes;
    private int[] attributeTypes;
    private boolean[][] attributeBoolean;
    private int[] attributeBooleanOffset;
    private int[] attributeBooleanLength;
    private byte[][] attributeByte;
    private int[] attributeByteOffset;
    private int[] attributeByteLength;
    private char[][] attributeChar;
    private int[] attributeCharOffset;
    private int[] attributeCharLength;
    private double[][] attributeDouble;
    private int[] attributeDoubleOffset;
    private int[] attributeDoubleLength;
    private float[][] attributeFloat;
    private int[] attributeFloatOffset;
    private int[] attributeFloatLength;
    private int[][] attributeInt;
    private int[] attributeIntOffset;
    private int[] attributeIntLength;
    private long[][] attributeLong;
    private int[] attributeLongOffset;
    private int[] attributeLongLength;
    private short[][] attributeShort;
    private int[] attributeShortOffset;
    private int[] attributeShortLength;
    private String[][] attributeString;
    private int[] attributeStringOffset;
    private int[] attributeStringLength;
    private String encoding;
    private boolean standalone;

    public WBXMLWriter(OutputStream outputStream, int n2) throws IOException {
        this.os = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.tagPage = 0;
        this.attributePage = 0;
        int n3 = n2 + 1;
        this.attributeBoolean = new boolean[n3][];
        this.attributeBooleanOffset = new int[n3];
        this.attributeBooleanLength = new int[n3];
        this.attributeByte = new byte[n3][];
        this.attributeByteOffset = new int[n3];
        this.attributeByteLength = new int[n3];
        this.attributeChar = new char[n3][];
        this.attributeCharOffset = new int[n3];
        this.attributeCharLength = new int[n3];
        this.attributeDouble = new double[n3][];
        this.attributeDoubleOffset = new int[n3];
        this.attributeDoubleLength = new int[n3];
        this.attributeFloat = new float[n3][];
        this.attributeFloatOffset = new int[n3];
        this.attributeFloatLength = new int[n3];
        this.attributeInt = new int[n3][];
        this.attributeIntOffset = new int[n3];
        this.attributeIntLength = new int[n3];
        this.attributeLong = new long[n3][];
        this.attributeLongOffset = new int[n3];
        this.attributeLongLength = new int[n3];
        this.attributeShort = new short[n3][];
        this.attributeShortOffset = new int[n3];
        this.attributeShortLength = new int[n3];
        this.attributeString = new String[n3][];
        this.attributeStringOffset = new int[n3];
        this.attributeStringLength = new int[n3];
        this.attributeTypes = new int[n3];
        this.clearAttributes();
    }

    private void clearAttributes() {
        this.hasAttributes = false;
        for (int i2 = 0; i2 < this.attributeTypes.length; ++i2) {
            this.attributeTypes[i2] = -1;
        }
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void openDoc() throws IOException {
        this.openDoc("BinaryAIDA/1.0", "UTF-8", false);
    }

    public void openDoc(String string, String string2, boolean bl) throws IOException {
        this.dtd = null;
        this.writtenHeader = false;
        this.version = string;
        this.encoding = string2;
        this.standalone = bl;
    }

    private void writeHeader() throws IOException {
        if (this.writtenHeader) {
            return;
        }
        if (this.dtd == null) {
            throw new IOException("DTD is missing");
        }
        this.writeByte(3);
        this.writeByte(0);
        this.writeMultiByteInt(0L);
        this.writeMultiByteInt(106L);
        int n2 = WBXMLParser.stringUTFLength(this.dtd) + 2 + 1;
        this.writeMultiByteInt(n2 += WBXMLParser.stringUTFLength(this.version) + 2 + 1);
        this.writeString(this.dtd);
        this.writeString(this.version);
        this.writtenHeader = true;
    }

    public void closeDoc() throws IOException {
    }

    public void referToDTD(String string, String string2, String string3) {
    }

    public void referToDTD(String string, String string2) {
        this.dtd = string + " " + string2;
    }

    public void openTag(int n2) throws IOException {
        this.writeTag(n2, true);
    }

    public void closeTag() throws IOException {
        this.writeByte(1);
    }

    public void printTag(int n2) throws IOException {
        this.writeTag(n2, false);
    }

    public void print(String string) throws IOException {
        this.writeByte(3);
        this.writeString(string);
    }

    public void printComment(String string) throws IOException {
    }

    private void writeTag(int n2, boolean bl) throws IOException {
        int n3;
        if (!this.writtenHeader) {
            this.writeHeader();
        }
        if ((n3 = n2 / 59) != this.tagPage) {
            this.writeByte(0);
            this.writeByte(n3);
            this.tagPage = n3;
        }
        this.writeByte((n2 %= 59) + 5 | (bl ? 64 : 0) | (this.hasAttributes ? 128 : 0));
        if (this.hasAttributes) {
            block11: for (int i2 = 0; i2 < this.attributeTypes.length; ++i2) {
                if (this.attributeTypes[i2] < 0) continue;
                this.writeAttribute(i2);
                switch (this.attributeTypes[i2]) {
                    case 0: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeBooleanLength[i2] * 1 + 1);
                        this.writeByte(0);
                        for (n4 = 0; n4 < this.attributeBooleanLength[i2]; ++n4) {
                            this.writeByte(this.attributeBoolean[i2][n4 + this.attributeBooleanOffset[i2]] ? 1 : 0);
                        }
                        continue block11;
                    }
                    case 1: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeByteLength[i2] * 1 + 1);
                        this.writeByte(1);
                        for (n4 = 0; n4 < this.attributeByteLength[i2]; ++n4) {
                            this.writeByte(this.attributeByte[i2][n4 + this.attributeByteOffset[i2]]);
                        }
                        continue block11;
                    }
                    case 2: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeCharLength[i2] * 2 + 1);
                        this.writeByte(2);
                        for (n4 = 0; n4 < this.attributeCharLength[i2]; ++n4) {
                            this.os.writeChar(this.attributeChar[i2][n4 + this.attributeCharOffset[i2]]);
                        }
                        continue block11;
                    }
                    case 3: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeDoubleLength[i2] * 8 + 1);
                        this.writeByte(3);
                        for (n4 = 0; n4 < this.attributeDoubleLength[i2]; ++n4) {
                            this.os.writeDouble(this.attributeDouble[i2][n4 + this.attributeDoubleOffset[i2]]);
                        }
                        continue block11;
                    }
                    case 4: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeFloatLength[i2] * 4 + 1);
                        this.writeByte(4);
                        for (n4 = 0; n4 < this.attributeFloatLength[i2]; ++n4) {
                            this.os.writeFloat(this.attributeFloat[i2][n4 + this.attributeFloatOffset[i2]]);
                        }
                        continue block11;
                    }
                    case 5: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeIntLength[i2] * 4 + 1);
                        this.writeByte(5);
                        for (n4 = 0; n4 < this.attributeIntLength[i2]; ++n4) {
                            this.os.writeInt(this.attributeInt[i2][n4 + this.attributeIntOffset[i2]]);
                        }
                        continue block11;
                    }
                    case 6: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeLongLength[i2] * 8 + 1);
                        this.writeByte(6);
                        for (n4 = 0; n4 < this.attributeLongLength[i2]; ++n4) {
                            this.os.writeLong(this.attributeLong[i2][n4 + this.attributeLongOffset[i2]]);
                        }
                        continue block11;
                    }
                    case 7: {
                        int n4;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeShortLength[i2] * 2 + 1);
                        this.writeByte(7);
                        for (n4 = 0; n4 < this.attributeShortLength[i2]; ++n4) {
                            this.os.writeShort(this.attributeShort[i2][n4 + this.attributeShortOffset[i2]]);
                        }
                        continue block11;
                    }
                    case 8: {
                        int n5;
                        int n4 = 0;
                        for (n5 = 0; n5 < this.attributeStringLength[i2]; ++n5) {
                            n4 += WBXMLParser.stringUTFLength(this.attributeString[i2][n5 + this.attributeStringOffset[i2]]) + 2 + 1;
                        }
                        this.writeByte(195);
                        this.writeMultiByteInt(n4 + 1);
                        this.writeByte(8);
                        for (n5 = 0; n5 < this.attributeStringLength[i2]; ++n5) {
                            this.writeString(this.attributeString[i2][n5 + this.attributeStringOffset[i2]]);
                        }
                        continue block11;
                    }
                }
            }
            this.writeByte(1);
            this.clearAttributes();
        }
    }

    private void writeAttribute(int n2) throws IOException {
        int n3 = n2 / 59;
        n2 %= 59;
        if (n3 != this.attributePage) {
            this.writeByte(0);
            this.writeByte(n3);
            this.attributePage = n3;
        }
        this.writeByte(n2 + 5);
    }

    public void setAttribute(int n2, String string) {
        this.setAttribute(n2, new String[]{string}, 0, 1);
    }

    public void setAttribute(int n2, String[] stringArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeString[n2] = stringArray;
        this.attributeStringOffset[n2] = n3;
        this.attributeStringLength[n2] = n4;
        this.attributeTypes[n2] = 8;
    }

    public void setAttribute(int n2, byte by) {
        this.setAttribute(n2, new byte[]{by}, 0, 1);
    }

    public void setAttribute(int n2, byte[] byArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeByte[n2] = byArray;
        this.attributeByteOffset[n2] = n3;
        this.attributeByteLength[n2] = n4;
        this.attributeTypes[n2] = 1;
    }

    public void setAttribute(int n2, long l2) {
        this.setAttribute(n2, new long[]{l2}, 0, 1);
    }

    public void setAttribute(int n2, long[] lArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeLong[n2] = lArray;
        this.attributeLongOffset[n2] = n3;
        this.attributeLongLength[n2] = n4;
        this.attributeTypes[n2] = 6;
    }

    public void setAttribute(int n2, int n3) {
        this.setAttribute(n2, new int[]{n3}, 0, 1);
    }

    public void setAttribute(int n2, int[] nArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeInt[n2] = nArray;
        this.attributeIntOffset[n2] = n3;
        this.attributeIntLength[n2] = n4;
        this.attributeTypes[n2] = 5;
    }

    public void setAttribute(int n2, boolean bl) {
        this.setAttribute(n2, new boolean[]{bl}, 0, 1);
    }

    public void setAttribute(int n2, boolean[] blArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeBoolean[n2] = blArray;
        this.attributeBooleanOffset[n2] = n3;
        this.attributeBooleanLength[n2] = n4;
        this.attributeTypes[n2] = 0;
    }

    public void setAttribute(int n2, float f2) {
        this.setAttribute(n2, new float[]{f2}, 0, 1);
    }

    public void setAttribute(int n2, float[] fArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeFloat[n2] = fArray;
        this.attributeFloatOffset[n2] = n3;
        this.attributeFloatLength[n2] = n4;
        this.attributeTypes[n2] = 4;
    }

    public void setAttribute(int n2, double d2) {
        this.setAttribute(n2, new double[]{d2}, 0, 1);
    }

    public void setAttribute(int n2, double[] dArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeDouble[n2] = dArray;
        this.attributeDoubleOffset[n2] = n3;
        this.attributeDoubleLength[n2] = n4;
        this.attributeTypes[n2] = 3;
    }

    public void setAttribute(int n2, Color color) {
        this.setAttribute(n2, new Color[]{color}, 0, 1);
    }

    public void setAttribute(int n2, Color[] colorArray, int n3, int n4) {
    }

    public void setAttribute(int n2, char c2) {
        this.setAttribute(n2, new char[]{c2}, 0, 1);
    }

    public void setAttribute(int n2, char[] cArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeChar[n2] = cArray;
        this.attributeCharOffset[n2] = n3;
        this.attributeCharLength[n2] = n4;
        this.attributeTypes[n2] = 2;
    }

    public void setAttribute(int n2, short s2) {
        this.setAttribute(n2, new short[]{s2}, 0, 1);
    }

    public void setAttribute(int n2, short[] sArray, int n3, int n4) {
        this.hasAttributes = true;
        this.attributeShort[n2] = sArray;
        this.attributeShortOffset[n2] = n3;
        this.attributeShortLength[n2] = n4;
        this.attributeTypes[n2] = 7;
    }

    private void writeMultiByteInt(long l2) throws IOException {
        int[] nArray = new int[5];
        int n2 = 0;
        do {
            nArray[n2++] = (int)(l2 & 0x7FL);
        } while ((l2 >>= 7) != 0L);
        while (n2 > 1) {
            this.writeByte(nArray[--n2] | 0x80);
        }
        this.writeByte(nArray[0]);
    }

    private void writeByte(int n2) throws IOException {
        this.os.writeByte(n2);
    }

    private void writeString(String string) throws IOException {
        this.os.writeUTF(string);
        this.os.writeByte(0);
    }
}

