/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.wbxml;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.freehep.wbxml.Attributes;
import org.freehep.wbxml.AttributesImpl;
import org.freehep.wbxml.ContentHandler;
import org.freehep.wbxml.DefaultExtensionHandler;
import org.freehep.wbxml.EntityResolver;
import org.freehep.wbxml.ExtensionHandler;
import org.freehep.wbxml.MutableAttributes;
import org.freehep.wbxml.WBXML;
import org.xml.sax.SAXException;

public class WBXMLParser
implements WBXML {
    private DataInputStream in;
    private ContentHandler contentHandler;
    private ExtensionHandler extensionHandler;
    private Map stringTable;
    private int version;
    private int publicIdentifierId;
    private int charSet;
    private int tagPage;
    private int attributePage;
    private Stack stack = new Stack();
    private EntityResolver resolver;

    public WBXMLParser(ContentHandler contentHandler) {
        this(contentHandler, new DefaultExtensionHandler());
    }

    public WBXMLParser(ContentHandler contentHandler, ExtensionHandler extensionHandler) {
        this.contentHandler = contentHandler;
        this.extensionHandler = extensionHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public int getCharSet() {
        return this.charSet;
    }

    public int getVersion() {
        return this.version;
    }

    public void parse(InputStream inputStream) throws SAXException, IOException {
        int n2;
        String[] stringArray;
        int n3;
        this.in = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        char[] cArray = new char[1];
        this.tagPage = 0;
        this.attributePage = 0;
        this.version = this.readByte();
        this.publicIdentifierId = this.readInt();
        int n4 = 0;
        if (this.publicIdentifierId == 0) {
            n4 = this.readInt();
        }
        this.charSet = this.readInt();
        this.stringTable = new HashMap();
        int n5 = this.readInt();
        for (int i2 = 0; i2 < n5; i2 += n3 + 2 + 1) {
            stringArray = this.in.readUTF();
            n3 = WBXMLParser.stringUTFLength((String)stringArray);
            this.stringTable.put(new Integer(i2), stringArray);
            inputStream.read();
        }
        this.contentHandler.startDocument();
        if (this.publicIdentifierId == 0) {
            stringArray = ((String)this.stringTable.get(new Integer(n4))).split(" ", 2);
            if (this.resolver != null) {
                this.resolver.resolveEntity(stringArray[0], null, stringArray[1]);
            }
        }
        block10: while ((n2 = inputStream.read()) != -1) {
            switch (n2) {
                case 0: {
                    this.tagPage = this.readByte();
                    continue block10;
                }
                case 1: {
                    this.contentHandler.endElement((Integer)this.stack.pop());
                    continue block10;
                }
                case 2: {
                    cArray[0] = (char)this.readInt();
                    this.contentHandler.characters(cArray, 0, 1);
                    continue block10;
                }
                case 3: {
                    String string = this.readStrI();
                    this.contentHandler.characters(string.toCharArray(), 0, string.length());
                    continue block10;
                }
                case 64: 
                case 65: 
                case 66: 
                case 128: 
                case 129: 
                case 130: 
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    int n6 = (Integer)this.stack.peek();
                    this.handleExtensions(n2, n6, -1, null, null);
                    continue block10;
                }
                case 67: {
                    throw new SAXException("PI Not Supported");
                }
                case 131: {
                    String string = this.readStrT();
                    this.contentHandler.characters(string.toCharArray(), 0, string.length());
                    continue block10;
                }
            }
            this.readElement(n2);
        }
        if (this.stack.size() != 0) {
            throw new SAXException("unclosed elements: " + this.stack);
        }
        this.contentHandler.endDocument();
    }

    private void handleExtensions(int n2, int n3, int n4, MutableAttributes mutableAttributes, List list) throws SAXException, IOException {
        switch (n2) {
            case 64: 
            case 65: 
            case 66: {
                this.extensionHandler.extI(n2 - 64, this.readStrI(), n3, n4, mutableAttributes, list);
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                this.extensionHandler.extT(n2 - 128, this.readInt(), n3, n4, mutableAttributes, list);
                break;
            }
            case 192: 
            case 193: 
            case 194: {
                this.extensionHandler.ext(n2 - 192, n3, n4, mutableAttributes, list);
                break;
            }
            case 195: {
                int n5 = this.readInt();
                this.extensionHandler.opaque(n5, this.in, n3, n4, mutableAttributes, list);
            }
        }
    }

    private Attributes readAttr(int n2) throws SAXException, IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n3 = this.readByte();
        int n4 = -1;
        while (n3 != 1) {
            while (n3 == 0) {
                this.attributePage = this.readByte();
                n3 = this.readByte();
            }
            n4 = this.getAttributeId(n3);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            n3 = this.readByte();
            while (n3 > 128 || n3 == 0 || n3 == 2 || n3 == 3 || n3 == 131 || n3 >= 64 && n3 <= 66 || n3 >= 128 && n3 <= 130) {
                switch (n3) {
                    case 0: {
                        this.attributePage = this.readByte();
                        break;
                    }
                    case 2: {
                        arrayList.add(new Character((char)this.readInt()));
                        break;
                    }
                    case 3: {
                        arrayList.add(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        this.handleExtensions(n3, n2, n4, attributesImpl, arrayList);
                        break;
                    }
                    case 131: {
                        arrayList.add(this.readStrT());
                        break;
                    }
                    default: {
                        arrayList.add(new Integer(this.getAttributeId(n3)));
                    }
                }
                n3 = this.readByte();
            }
            switch (arrayList.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Object e2 = arrayList.get(0);
                    if (e2 instanceof Integer) {
                        attributesImpl.set(n4, (Integer)e2);
                        break;
                    }
                    if (e2 instanceof Character) {
                        attributesImpl.set(n4, ((Character)e2).charValue());
                        break;
                    }
                    if (e2 instanceof String) {
                        attributesImpl.set(n4, (String)e2);
                        break;
                    }
                    throw new IOException(this.getClass() + ": Type " + e2.getClass() + " not properly handled.");
                }
                default: {
                    attributesImpl.set(n4, arrayList);
                }
            }
            n4 = -1;
        }
        return attributesImpl;
    }

    private int getTagId(int n2) {
        return (n2 & 0x3F) + this.tagPage * 59 - 5;
    }

    private int getAttributeId(int n2) {
        return (n2 & 0x3F) + this.attributePage * 59 - 5;
    }

    private void readElement(int n2) throws IOException, SAXException {
        boolean bl;
        int n3 = this.getTagId(n2 & 0x3F);
        if ((n2 & 0x40) != 0) {
            this.stack.add(new Integer(n3));
            bl = false;
        } else {
            bl = true;
        }
        this.contentHandler.startElement(n3, (n2 & 0x80) != 0 ? this.readAttr(n3) : new AttributesImpl(), bl);
    }

    protected int readByte() throws IOException, SAXException {
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new SAXException("Unexpected EOF");
        }
        return n2;
    }

    protected int readInt() throws SAXException, IOException {
        int n2;
        int n3 = 0;
        do {
            n2 = this.readByte();
            n3 = n3 << 7 | n2 & 0x7F;
        } while ((n2 & 0x80) != 0);
        return n3;
    }

    protected String readStrI() throws IOException, SAXException {
        String string = this.in.readUTF();
        this.in.read();
        return string;
    }

    protected String readStrT() throws IOException, SAXException {
        Integer n2 = new Integer(this.readInt());
        return (String)this.stringTable.get(n2);
    }

    public static int stringUTFLength(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) < '\u0080') {
                ++n2;
                continue;
            }
            if (string.charAt(i2) < '\u0800') {
                n2 += 2;
                continue;
            }
            if (string.charAt(i2) < '\u10000') {
                n2 += 3;
                continue;
            }
            n2 += 4;
        }
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Usage: WBXMLParser filename");
            System.exit(1);
        }
        ContentHandler contentHandler = new ContentHandler(){

            public void characters(char[] cArray, int n2, int n3) throws SAXException {
                System.err.print("'" + String.valueOf(cArray) + "'");
            }

            public void endDocument() throws SAXException {
                System.err.println("END DOCUMENT");
            }

            public void endElement(int n2) throws SAXException {
                System.err.println("</" + n2 + ">");
            }

            public void startDocument() throws SAXException {
                System.err.println("START DOCUMENT");
            }

            public void startElement(int n2, Attributes attributes, boolean bl) throws SAXException {
                System.err.println("<" + n2);
                System.err.println(attributes.getTags().length);
                if (bl) {
                    System.err.print("/");
                }
                System.err.println(">");
            }
        };
        WBXMLParser wBXMLParser = new WBXMLParser(contentHandler);
        wBXMLParser.parse(new FileInputStream(stringArray[0]));
    }
}

