/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.freehep.util.io.BitOutputStream;

public class ByteOrderOutputStream
extends BitOutputStream
implements DataOutput {
    protected boolean little;
    protected int written;

    public ByteOrderOutputStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public ByteOrderOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.little = bl;
        this.written = 0;
    }

    public int size() throws IOException {
        return this.written;
    }

    public synchronized void write(int n2) throws IOException {
        super.write(n2);
        ++this.written;
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeChar(int n2) throws IOException {
        if (this.little) {
            this.write(n2 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
        } else {
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 & 0xFF);
        }
    }

    public void writeByte(int n2) throws IOException {
        this.byteAlign();
        this.write(n2);
    }

    public void writeByte(byte[] byArray) throws IOException {
        this.byteAlign();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.write(byArray[i2]);
        }
    }

    public void writeUnsignedByte(int n2) throws IOException {
        this.byteAlign();
        this.write(n2);
    }

    public void writeUnsignedByte(int[] nArray) throws IOException {
        this.byteAlign();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.write(nArray[i2]);
        }
    }

    public void writeShort(int n2) throws IOException {
        this.byteAlign();
        if (this.little) {
            this.write(n2 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
        } else {
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 & 0xFF);
        }
    }

    public void writeShort(short[] sArray) throws IOException {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            this.writeShort(sArray[i2]);
        }
    }

    public void writeUnsignedShort(int n2) throws IOException {
        this.byteAlign();
        if (this.little) {
            this.write(n2 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
        } else {
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 & 0xFF);
        }
    }

    public void writeUnsignedShort(int[] nArray) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.writeUnsignedShort(nArray[i2]);
        }
    }

    public void writeInt(int n2) throws IOException {
        if (this.little) {
            this.write(n2 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 >>> 16 & 0xFF);
            this.write(n2 >>> 24 & 0xFF);
        } else {
            this.write(n2 >>> 24 & 0xFF);
            this.write(n2 >>> 16 & 0xFF);
            this.write(n2 >>> 8 & 0xFF);
            this.write(n2 & 0xFF);
        }
    }

    public void writeInt(int[] nArray) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.writeInt(nArray[i2]);
        }
    }

    public void writeUnsignedInt(long l2) throws IOException {
        if (this.little) {
            this.write((int)(l2 & 0xFFL));
            this.write((int)(l2 >>> 8 & 0xFFL));
            this.write((int)(l2 >>> 16 & 0xFFL));
            this.write((int)(l2 >>> 24 & 0xFFL));
        } else {
            this.write((int)(l2 >>> 24 & 0xFFL));
            this.write((int)(l2 >>> 16 & 0xFFL));
            this.write((int)(l2 >>> 8 & 0xFFL));
            this.write((int)(l2 & 0xFFL));
        }
    }

    public void writeUnsignedInt(long[] lArray) throws IOException {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.writeUnsignedInt(lArray[i2]);
        }
    }

    public void writeLong(long l2) throws IOException {
        if (this.little) {
            this.write((int)(l2 & 0xFFL));
            this.write((int)(l2 >>> 8 & 0xFFL));
            this.write((int)(l2 >>> 16 & 0xFFL));
            this.write((int)(l2 >>> 24 & 0xFFL));
            this.write((int)(l2 >>> 32 & 0xFFL));
            this.write((int)(l2 >>> 40 & 0xFFL));
            this.write((int)(l2 >>> 48 & 0xFFL));
            this.write((int)(l2 >>> 56 & 0xFFL));
        } else {
            this.write((int)(l2 >>> 56 & 0xFFL));
            this.write((int)(l2 >>> 48 & 0xFFL));
            this.write((int)(l2 >>> 40 & 0xFFL));
            this.write((int)(l2 >>> 32 & 0xFFL));
            this.write((int)(l2 >>> 24 & 0xFFL));
            this.write((int)(l2 >>> 16 & 0xFFL));
            this.write((int)(l2 >>> 8 & 0xFFL));
            this.write((int)(l2 & 0xFFL));
        }
    }

    public void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeBytes(String string) throws IOException {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.writeByte(string.charAt(i2));
        }
    }

    public void writeChars(String string) throws IOException {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.writeChar(string.charAt(i2));
        }
    }

    public void writeString(String string) throws IOException {
        this.writeUTF(string);
    }

    public void writeUTF(String string) throws IOException {
        ByteOrderOutputStream.writeUTF(string, this);
    }

    public void writeAsciiZString(String string) throws IOException {
        this.writeBytes(string);
        this.writeByte(0);
    }

    public static void writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c2;
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2];
        int n4 = 0;
        string.getChars(0, n2, cArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = cArray[i2];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n3;
                continue;
            }
            if (c2 > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n3 + 2];
        byArray[n4++] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n4++] = (byte)(n3 >>> 0 & 0xFF);
        for (int i3 = 0; i3 < n2; ++i3) {
            c2 = cArray[i3];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n4++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
        }
        dataOutput.write(byArray);
    }
}

