/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.swing.ErrorDialog;
import org.freehep.swing.layout.TableLayout;
import org.freehep.util.export.ExportFileType;
import org.freehep.util.export.ExportFileTypeGroups;

public class ExportDialog
extends JOptionPane {
    private static final String rootKey = ExportDialog.class.getName();
    private static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    private static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";
    private String creator;
    private JButton browse = new JButton("Browse...");
    private JButton advanced = new JButton("Options...");
    private JTextField file = new JTextField(40);
    private JComboBox type;
    private Component component;
    private boolean trusted = true;
    private Vector list = new Vector();
    private Properties props = new Properties();
    private String baseDir = null;

    public void setUserProperties(Properties properties) {
        this.props = properties;
    }

    public void addExportFileType(ExportFileType exportFileType) {
        this.list.addElement(exportFileType);
    }

    public void addAllExportFileTypes() {
        ExportFileTypeGroups exportFileTypeGroups = new ExportFileTypeGroups(ExportFileType.getExportFileTypes());
        Iterator iterator = exportFileTypeGroups.getGroupNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = exportFileTypeGroups.getExportFileTypes(string);
            if (list.size() <= 0) continue;
            this.list.add(new JLabel(exportFileTypeGroups.getLabel(string), 0));
            Collections.sort(list);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                this.addExportFileType((ExportFileType)iterator2.next());
            }
        }
    }

    public ExportDialog() {
        this(null);
    }

    public ExportDialog(String string) {
        this(string, true);
    }

    public ExportDialog(String string, boolean bl) {
        super(null, -1, 2);
        this.creator = string;
        try {
            this.baseDir = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            this.trusted = false;
        }
        ButtonListener buttonListener = new ButtonListener();
        JPanel jPanel = new JPanel((LayoutManager)new TableLayout());
        if (this.trusted) {
            jPanel.add("* * [5 5 5 5] w", this.file);
            jPanel.add("* * * 1 [5 5 5 5] wh", this.browse);
        }
        this.type = new JComboBox(this.list);
        this.type.setMaximumRowCount(16);
        jPanel.add("* * 1 1 [5 5 5 5] w", this.type);
        jPanel.add("* * * 1 [5 5 5 5] wh", this.advanced);
        this.browse.addActionListener(buttonListener);
        this.advanced.addActionListener(buttonListener);
        this.type.setRenderer(new SaveAsRenderer());
        this.type.addActionListener(buttonListener);
        this.setMessage(jPanel);
        if (bl) {
            this.addAllExportFileTypes();
        }
    }

    public void showExportDialog(Component component, String string, Component component2, Dimension dimension, String string2) {
        this.props.setProperty("size-w", String.valueOf(dimension.width));
        this.props.setProperty("size-h", String.valueOf(dimension.height));
        this.showExportDialog(component, string, component2, string2);
    }

    public void showExportDialog(Component component, String string, Component component2, String string2) {
        Object object;
        String string3;
        this.component = component2;
        if (this.list.size() > 0) {
            this.type.setSelectedIndex(1);
        }
        if ((string3 = this.props.getProperty(SAVE_AS_TYPE)) != null) {
            for (int i2 = 0; i2 < this.list.size(); ++i2) {
                ExportFileType exportFileType;
                object = this.list.elementAt(i2);
                if (!(object instanceof ExportFileType) || !(exportFileType = (ExportFileType)object).getFileFilter().getDescription().equals(string3)) continue;
                this.type.setSelectedItem(exportFileType);
                break;
            }
        }
        this.advanced.setEnabled(this.currentType() != null && this.currentType().hasOptionPanel());
        if (this.trusted) {
            String string4 = this.props.getProperty(SAVE_AS_FILE);
            if (string4 != null) {
                this.baseDir = new File(string4).getParent();
                string2 = string4;
            } else {
                string2 = this.baseDir + File.separator + string2;
            }
            object = new File(string2);
            if (this.currentType() != null) {
                object = this.currentType().adjustFilename((File)object, this.currentType().getFileExtension((File)object), this.props);
            }
            this.file.setText(((File)object).toString());
        } else {
            this.file.setEnabled(false);
            this.browse.setEnabled(false);
        }
        JDialog jDialog = this.createDialog(component, string);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    private ExportFileType currentType() {
        return (ExportFileType)this.type.getSelectedItem();
    }

    protected String selectFile() {
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.file.getText();
        if (string != null) {
            jFileChooser.setSelectedFile(new File(string));
        }
        jFileChooser.setFileFilter(this.currentType().getFileFilter());
        if (jFileChooser.showDialog(this, "Select") == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected boolean writeFile(Component component, ExportFileType exportFileType) throws IOException {
        int n2;
        File file = new File(this.file.getText());
        if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, "Replace existing file?")) != 0) {
            return false;
        }
        exportFileType.exportToFile(file, component, (Component)this, this.props, this.creator);
        this.props.put(SAVE_AS_FILE, this.file.getText());
        this.props.put(SAVE_AS_TYPE, this.currentType().getFileFilter().getDescription());
        return true;
    }

    public void setValue(Object object) {
        if (object instanceof Integer && (Integer)object == 0) {
            try {
                if (!this.writeFile(this.component, this.currentType())) {
                    return;
                }
            }
            catch (Throwable throwable) {
                ErrorDialog.showErrorDialog((Component)this, (Object)"Error writing graphics file", (Throwable)throwable);
                return;
            }
        }
        super.setValue(object);
    }

    private class ButtonListener
    implements ActionListener {
        private ExportFileType previousType = null;

        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ExportDialog.this.browse) {
                String string = ExportDialog.this.selectFile();
                if (string != null) {
                    if (ExportDialog.this.currentType() != null) {
                        File file = new File(string);
                        ExportDialog.this.currentType().adjustFilename(file, ExportDialog.this.currentType().getFileExtension(file), ExportDialog.this.props);
                        ExportDialog.this.file.setText(file.getPath());
                    } else {
                        ExportDialog.this.file.setText(string);
                    }
                }
            } else if (object == ExportDialog.this.advanced) {
                JPanel jPanel;
                int n2;
                if (ExportDialog.this.currentType() != null && (n2 = JOptionPane.showConfirmDialog(ExportDialog.this, jPanel = ExportDialog.this.currentType().createOptionPanel(ExportDialog.this.props), "Options for " + ExportDialog.this.currentType().getDescription(), 2, -1)) == 0) {
                    ExportDialog.this.currentType().applyChangedOptions(jPanel, ExportDialog.this.props);
                    File file = new File(ExportDialog.this.file.getText());
                    File file2 = ExportDialog.this.currentType().adjustFilename(file, ExportDialog.this.currentType().getFileExtension(file), ExportDialog.this.props);
                    if (!file.equals(file2) && ExportDialog.this.file.isEnabled()) {
                        ExportDialog.this.file.setText(file2.toString());
                    }
                }
            } else if (object == ExportDialog.this.type) {
                if (ExportDialog.this.type.getSelectedItem() instanceof ExportFileType) {
                    if (this.previousType == null) {
                        this.previousType = ExportDialog.this.currentType();
                    }
                    ExportDialog.this.advanced.setEnabled(ExportDialog.this.currentType().hasOptionPanel());
                    File file = new File(ExportDialog.this.file.getText());
                    File file3 = ExportDialog.this.currentType().adjustFilename(file, this.previousType.getFileExtension(file), ExportDialog.this.props);
                    if (!file.equals(file3) && ExportDialog.this.file.isEnabled()) {
                        ExportDialog.this.file.setText(file3.toString());
                    }
                    this.previousType = ExportDialog.this.currentType();
                } else {
                    ExportDialog.this.type.setSelectedItem(this.previousType);
                }
            }
        }
    }

    private static class SaveAsRenderer
    extends DefaultListCellRenderer {
        private SaveAsRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
            if (object instanceof ExportFileType) {
                this.setText(((ExportFileType)object).getFileFilter().getDescription());
            } else if (object instanceof JLabel) {
                return (Component)object;
            }
            return this;
        }
    }
}

