/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.svg.SVGFontTable;
import org.freehep.util.UserProperties;
import org.freehep.util.Value;
import org.freehep.util.io.Base64OutputStream;
import org.freehep.util.io.WriterOutputStream;
import org.freehep.xml.util.XMLWriter;

public class SVGGraphics2D
extends AbstractVectorGraphicsIO {
    public static final String VERSION_1_1 = "Version 1.1 (REC-SVG11-20030114)";
    private static final String rootKey = SVGGraphics2D.class.getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String VERSION = rootKey + ".Version";
    public static final String COMPRESS = rootKey + ".Binary";
    public static final String STYLABLE = rootKey + ".Stylable";
    public static final String IMAGE_SIZE = rootKey + "." + "ImageSize";
    public static final String EXPORT_IMAGES = rootKey + ".ExportImages";
    public static final String EXPORT_SUFFIX = rootKey + ".ExportSuffix";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    public static final String FOR = rootKey + "." + "For";
    public static final String TITLE = rootKey + "." + "Title";
    private BasicStroke defaultStroke = new BasicStroke();
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    private SVGFontTable fontTable;
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 12753 $";
    private String filename;
    private int bbx;
    private int bby;
    private int bbw;
    private int bbh;
    private OutputStream ros;
    private PrintWriter os;
    Hashtable gradients = new Hashtable();
    Hashtable textures = new Hashtable();
    private Stack closeTags = new Stack();
    private int imageNumber = 0;
    private Value clipNumber;
    private int width;
    private int height;
    private static DecimalFormat scientific;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties properties) {
        defaultProperties.setProperties(properties);
    }

    public SVGGraphics2D(File file, Dimension dimension) throws IOException {
        this((OutputStream)new FileOutputStream(file), dimension);
        this.filename = file.getPath();
    }

    public SVGGraphics2D(File file, Component component) throws IOException {
        this((OutputStream)new FileOutputStream(file), component);
        this.filename = file.getPath();
    }

    public SVGGraphics2D(OutputStream outputStream, Dimension dimension) {
        super(dimension, false);
        this.init(outputStream);
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public SVGGraphics2D(OutputStream outputStream, Component component) {
        super(component, false);
        this.init(outputStream);
        this.width = this.getSize().width;
        this.height = this.getSize().height;
    }

    private void init(OutputStream outputStream) {
        this.ros = outputStream;
        this.initProperties(SVGGraphics2D.getDefaultProperties());
        this.filename = null;
        this.clipNumber = new Value().set(0);
    }

    protected SVGGraphics2D(SVGGraphics2D sVGGraphics2D, boolean bl) {
        super(sVGGraphics2D, bl);
        this.filename = sVGGraphics2D.filename;
        this.os = sVGGraphics2D.os;
        this.bbx = sVGGraphics2D.bbx;
        this.bby = sVGGraphics2D.bby;
        this.bbw = sVGGraphics2D.bbw;
        this.bbh = sVGGraphics2D.bbh;
        this.gradients = sVGGraphics2D.gradients;
        this.textures = sVGGraphics2D.textures;
        this.clipNumber = sVGGraphics2D.clipNumber;
        this.fontTable = sVGGraphics2D.fontTable;
    }

    public void setBoundingBox() {
        this.bbx = 0;
        this.bby = 0;
        Dimension dimension = this.getSize();
        this.bbw = dimension.width;
        this.bbh = dimension.height;
    }

    public void writeHeader() throws IOException {
        int n2;
        this.ros = new BufferedOutputStream(this.ros);
        if (this.isProperty(COMPRESS)) {
            this.ros = new GZIPOutputStream(this.ros);
        }
        this.os = new PrintWriter(this.ros, true);
        this.fontTable = new SVGFontTable();
        this.setBoundingBox();
        this.imageNumber = 0;
        this.os.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        if (this.getProperty(VERSION).equals(VERSION_1_1)) {
            // empty if block
        }
        this.os.println();
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = this.getPropertyDimension(IMAGE_SIZE);
        int n5 = dimension.width;
        if (n5 <= 0) {
            n5 = this.width;
        }
        if ((n2 = dimension.height) <= 0) {
            n2 = this.height;
        }
        this.os.println("<svg ");
        if (this.getProperty(VERSION).equals(VERSION_1_1)) {
            this.os.println("     version=\"1.1\"");
            this.os.println("     baseProfile=\"full\"");
            this.os.println("     xmlns=\"http://www.w3.org/2000/svg\"");
            this.os.println("     xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
            this.os.println("     xmlns:ev=\"http://www.w3.org/2001/xml-events\"");
        }
        this.os.println("     x=\"" + n3 + "px\"");
        this.os.println("     y=\"" + n4 + "px\"");
        this.os.println("     width=\"" + n5 + "px\"");
        this.os.println("     height=\"" + n2 + "px\"");
        this.os.println("     viewBox=\"" + this.bbx + " " + this.bby + " " + this.bbw + " " + this.bbh + "\"");
        this.os.println("     >");
        this.closeTags.push("</svg> <!-- bounding box -->");
        this.os.print("<title>");
        this.os.print(XMLWriter.normalizeText(this.getProperty(TITLE)));
        this.os.println("</title>");
        String string = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            string = string + " " + version.substring(1, version.length() - 1);
        }
        this.os.print("<desc>");
        this.os.print("Creator: " + XMLWriter.normalizeText(this.getCreator()));
        this.os.print(" Producer: " + XMLWriter.normalizeText(string));
        this.os.print(" Source: " + XMLWriter.normalizeText(this.getProperty(FOR)));
        if (!this.isDeviceIndependent()) {
            this.os.print(" Date: " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        }
        this.os.println("</desc>");
        this.os.print("<g ");
        Properties properties = this.getStrokeProperties(this.defaultStroke, true);
        this.os.print(this.style(properties));
        this.os.println(">");
        this.closeTags.push("</g> <!-- default stroke -->");
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        if (this.isProperty(EMBED_FONTS)) {
            this.os.println("<defs>");
            this.os.println(this.fontTable.toString());
            this.os.println("</defs> <!-- font definitions -->");
        }
        this.writeGraphicsRestore();
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return new SVGGraphics2D(this, true);
    }

    public Graphics create(double d2, double d3, double d4, double d5) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(this, true);
        this.os.println("<svg x=\"" + SVGGraphics2D.fixedPrecision(d2) + "\" " + "y=\"" + SVGGraphics2D.fixedPrecision(d3) + "\" " + "width=\"" + SVGGraphics2D.fixedPrecision(d4) + "\" " + "height=\"" + SVGGraphics2D.fixedPrecision(d5) + "\" " + ">");
        sVGGraphics2D.closeTags.push("</svg> <!-- graphics context -->");
        this.os.print("<g ");
        Properties properties = this.getStrokeProperties(this.defaultStroke, true);
        this.os.print(this.style(properties));
        this.os.println(">");
        sVGGraphics2D.closeTags.push("</g> <!-- default stroke -->");
        return sVGGraphics2D;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
        while (!this.closeTags.empty()) {
            this.os.println(this.closeTags.pop());
        }
    }

    public void draw(Shape shape) {
        if (this.getStroke() instanceof BasicStroke) {
            PathIterator pathIterator = shape.getPathIterator(null);
            Properties properties = new Properties();
            if (this.getPaint() != null) {
                properties.put("stroke", this.hexColor(this.getPaint()));
                properties.put("stroke-opacity", SVGGraphics2D.fixedPrecision(this.alphaColor(this.getPaint())));
            }
            properties.put("fill", "none");
            properties.putAll((Map<?, ?>)this.getStrokeProperties(this.getStroke(), false));
            this.writePathIterator(pathIterator, properties);
        } else if (this.getStroke() != null) {
            this.fill(this.getStroke().createStrokedShape(shape));
        } else {
            this.fill(this.defaultStroke.createStrokedShape(shape));
        }
    }

    public void fill(Shape shape) {
        if (!(this.getPaint() instanceof Color) && !(this.getPaint() instanceof GradientPaint)) {
            this.fill(shape, this.getPaint());
        } else {
            PathIterator pathIterator = shape.getPathIterator(null);
            Properties properties = new Properties();
            if (pathIterator.getWindingRule() == 0) {
                properties.put("fill-rule", "evenodd");
            } else {
                properties.put("fill-rule", "nonzero");
            }
            if (this.getPaint() != null) {
                properties.put("fill", this.hexColor(this.getPaint()));
                properties.put("fill-opacity", SVGGraphics2D.fixedPrecision(this.alphaColor(this.getPaint())));
            }
            properties.put("stroke", "none");
            this.writePathIterator(pathIterator, properties);
        }
    }

    private void writePathIterator(PathIterator pathIterator, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<g ");
        stringBuffer.append(this.style(properties));
        stringBuffer.append(">\n  ");
        stringBuffer.append(this.getPath(pathIterator));
        stringBuffer.append("\n</g> <!-- drawing style -->");
        boolean bl = false;
        if (this.getClip() != null) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(pathIterator, true);
            Stroke stroke = this.getStroke() == null ? this.defaultStroke : this.getStroke();
            Rectangle rectangle = stroke.createStrokedShape(generalPath).getBounds();
            boolean bl2 = bl = this.getClip().intersects(rectangle) && !this.getClip().contains(rectangle);
        }
        if (bl) {
            this.os.println(this.getTransformedString(this.getTransform(), this.getClippedString(stringBuffer.toString())));
        } else {
            this.os.println(this.getTransformedString(this.getTransform(), stringBuffer.toString()));
        }
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage renderedImage, AffineTransform affineTransform, Color color) throws IOException {
        Object object;
        Object object2;
        byte[] byArray;
        String string;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<image x=\"0\" y=\"0\" width=\"");
        stringBuffer.append(renderedImage.getWidth());
        stringBuffer.append("\" height=\"");
        stringBuffer.append(renderedImage.getHeight());
        stringBuffer.append("\" xlink:href=\"");
        String string2 = this.getProperty(WRITE_IMAGES_AS);
        boolean bl2 = bl = renderedImage.getColorModel().hasAlpha() && color == null;
        if ("PNG".equalsIgnoreCase(string2) || bl) {
            string = "PNG";
            byArray = ImageGraphics2D.toByteArray(renderedImage, "PNG", null, null);
        } else if ("JPG".equalsIgnoreCase(string2)) {
            string = "JPG";
            byArray = ImageGraphics2D.toByteArray(renderedImage, "JPG", null, null);
        } else {
            object2 = ImageGraphics2D.toByteArray(renderedImage, "PNG", null, null);
            object = ImageGraphics2D.toByteArray(renderedImage, "JPG", null, null);
            if ((double)((byte[])object).length < 0.5 * (double)((byte[])object2).length) {
                string = "JPG";
                byArray = object;
            } else {
                string = "PNG";
                byArray = object2;
            }
        }
        if (this.isProperty(EXPORT_IMAGES)) {
            ++this.imageNumber;
            if (this.filename == null) {
                this.writeWarning("SVG: cannot write embedded images, since SVGGraphics2D");
                this.writeWarning("     was created from an OutputStream rather than a File.");
                return;
            }
            int n2 = this.filename.lastIndexOf(File.separatorChar);
            object = n2 < 0 ? "" : this.filename.substring(0, n2 + 1);
            String string3 = n2 < 0 ? this.filename : this.filename.substring(n2 + 1);
            string3 = string3 + "." + this.getProperty(EXPORT_SUFFIX) + "-" + this.imageNumber + "." + string;
            stringBuffer.append(string3);
            FileOutputStream fileOutputStream = new FileOutputStream((String)object + string3);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        } else {
            stringBuffer.append("data:image/");
            stringBuffer.append(string);
            stringBuffer.append(";base64,");
            object2 = new StringWriter();
            object = new Base64OutputStream(new WriterOutputStream((Writer)object2));
            object.write(byArray);
            object.finish();
            stringBuffer.append(((StringWriter)object2).toString());
        }
        stringBuffer.append("\"/>");
        this.os.println(this.getTransformedString(this.getTransform(), this.getClippedString(this.getTransformedString(affineTransform, stringBuffer.toString()))));
    }

    protected void writeString(String string, double d2, double d3) throws IOException {
        if (this.isProperty(EMBED_FONTS)) {
            this.fontTable.addGlyphs(string, this.getFont());
        }
        Properties properties = this.getFontProperties(this.getFont());
        if (this.getPaint() != null) {
            properties.put("fill", this.hexColor(this.getPaint()));
            properties.put("fill-opacity", SVGGraphics2D.fixedPrecision(this.alphaColor(this.getPaint())));
        } else {
            properties.put("fill", "none");
        }
        properties.put("stroke", "none");
        string = XMLWriter.normalizeText(string);
        if (string.startsWith(" ")) {
            string = "&#x00a0;" + string.substring(1);
        }
        this.os.println(this.getTransformedString(this.getTransform(), this.getClippedString(this.getTransformedString(new AffineTransform(1.0, 0.0, 0.0, 1.0, d2, d3), this.getTransformedString(this.getFont().getTransform(), "<text " + this.style(properties) + " x=\"0\" y=\"0\">" + string + "</text>")))));
    }

    private Properties getFontProperties(Font font) {
        Properties properties = new Properties();
        Hashtable hashtable = FontUtilities.getAttributes(font);
        SVGFontTable.normalize(hashtable);
        properties.put("font-family", hashtable.get(TextAttribute.FAMILY));
        if (TextAttribute.WEIGHT_BOLD.equals(hashtable.get(TextAttribute.WEIGHT))) {
            properties.put("font-weight", "bold");
        } else {
            properties.put("font-weight", "normal");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(hashtable.get(TextAttribute.POSTURE))) {
            properties.put("font-style", "italic");
        } else {
            properties.put("font-style", "normal");
        }
        Object v2 = hashtable.get(TextAttribute.UNDERLINE);
        if (v2 != null) {
            if (TextAttribute.UNDERLINE_LOW_DOTTED.equals(v2)) {
                properties.put("text-underline-style", "dotted");
            } else if (TextAttribute.UNDERLINE_LOW_DASHED.equals(v2)) {
                properties.put("text-underline-style", "dashed");
            } else if (TextAttribute.UNDERLINE_ON.equals(v2)) {
                properties.put("text-underline-style", "solid");
            }
            properties.put("text-decoration", "underline");
        }
        if (hashtable.get(TextAttribute.STRIKETHROUGH) != null) {
            if (v2 == null) {
                properties.put("text-decoration", "underline, line-through");
            } else {
                properties.put("text-decoration", "line-through");
            }
        }
        Float f2 = (Float)hashtable.get(TextAttribute.SIZE);
        properties.put("font-size", SVGGraphics2D.fixedPrecision(f2.floatValue()));
        return properties;
    }

    protected void writeTransform(AffineTransform affineTransform) throws IOException {
    }

    protected void writeSetTransform(AffineTransform affineTransform) throws IOException {
    }

    protected void writeClip(Shape shape) throws IOException {
    }

    protected void writeSetClip(Shape shape) throws IOException {
    }

    protected void writeWidth(float f2) throws IOException {
    }

    protected void writeCap(int n2) throws IOException {
    }

    protected void writeJoin(int n2) throws IOException {
    }

    protected void writeMiterLimit(float f2) throws IOException {
    }

    protected void writeDash(float[] fArray, float f2) throws IOException {
    }

    private Properties getStrokeProperties(Stroke stroke, boolean bl) {
        Properties properties = new Properties();
        if (!(stroke instanceof BasicStroke)) {
            return properties;
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        if (bl || basicStroke.getEndCap() != this.defaultStroke.getEndCap()) {
            switch (basicStroke.getEndCap()) {
                default: {
                    properties.put("stroke-linecap", "butt");
                    break;
                }
                case 1: {
                    properties.put("stroke-linecap", "round");
                    break;
                }
                case 2: {
                    properties.put("stroke-linecap", "square");
                }
            }
        }
        if (bl || !Arrays.equals(basicStroke.getDashArray(), this.defaultStroke.getDashArray())) {
            if (basicStroke.getDashArray() != null && basicStroke.getDashArray().length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < basicStroke.getDashArray().length; ++i2) {
                    float f2;
                    if (i2 > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(SVGGraphics2D.fixedPrecision((f2 = basicStroke.getDashArray()[i2]) > 0.0f ? (double)f2 : 0.1));
                }
                properties.put("stroke-dasharray", stringBuffer.toString());
            } else {
                properties.put("stroke-dasharray", "none");
            }
        }
        if (bl || basicStroke.getDashPhase() != this.defaultStroke.getDashPhase()) {
            properties.put("stroke-dashoffset", SVGGraphics2D.fixedPrecision(basicStroke.getDashPhase()));
        }
        if (bl || basicStroke.getMiterLimit() != this.defaultStroke.getMiterLimit()) {
            properties.put("stroke-miterlimit", SVGGraphics2D.fixedPrecision(basicStroke.getMiterLimit()));
        }
        if (bl || basicStroke.getLineJoin() != this.defaultStroke.getLineJoin()) {
            switch (basicStroke.getLineJoin()) {
                default: {
                    properties.put("stroke-linejoin", "miter");
                    break;
                }
                case 1: {
                    properties.put("stroke-linejoin", "round");
                    break;
                }
                case 2: {
                    properties.put("stroke-linejoin", "bevel");
                }
            }
        }
        if (bl || basicStroke.getLineWidth() != this.defaultStroke.getLineWidth()) {
            if (basicStroke.getLineWidth() == 0.0f) {
                properties.put("stroke-width", SVGGraphics2D.fixedPrecision(1.0E-6f));
            } else {
                properties.put("stroke-width", SVGGraphics2D.fixedPrecision(basicStroke.getLineWidth()));
            }
        }
        return properties;
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color color) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color color) throws IOException {
    }

    protected void writePaint(GradientPaint gradientPaint) throws IOException {
        Object object;
        if (this.gradients.get(gradientPaint) == null) {
            object = "gradient-" + this.gradients.size();
            this.gradients.put(gradientPaint, object);
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            this.os.println("<defs>");
            this.os.print("  <linearGradient id=\"" + (String)object + "\" ");
            this.os.print("x1=\"" + SVGGraphics2D.fixedPrecision(point2D.getX()) + "\" ");
            this.os.print("y1=\"" + SVGGraphics2D.fixedPrecision(point2D.getY()) + "\" ");
            this.os.print("x2=\"" + SVGGraphics2D.fixedPrecision(point2D2.getX()) + "\" ");
            this.os.print("y2=\"" + SVGGraphics2D.fixedPrecision(point2D2.getY()) + "\" ");
            this.os.print("gradientUnits=\"userSpaceOnUse\" ");
            this.os.print("spreadMethod=\"" + (gradientPaint.isCyclic() ? "reflect" : "pad") + "\" ");
            this.os.println(">");
            this.os.println("    <stop offset=\"0\" stop-color=\"" + this.hexColor(gradientPaint.getColor1()) + "\" " + "opacity-stop=\"" + this.alphaColor(gradientPaint.getColor1()) + "\" />");
            this.os.println("    <stop offset=\"1\" stop-color=\"" + this.hexColor(gradientPaint.getColor2()) + "\" " + "opacity-stop=\"" + this.alphaColor(gradientPaint.getColor2()) + "\" />");
            this.os.println("  </linearGradient>");
            this.os.println("</defs>");
        }
        object = new Properties();
        ((Properties)object).put("stroke", this.hexColor(this.getPaint()));
        this.os.print("<g ");
        this.os.print(this.style((Properties)object));
        this.os.println(">");
        this.closeTags.push("</g> <!-- color -->");
    }

    protected void writePaint(TexturePaint texturePaint) throws IOException {
    }

    protected void writePaint(Paint paint) throws IOException {
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public void writeComment(String string) throws IOException {
        this.os.println("<!-- " + string + " -->");
    }

    public String toString() {
        return "SVGGraphics2D";
    }

    private String getTransformedString(AffineTransform affineTransform, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (affineTransform != null && !affineTransform.isIdentity()) {
            stringBuffer.append("<g transform=\"matrix(");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(affineTransform.getScaleX()));
            stringBuffer.append(", ");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(affineTransform.getShearY()));
            stringBuffer.append(", ");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(affineTransform.getShearX()));
            stringBuffer.append(", ");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(affineTransform.getScaleY()));
            stringBuffer.append(", ");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(affineTransform.getTranslateX()));
            stringBuffer.append(", ");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(affineTransform.getTranslateY()));
            stringBuffer.append(")\">\n");
        }
        stringBuffer.append(string);
        if (affineTransform != null && !affineTransform.isIdentity()) {
            stringBuffer.append("\n</g> <!-- transform -->");
        }
        return stringBuffer.toString();
    }

    private String getClippedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isProperty(CLIP) && this.getClip() != null) {
            this.clipNumber.set(this.clipNumber.getInt() + 1);
            stringBuffer.append("<clipPath id=\"clip");
            stringBuffer.append(this.clipNumber.getInt());
            stringBuffer.append("\">\n  ");
            stringBuffer.append(this.getPath(this.getClip().getPathIterator(null)));
            stringBuffer.append("\n</clipPath>\n");
            stringBuffer.append("<g clip-path=\"url(#clip");
            stringBuffer.append(this.clipNumber.getInt());
            stringBuffer.append(")\">\n");
        }
        stringBuffer.append(string);
        if (this.isProperty(CLIP) && this.getClip() != null) {
            stringBuffer.append("\n</g> <!-- clip");
            stringBuffer.append(this.clipNumber.getInt());
            stringBuffer.append(" -->");
        }
        return stringBuffer.toString();
    }

    private float alphaColor(Paint paint) {
        if (paint instanceof Color) {
            return (float)((double)this.getPrintColor((Color)paint).getAlpha() / 255.0);
        }
        if (paint instanceof GradientPaint) {
            return 1.0f;
        }
        if (paint instanceof TexturePaint) {
            return 1.0f;
        }
        this.writeWarning(this.getClass() + ": alphaColor() not implemented for " + paint.getClass() + ".");
        return 1.0f;
    }

    private String hexColor(Paint paint) {
        if (paint instanceof Color) {
            return this.hexColor(this.getPrintColor((Color)paint));
        }
        if (paint instanceof GradientPaint) {
            return this.hexColor((GradientPaint)paint);
        }
        if (paint instanceof TexturePaint) {
            return this.hexColor((TexturePaint)paint);
        }
        this.writeWarning(this.getClass() + ": hexColor() not implemented for " + paint.getClass() + ".");
        return "#000000";
    }

    private String hexColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        string = string.length() != 2 ? "0" + string : string;
        String string2 = Integer.toHexString(color.getGreen());
        string2 = string2.length() != 2 ? "0" + string2 : string2;
        String string3 = Integer.toHexString(color.getBlue());
        string3 = string3.length() != 2 ? "0" + string3 : string3;
        return "#" + string + string2 + string3;
    }

    private String hexColor(GradientPaint gradientPaint) {
        return "url(#" + this.gradients.get(gradientPaint) + ")";
    }

    private String hexColor(TexturePaint texturePaint) {
        return "url(#" + this.textures.get(texturePaint) + ")";
    }

    protected static String getPathContent(PathIterator pathIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[6];
        stringBuffer.append("d=\"");
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    stringBuffer.append("M ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[0]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[1]));
                    break;
                }
                case 1: {
                    stringBuffer.append("L ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[0]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[1]));
                    break;
                }
                case 3: {
                    stringBuffer.append("C ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[0]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[1]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[2]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[3]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[4]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[5]));
                    break;
                }
                case 2: {
                    stringBuffer.append("Q ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[0]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[1]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[2]));
                    stringBuffer.append(" ");
                    stringBuffer.append(SVGGraphics2D.fixedPrecision(dArray[3]));
                    break;
                }
                case 4: {
                    stringBuffer.append("z");
                }
            }
            pathIterator.next();
            if (pathIterator.isDone()) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    protected String getPath(PathIterator pathIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<path ");
        stringBuffer.append(SVGGraphics2D.getPathContent(pathIterator));
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    private String style(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.isProperty(STYLABLE);
        if (bl) {
            stringBuffer.append("style=\"");
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(":");
                stringBuffer.append(string2);
                stringBuffer.append(";");
                continue;
            }
            stringBuffer.append("=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(" ");
        }
        if (bl) {
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static String fixedPrecision(double d2) {
        return scientific.format(d2);
    }

    protected PrintWriter getOutputStream() {
        return this.os;
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(VERSION, VERSION_1_1);
        defaultProperties.setProperty(COMPRESS, false);
        defaultProperties.setProperty(STYLABLE, false);
        defaultProperties.setProperty(IMAGE_SIZE, new Dimension(0, 0));
        defaultProperties.setProperty(EXPORT_IMAGES, false);
        defaultProperties.setProperty(EXPORT_SUFFIX, "image");
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(FOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        scientific = new DecimalFormat("#.####################", new DecimalFormatSymbols(Locale.US));
    }
}

