/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.png;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGEncoder
implements ImageObserver {
    public static final boolean ENCODE_ALPHA = true;
    public static final boolean NO_ALPHA = false;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    protected byte[] pngBytes;
    protected byte[] priorRow;
    protected byte[] leftBytes;
    protected Image image;
    protected int width;
    protected int height;
    protected int bytePos;
    protected int maxPos;
    protected int hdrPos;
    protected int dataPos;
    protected int endPos;
    protected CRC32 crc = new CRC32();
    protected long crcValue;
    protected boolean encodeAlpha;
    protected int filter;
    protected int bytesPerPixel;
    protected int compressionLevel;
    protected List keys = new ArrayList();
    protected List text = new ArrayList();
    private int imageStatus;

    public PNGEncoder() {
        this(null, false, 0, 0);
    }

    public PNGEncoder(Image image) {
        this(image, false, 0, 0);
    }

    public PNGEncoder(Image image, boolean bl) {
        this(image, bl, 0, 0);
    }

    public PNGEncoder(Image image, boolean bl, int n2) {
        this(image, bl, n2, 0);
    }

    public PNGEncoder(Image image, boolean bl, int n2, int n3) {
        this.image = image;
        this.encodeAlpha = bl;
        this.setFilter(n2);
        if (n3 >= 0 && n3 <= 9) {
            this.compressionLevel = n3;
        }
    }

    public void addText(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "Comment";
        }
        this.keys.add(string.substring(0, Math.min(79, string.length())));
        this.text.add(string2);
    }

    public void setImage(Image image) {
        this.image = image;
        this.pngBytes = null;
    }

    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        this.imageStatus = n2;
        return (n2 & 0x20) != 32 && (n2 & 0xC0) == 0;
    }

    public byte[] pngEncode(boolean bl) {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            return null;
        }
        this.imageStatus = 0;
        boolean bl2 = Toolkit.getDefaultToolkit().prepareImage(this.image, -1, -1, this);
        if (!bl2) {
            while ((this.imageStatus & 0x20) == 0 && (this.imageStatus & 0xC0) == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if ((this.imageStatus & 0x20) == 0) {
                return null;
            }
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.hdrPos = this.bytePos = this.writeBytes(byArray, 0);
        this.writeHeader();
        Iterator iterator = this.keys.iterator();
        Iterator iterator2 = this.text.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            this.writeText((String)iterator.next(), (String)iterator2.next());
        }
        this.dataPos = this.bytePos;
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    public byte[] pngEncode() {
        return this.pngEncode(this.encodeAlpha);
    }

    public void setEncodeAlpha(boolean bl) {
        this.encodeAlpha = bl;
    }

    public boolean getEncodeAlpha() {
        return this.encodeAlpha;
    }

    public void setFilter(int n2) {
        this.filter = 0;
        if (n2 <= 2) {
            this.filter = n2;
        }
    }

    public int getFilter() {
        return this.filter;
    }

    public void setCompressionLevel(int n2) {
        if (n2 >= 0 && n2 <= 9) {
            this.compressionLevel = n2;
        }
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    protected byte[] resizeByteArray(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n3, n2));
        return byArray2;
    }

    protected int writeBytes(byte[] byArray, int n2) {
        this.maxPos = Math.max(this.maxPos, n2 + byArray.length);
        if (byArray.length + n2 > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, byArray.length));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n2, byArray.length);
        return n2 + byArray.length;
    }

    protected int writeBytes(byte[] byArray, int n2, int n3) {
        this.maxPos = Math.max(this.maxPos, n3 + n2);
        if (n2 + n3 > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, n2));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n3, n2);
        return n3 + n2;
    }

    protected int writeInt2(int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return this.writeBytes(byArray, n3);
    }

    protected int writeInt4(int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return this.writeBytes(byArray, n3);
    }

    protected int writeByte(int n2, int n3) {
        byte[] byArray = new byte[]{(byte)n2};
        return this.writeBytes(byArray, n3);
    }

    protected int writeString(String string, int n2) {
        return this.writeBytes(string.getBytes(), n2);
    }

    protected void writeHeader() {
        int n2 = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeString("IHDR", this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, n2, this.bytePos - n2);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void writeText(String string, String string2) {
        int n2 = string.length() + 1 + string2.length();
        int n3 = this.bytePos = this.writeInt4(n2, this.bytePos);
        this.bytePos = this.writeString("tEXt", this.bytePos);
        this.bytePos = this.writeString(string, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeString(string2, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, n3, this.bytePos - n3);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void filterSub(byte[] byArray, int n2, int n3) {
        int n4 = this.bytesPerPixel;
        int n5 = n2 + n4;
        int n6 = n3 * this.bytesPerPixel;
        int n7 = n4;
        int n8 = 0;
        for (int i2 = n5; i2 < n2 + n6; ++i2) {
            this.leftBytes[n7] = byArray[i2];
            byArray[i2] = (byte)((byArray[i2] - this.leftBytes[n8]) % 256);
            n7 = (n7 + 1) % 15;
            n8 = (n8 + 1) % 15;
        }
    }

    protected void filterUp(byte[] byArray, int n2, int n3) {
        int n4 = n3 * this.bytesPerPixel;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by = byArray[n2 + i2];
            byArray[n2 + i2] = (byte)((byArray[n2 + i2] - this.priorRow[i2]) % 256);
            this.priorRow[i2] = by;
        }
    }

    protected boolean writeImageData() {
        int n2 = 0;
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            int n3;
            for (int i2 = this.height; i2 > 0; i2 -= n3) {
                n3 = Math.min(Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1)), i2);
                int[] nArray = new int[this.width * n3];
                PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, n2, this.width, n3, nArray, 0, this.width);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    System.err.println("interrupted waiting for pixels!");
                    return false;
                }
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    System.err.println("image fetch aborted or errored");
                    return false;
                }
                byte[] byArray = new byte[this.width * n3 * this.bytesPerPixel + n3];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                int n4 = 0;
                int n5 = 1;
                for (int i3 = 0; i3 < this.width * n3; ++i3) {
                    if (i3 % this.width == 0) {
                        byArray[n4++] = (byte)this.filter;
                        n5 = n4;
                    }
                    byArray[n4++] = (byte)(nArray[i3] >> 16 & 0xFF);
                    byArray[n4++] = (byte)(nArray[i3] >> 8 & 0xFF);
                    byArray[n4++] = (byte)(nArray[i3] & 0xFF);
                    if (this.encodeAlpha) {
                        byArray[n4++] = (byte)(nArray[i3] >> 24 & 0xFF);
                    }
                    if (i3 % this.width != this.width - 1 || this.filter == 0) continue;
                    if (this.filter == 1) {
                        this.filterSub(byArray, n5, this.width);
                    }
                    if (this.filter != 2) continue;
                    this.filterUp(byArray, n5, this.width);
                }
                deflaterOutputStream.write(byArray, 0, n4);
                n2 += n3;
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n6 = byArray.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(n6, this.bytePos);
            this.bytePos = this.writeString("IDAT", this.bytePos);
            this.crc.update("IDAT".getBytes());
            this.bytePos = this.writeBytes(byArray, n6, this.bytePos);
            this.crc.update(byArray, 0, n6);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    protected void writeEnd() {
        this.bytePos = this.writeInt4(0, this.bytePos);
        this.bytePos = this.writeString("IEND", this.bytePos);
        this.crc.reset();
        this.crc.update("IEND".getBytes());
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }
}

