/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.pdf.PDF;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFObject;
import org.freehep.graphicsio.pdf.PDFOutline;
import org.freehep.graphicsio.pdf.PDFOutlineList;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;

public class PDFWriter
extends PDF
implements PDFConstants {
    private String open = null;
    private static final String lengthSuffix = "-length";
    private String catalogName;
    private String docInfoName;

    public PDFWriter(OutputStream outputStream) throws IOException {
        this(outputStream, "1.3");
    }

    public PDFWriter(OutputStream outputStream, String string) throws IOException {
        super(new PDFByteWriter(outputStream));
        this.out.println("%PDF-" + string);
        this.out.print("%");
        this.out.write(226);
        this.out.write(227);
        this.out.write(207);
        this.out.write(211);
        this.out.println();
        this.out.println();
    }

    public void close(String string, String string2) throws IOException {
        this.xref();
        this.trailer(string, string2);
        this.startxref();
        this.out.printPlain("%%EOF");
        this.out.println();
        this.out.close();
    }

    public void comment(String string) throws IOException {
        this.out.println("% " + string);
    }

    public void object(String string, Object[] objectArray) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        pDFObject.entry(objectArray);
        this.close(pDFObject);
    }

    public void object(String string, int n2) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        pDFObject.entry(n2);
        this.close(pDFObject);
    }

    public PDFObject openObject(String string) throws IOException {
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFObject: " + string;
        PDFRef pDFRef = this.ref(string);
        int n2 = pDFRef.getObjectNumber();
        this.setXRef(n2, this.out.getCount());
        PDFObject pDFObject = new PDFObject(this, this.out, n2, pDFRef.getGenerationNumber());
        return pDFObject;
    }

    public void close(PDFObject pDFObject) throws IOException {
        pDFObject.close();
        this.open = null;
    }

    public PDFDictionary openDictionary(String string) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        PDFDictionary pDFDictionary = pDFObject.openDictionary();
        return pDFDictionary;
    }

    public void close(PDFDictionary pDFDictionary) throws IOException {
        pDFDictionary.close();
        this.open = null;
    }

    public PDFStream openStream(String string) throws IOException {
        return this.openStream(string, null);
    }

    public PDFStream openStream(String string, String[] stringArray) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        PDFStream pDFStream = pDFObject.openStream(string, stringArray);
        pDFStream.entry("Length", this.ref(string + lengthSuffix));
        return pDFStream;
    }

    public void close(PDFStream pDFStream) throws IOException {
        pDFStream.close();
        this.open = null;
        this.object(pDFStream.getName() + lengthSuffix, pDFStream.getLength());
    }

    public void close() throws IOException {
        this.close(this.catalogName, this.docInfoName);
    }

    public PDFDocInfo openDocInfo(String string) throws IOException {
        this.docInfoName = string;
        PDFObject pDFObject = this.openObject(string);
        PDFDocInfo pDFDocInfo = pDFObject.openDocInfo(this);
        return pDFDocInfo;
    }

    public void close(PDFDocInfo pDFDocInfo) throws IOException {
        pDFDocInfo.close();
        this.open = null;
    }

    public PDFCatalog openCatalog(String string, String string2) throws IOException {
        this.catalogName = string;
        PDFObject pDFObject = this.openObject(string);
        PDFCatalog pDFCatalog = pDFObject.openCatalog(this, this.ref(string2));
        return pDFCatalog;
    }

    public void close(PDFCatalog pDFCatalog) throws IOException {
        pDFCatalog.close();
        this.open = null;
    }

    public PDFPageTree openPageTree(String string, String string2) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        PDFPageTree pDFPageTree = pDFObject.openPageTree(this, this.ref(string2));
        return pDFPageTree;
    }

    public void close(PDFPageTree pDFPageTree) throws IOException {
        pDFPageTree.close();
        this.open = null;
    }

    public PDFPage openPage(String string, String string2) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        PDFPage pDFPage = pDFObject.openPage(this, this.ref(string2));
        return pDFPage;
    }

    public void close(PDFPage pDFPage) throws IOException {
        pDFPage.close();
        this.open = null;
    }

    public PDFViewerPreferences openViewerPreferences(String string) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        PDFViewerPreferences pDFViewerPreferences = pDFObject.openViewerPreferences(this);
        return pDFViewerPreferences;
    }

    public void close(PDFViewerPreferences pDFViewerPreferences) throws IOException {
        pDFViewerPreferences.close();
        this.open = null;
    }

    public PDFOutlineList openOutlineList(String string, String string2, String string3) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        PDFOutlineList pDFOutlineList = pDFObject.openOutlineList(this, this.ref(string2), this.ref(string3));
        return pDFOutlineList;
    }

    public void close(PDFOutlineList pDFOutlineList) throws IOException {
        pDFOutlineList.close();
        this.open = null;
    }

    public PDFOutline openOutline(String string, String string2, String string3, String string4, String string5) throws IOException {
        PDFObject pDFObject = this.openObject(string);
        PDFOutline pDFOutline = pDFObject.openOutline(this, this.ref(string3), string2, this.ref(string4), this.ref(string5));
        return pDFOutline;
    }

    public void close(PDFOutline pDFOutline) throws IOException {
        pDFOutline.close();
        this.open = null;
    }
}

