/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.text.DecimalFormat;
import java.util.Calendar;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.util.ScientificFormat;

public class PDFUtil
implements PDFConstants {
    private static final ScientificFormat scientific = new ScientificFormat(5, 100, false);

    private PDFUtil() {
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '(': 
                case ')': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String date(Calendar calendar) {
        String string;
        int n2 = calendar.get(15) + calendar.get(16);
        if (n2 == 0) {
            string = "Z";
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("00");
            int n3 = Math.abs(n2 / 3600000);
            int n4 = Math.abs(n2 % 3600000);
            string = n2 > 0 ? "+" + decimalFormat.format(n3) + "'" + decimalFormat.format(n4) + "'" : "-" + decimalFormat.format(n3) + "'" + decimalFormat.format(n4) + "'";
        }
        return "(D:" + dateFormat.format(calendar.getTime()) + string + ")";
    }

    public static String fixedPrecision(double d2) {
        return scientific.format(d2);
    }
}

