/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.pdf.ImageBytes;
import org.freehep.graphicsio.pdf.PDF;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFObject;
import org.freehep.graphicsio.pdf.PDFPathConstructor;
import org.freehep.graphicsio.pdf.PDFUtil;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.ASCIIHexOutputStream;
import org.freehep.util.io.CountedByteOutputStream;
import org.freehep.util.io.FinishableOutputStream;
import org.freehep.util.io.FlateOutputStream;

public class PDFStream
extends PDFDictionary
implements PDFConstants {
    private String name;
    private PDFObject object;
    private boolean dictionaryOpen;
    private OutputStream[] stream;
    private CountedByteOutputStream byteCountStream;
    private String[] encode;
    private int gStates = 0;
    private boolean textOpen = false;
    private boolean fontWasSet = false;
    private boolean compatibilityOpen = false;

    PDFStream(PDF pDF, PDFByteWriter pDFByteWriter, String string, PDFObject pDFObject, String[] stringArray) throws IOException {
        super(pDF, pDFByteWriter);
        this.name = string;
        this.object = pDFObject;
        if (this.object == null) {
            System.err.println("PDFWriter: 'PDFStream' cannot have a null parent");
        }
        this.dictionaryOpen = true;
        this.encode = stringArray;
    }

    private void startStream() throws IOException {
        this.startStream(this.encode);
    }

    private void startStream(String[] stringArray) throws IOException {
        if (this.dictionaryOpen) {
            Object[] objectArray = PDFStream.decodeFilters(stringArray);
            if (objectArray != null) {
                this.entry("Filter", objectArray);
            }
            super.close();
            this.dictionaryOpen = false;
            this.out.printPlain("stream\n");
            this.byteCountStream = new CountedByteOutputStream(this.out);
            this.stream = PDFStream.openFilters(this.byteCountStream, stringArray);
        }
    }

    private void write(int n2) throws IOException {
        this.startStream();
        this.stream[0].write(n2);
    }

    private void write(byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.write(byArray[i2]);
        }
    }

    private static PDFName[] decodeFilters(String[] stringArray) {
        PDFName[] pDFNameArray = null;
        if (stringArray != null && stringArray.length != 0) {
            pDFNameArray = new PDFName[stringArray.length];
            for (int i2 = 0; i2 < pDFNameArray.length; ++i2) {
                pDFNameArray[i2] = new PDFName(stringArray[stringArray.length - i2 - 1] + "Decode");
            }
        }
        return pDFNameArray;
    }

    private static OutputStream[] openFilters(OutputStream outputStream, String[] stringArray) {
        OutputStream[] outputStreamArray;
        if (stringArray != null && stringArray.length != 0) {
            outputStreamArray = new OutputStream[stringArray.length + 1];
            outputStreamArray[outputStreamArray.length - 1] = outputStream;
            for (int i2 = outputStreamArray.length - 2; i2 >= 0; --i2) {
                if (stringArray[i2].equals("ASCIIHex")) {
                    outputStreamArray[i2] = new ASCIIHexOutputStream(outputStreamArray[i2 + 1]);
                    continue;
                }
                if (stringArray[i2].equals("ASCII85")) {
                    outputStreamArray[i2] = new ASCII85OutputStream(outputStreamArray[i2 + 1]);
                    continue;
                }
                if (stringArray[i2].equals("Flate")) {
                    outputStreamArray[i2] = new FlateOutputStream(outputStreamArray[i2 + 1]);
                    continue;
                }
                if (stringArray[i2].equals("DCT")) {
                    outputStreamArray[i2] = outputStreamArray[i2 + 1];
                    continue;
                }
                System.err.println("PDFWriter: unknown stream format: " + stringArray[i2]);
            }
        } else {
            outputStreamArray = new OutputStream[]{outputStream};
        }
        return outputStreamArray;
    }

    private static void closeFilters(OutputStream[] outputStreamArray) throws IOException {
        for (int i2 = 0; i2 < outputStreamArray.length - 1; ++i2) {
            outputStreamArray[i2].flush();
            if (!(outputStreamArray[i2] instanceof FinishableOutputStream)) continue;
            ((FinishableOutputStream)((Object)outputStreamArray[i2])).finish();
        }
        outputStreamArray[outputStreamArray.length - 1].flush();
    }

    private void write(String string) throws IOException {
        byte[] byArray = string.getBytes("ISO-8859-1");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.write(byArray[i2]);
        }
    }

    void close() throws IOException {
        PDFStream.closeFilters(this.stream);
        this.stream = null;
        this.out.printPlain("\nendstream");
        this.out.println();
        this.object.close();
        if (this.gStates > 0) {
            System.err.println("PDFStream: unbalanced saves()/restores(), too many saves: " + this.gStates);
        }
    }

    String getName() {
        return this.name;
    }

    public int getLength() {
        return this.byteCountStream.getCount();
    }

    public void print(String string) throws IOException {
        this.write(string);
    }

    public void println(String string) throws IOException {
        this.write(string);
        this.write(EOL);
    }

    public void comment(String string) throws IOException {
        this.println("% " + string);
    }

    public void save() throws IOException {
        this.println("q");
        ++this.gStates;
    }

    public void restore() throws IOException {
        if (this.gStates <= 0) {
            System.err.println("PDFStream: unbalanced saves()/restores(), too many restores");
        }
        --this.gStates;
        this.println("Q");
    }

    public void matrix(AffineTransform affineTransform) throws IOException {
        this.matrix(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    public void matrix(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " " + PDFUtil.fixedPrecision(d6) + " " + PDFUtil.fixedPrecision(d7) + " cm");
    }

    public void width(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " w");
    }

    public void cap(int n2) throws IOException {
        this.println(n2 + " J");
    }

    public void join(int n2) throws IOException {
        this.println(n2 + " j");
    }

    public void mitterLimit(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " M");
    }

    public void dash(int[] nArray, double d2) throws IOException {
        this.print("[");
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.print(" " + PDFUtil.fixedPrecision(nArray[i2]));
        }
        this.println("] " + PDFUtil.fixedPrecision(d2) + " d");
    }

    public void dash(float[] fArray, double d2) throws IOException {
        this.print("[");
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.print(" " + PDFUtil.fixedPrecision(fArray[i2]));
        }
        this.println("] " + PDFUtil.fixedPrecision(d2) + " d");
    }

    public void flatness(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " i");
    }

    public void state(PDFName pDFName) throws IOException {
        this.println(pDFName + " gs");
    }

    public void cubic(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " " + PDFUtil.fixedPrecision(d6) + " " + PDFUtil.fixedPrecision(d7) + " c");
    }

    public void cubicV(double d2, double d3, double d4, double d5) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " v");
    }

    public void cubicY(double d2, double d3, double d4, double d5) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " y");
    }

    public void move(double d2, double d3) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " m");
    }

    public void line(double d2, double d3) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " l");
    }

    public void closePath() throws IOException {
        this.println("h");
    }

    public void rectangle(double d2, double d3, double d4, double d5) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " re");
    }

    public void stroke() throws IOException {
        this.println("S");
    }

    public void closeAndStroke() throws IOException {
        this.println("s");
    }

    public void fill() throws IOException {
        this.println("f");
    }

    public void fillEvenOdd() throws IOException {
        this.println("f*");
    }

    public void fillAndStroke() throws IOException {
        this.println("B");
    }

    public void fillEvenOddAndStroke() throws IOException {
        this.println("B*");
    }

    public void closeFillAndStroke() throws IOException {
        this.println("b");
    }

    public void closeFillEvenOddAndStroke() throws IOException {
        this.println("b*");
    }

    public void endPath() throws IOException {
        this.println("n");
    }

    public void clip() throws IOException {
        this.println("W");
    }

    public void clipEvenOdd() throws IOException {
        this.println("W*");
    }

    public void beginText() throws IOException {
        if (this.textOpen) {
            System.err.println("PDFStream: nested beginText() not allowed.");
        }
        this.println("BT");
        this.textOpen = true;
    }

    public void endText() throws IOException {
        if (!this.textOpen) {
            System.err.println("PDFStream: unbalanced use of beginText()/endText().");
        }
        this.println("ET");
        this.textOpen = false;
    }

    public void charSpace(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " Tc");
    }

    public void wordSpace(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " Tw");
    }

    public void scale(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " Tz");
    }

    public void leading(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " TL");
    }

    public void font(PDFName pDFName, double d2) throws IOException {
        this.println(pDFName + " " + PDFUtil.fixedPrecision(d2) + " Tf");
        this.fontWasSet = true;
    }

    public void rendering(int n2) throws IOException {
        this.println(n2 + " Tr");
    }

    public void rise(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " Ts");
    }

    public void text(double d2, double d3) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " Td");
    }

    public void textLeading(double d2, double d3) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " TD");
    }

    public void textMatrix(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " " + PDFUtil.fixedPrecision(d6) + " " + PDFUtil.fixedPrecision(d7) + " Tm");
    }

    public void textLine() throws IOException {
        this.println("T*");
    }

    public void show(String string) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println("(" + PDFUtil.escape(string) + ") Tj");
    }

    public void showLine(String string) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println("(" + PDFUtil.escape(string) + ") '");
    }

    public void showLine(double d2, double d3, String string) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " (" + PDFUtil.escape(string) + ") \"");
    }

    public void show(Object[] objectArray) throws IOException {
        this.print("[");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof String) {
                this.print(" (" + PDFUtil.escape(object.toString()) + ")");
                continue;
            }
            if (object instanceof Integer) {
                this.print(" " + (Integer)object);
                continue;
            }
            if (object instanceof Double) {
                this.print(" " + (Double)object);
                continue;
            }
            System.err.println("PDFStream: input array of operator TJ may only contain objects of type 'String', 'Integer' or 'Double'");
        }
        this.println("] TJ");
    }

    public void glyph(double d2, double d3) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " d0");
    }

    public void glyph(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " " + PDFUtil.fixedPrecision(d6) + " " + PDFUtil.fixedPrecision(d7) + " d1");
    }

    public void colorSpace(PDFName pDFName) throws IOException {
        this.println(pDFName + " cs");
    }

    public void colorSpaceStroke(PDFName pDFName) throws IOException {
        this.println(pDFName + " CS");
    }

    public void colorSpace(double[] dArray) throws IOException {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            this.print(" " + dArray[i2]);
        }
        this.println(" scn");
    }

    public void colorSpaceStroke(double[] dArray) throws IOException {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            this.print(" " + dArray[i2]);
        }
        this.println(" SCN");
    }

    public void colorSpace(double[] dArray, PDFName pDFName) throws IOException {
        if (dArray != null) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.print(PDFUtil.fixedPrecision(dArray[i2]) + " ");
            }
        }
        this.println(pDFName + " scn");
    }

    public void colorSpaceStroke(double[] dArray, PDFName pDFName) throws IOException {
        if (dArray != null) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.print(PDFUtil.fixedPrecision(dArray[i2]) + " ");
            }
        }
        this.println(pDFName + " SCN");
    }

    public void colorSpace(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " g");
    }

    public void colorSpaceStroke(double d2) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " G");
    }

    public void colorSpace(double d2, double d3, double d4) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " rg");
    }

    public void colorSpaceStroke(double d2, double d3, double d4) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " RG");
    }

    public void colorSpace(double d2, double d3, double d4, double d5) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " k");
    }

    public void colorSpaceStroke(double d2, double d3, double d4, double d5) throws IOException {
        this.println(PDFUtil.fixedPrecision(d2) + " " + PDFUtil.fixedPrecision(d3) + " " + PDFUtil.fixedPrecision(d4) + " " + PDFUtil.fixedPrecision(d5) + " K");
    }

    public void shade(PDFName pDFName) throws IOException {
        this.println(pDFName + " sh");
    }

    private PDFName[] getFilterName(String string) {
        if ("ZLIB".equals(string)) {
            return PDFStream.decodeFilters(new String[]{"Flate", "ASCII85"});
        }
        if ("JPG".equals(string)) {
            return PDFStream.decodeFilters(new String[]{"DCT", "ASCII85"});
        }
        throw new IllegalArgumentException("unknown image encoding " + string + " for PDFStream");
    }

    public void image(RenderedImage renderedImage, Color color, String string) throws IOException {
        ImageBytes imageBytes = new ImageBytes(renderedImage, color, string, "RGB");
        this.entry("Width", renderedImage.getWidth());
        this.entry("Height", renderedImage.getHeight());
        this.entry("ColorSpace", this.pdf.name("DeviceRGB"));
        this.entry("BitsPerComponent", 8);
        this.entry("Filter", this.getFilterName(imageBytes.getFormat()));
        this.write(imageBytes.getBytes());
    }

    public void imageMask(RenderedImage renderedImage, String string) throws IOException {
        ImageBytes imageBytes = new ImageBytes(renderedImage, null, string, "A");
        this.entry("Width", renderedImage.getWidth());
        this.entry("Height", renderedImage.getHeight());
        this.entry("BitsPerComponent", 8);
        this.entry("ColorSpace", this.pdf.name("DeviceGray"));
        this.entry("Filter", this.getFilterName(imageBytes.getFormat()));
        this.write(imageBytes.getBytes());
    }

    public void inlineImage(RenderedImage renderedImage, Color color, String string) throws IOException {
        ImageBytes imageBytes = new ImageBytes(renderedImage, color, "JPG", "RGB");
        this.println("BI");
        this.imageInfo("Width", renderedImage.getWidth());
        this.imageInfo("Height", renderedImage.getHeight());
        this.imageInfo("ColorSpace", this.pdf.name("DeviceRGB"));
        this.imageInfo("BitsPerComponent", 8);
        this.imageInfo("Filter", this.getFilterName(imageBytes.getFormat()));
        this.print("ID\n");
        this.write(imageBytes.getBytes());
        this.println("\nEI");
    }

    private void imageInfo(String string, int n2) throws IOException {
        this.println("/" + string + " " + n2);
    }

    private void imageInfo(String string, PDFName pDFName) throws IOException {
        this.println("/" + string + " " + pDFName);
    }

    private void imageInfo(String string, Object[] objectArray) throws IOException {
        this.print("/" + string + " [");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.print(" " + objectArray[i2]);
        }
        this.println("]");
    }

    public boolean drawPath(Shape shape) throws IOException {
        PDFPathConstructor pDFPathConstructor = new PDFPathConstructor(this);
        return pDFPathConstructor.addPath(shape);
    }

    public void xObject(PDFName pDFName) throws IOException {
        this.println(pDFName + " Do");
    }

    public void beginCompatibility() throws IOException {
        if (this.compatibilityOpen) {
            System.err.println("PDFStream: nested use of Compatibility sections not allowed.");
        }
        this.println("BX");
        this.compatibilityOpen = true;
    }

    public void endCompatibility() throws IOException {
        if (!this.compatibilityOpen) {
            System.err.println("PDFStream: unbalanced use of begin/endCompatibilty().");
        }
        this.println("EX");
        this.compatibilityOpen = false;
    }
}

