/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFRedundanceTracker {
    private static int refCount = 1;
    private PDFWriter pdf;
    private Map objects;
    private Vector orderedObjects;

    public PDFRedundanceTracker(PDFWriter pDFWriter) {
        this.pdf = pDFWriter;
        this.objects = new Hashtable();
        this.orderedObjects = new Vector();
    }

    public PDFRef getReference(Object object, Object object2, Writer writer) {
        Object v2 = this.objects.get(object);
        if (v2 != null) {
            return ((Entry)v2).reference;
        }
        Entry entry = new Entry(object, object2, writer);
        this.objects.put(object, entry);
        this.orderedObjects.add(entry);
        return entry.reference;
    }

    public PDFRef getReference(Object object, Writer writer) {
        return this.getReference(object, null, writer);
    }

    public void writeAll() {
        Iterator iterator = this.orderedObjects.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.written) continue;
            try {
                entry.writer.writeObject(entry.object, entry.reference, this.pdf);
                entry.written = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public Collection getGroup(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = this.orderedObjects.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!object.equals(entry.groupID)) continue;
            linkedList.add(entry.object);
        }
        return linkedList;
    }

    private class Entry {
        private static final String REF_PREFIX = "PDF_RTObj";
        private Object object;
        private Writer writer;
        private boolean written;
        private PDFRef reference;
        private Object groupID;

        private Entry(Object object, Object object2, Writer writer) {
            this.object = object;
            this.groupID = object2;
            this.writer = writer;
            this.written = false;
            this.reference = PDFRedundanceTracker.this.pdf.ref(REF_PREFIX + refCount++);
        }
    }

    public static interface Writer {
        public void writeObject(Object var1, PDFRef var2, PDFWriter var3) throws IOException;
    }
}

