/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFImageDelayQueue;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFPaintDelayQueue {
    private static int currentNumber = 0;
    private List paintList;
    private PDFWriter pdf;
    private AffineTransform pageMatrix;

    public PDFPaintDelayQueue(PDFWriter pDFWriter, PDFImageDelayQueue pDFImageDelayQueue) {
        this.pdf = pDFWriter;
        this.paintList = new LinkedList();
        this.pageMatrix = new AffineTransform();
    }

    public void setPageMatrix(AffineTransform affineTransform) {
        this.pageMatrix = new AffineTransform(affineTransform);
    }

    public PDFName delayPaint(Paint paint, AffineTransform affineTransform, String string) {
        Entry entry = new Entry(paint, affineTransform, string);
        this.paintList.add(entry);
        return this.pdf.name(entry.name);
    }

    public void processAll() throws IOException {
        ListIterator listIterator = this.paintList.listIterator();
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.written) continue;
            entry.written = true;
            if (entry.paint instanceof GradientPaint) {
                this.addGradientPaint(entry);
                continue;
            }
            if (entry.paint instanceof TexturePaint) {
                this.addTexturePaint(entry);
                continue;
            }
            System.err.println("PDFWriter: Paint of class '" + entry.paint.getClass() + "' not supported.");
        }
    }

    public int addPatterns() throws IOException {
        if (this.paintList.size() > 0) {
            PDFDictionary pDFDictionary = this.pdf.openDictionary("Pattern");
            ListIterator listIterator = this.paintList.listIterator();
            while (listIterator.hasNext()) {
                Entry entry = (Entry)listIterator.next();
                pDFDictionary.entry(entry.name, this.pdf.ref(entry.name));
            }
            this.pdf.close(pDFDictionary);
        }
        return this.paintList.size();
    }

    private void addGradientPaint(Entry entry) throws IOException {
        GradientPaint gradientPaint = (GradientPaint)entry.paint;
        PDFDictionary pDFDictionary = this.pdf.openDictionary(entry.name);
        pDFDictionary.entry("Type", this.pdf.name("Pattern"));
        pDFDictionary.entry("PatternType", 2);
        this.setMatrix(pDFDictionary, entry, 0.0, 0.0);
        PDFDictionary pDFDictionary2 = pDFDictionary.openDictionary("Shading");
        pDFDictionary2.entry("ShadingType", 2);
        pDFDictionary2.entry("ColorSpace", this.pdf.name("DeviceRGB"));
        Point2D point2D = gradientPaint.getPoint1();
        Point2D point2D2 = gradientPaint.getPoint2();
        pDFDictionary2.entry("Coords", new double[]{point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY()});
        double[] dArray = new double[]{0.0, 1.0};
        pDFDictionary2.entry("Domain", dArray);
        String string = entry.name + "Function";
        pDFDictionary2.entry("Function", this.pdf.ref(string));
        pDFDictionary2.entry("Extend", new boolean[]{true, true});
        pDFDictionary.close(pDFDictionary2);
        this.pdf.close(pDFDictionary);
        float[] fArray = new float[3];
        gradientPaint.getColor1().getRGBColorComponents(fArray);
        double[] dArray2 = new double[]{fArray[0], fArray[1], fArray[2]};
        float[] fArray2 = new float[3];
        gradientPaint.getColor2().getRGBColorComponents(fArray2);
        double[] dArray3 = new double[]{fArray2[0], fArray2[1], fArray2[2]};
        if (gradientPaint.isCyclic()) {
            this.addLinearFunction(string, dArray2, dArray3, dArray);
        } else {
            this.addLinearFunction(string, dArray2, dArray3, dArray);
        }
    }

    private void addLinearFunction(String string, double[] dArray, double[] dArray2, double[] dArray3) throws IOException {
        PDFDictionary pDFDictionary = this.pdf.openDictionary(string);
        pDFDictionary.entry("FunctionType", 2);
        pDFDictionary.entry("Domain", dArray3);
        pDFDictionary.entry("Range", new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0});
        pDFDictionary.entry("C0", dArray);
        pDFDictionary.entry("C1", dArray2);
        pDFDictionary.entry("N", 1);
        this.pdf.close(pDFDictionary);
    }

    protected void addCyclicFunction(String string, double[] dArray, double[] dArray2, double[] dArray3) throws IOException {
        PDFStream pDFStream = this.pdf.openStream(string);
        pDFStream.entry("FunctionType", 4);
        pDFStream.entry("Domain", dArray3);
        pDFStream.entry("Range", new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0});
        pDFStream.println("{");
        for (int i2 = 0; i2 < 3; ++i2) {
            if (i2 < 2) {
                pDFStream.println("dup");
            }
            pDFStream.println(dArray2[i2] - dArray[i2] + " mul");
            pDFStream.println(dArray[i2] + " add");
            if (i2 >= 2) continue;
            pDFStream.println("exch");
        }
        pDFStream.println("}");
        this.pdf.close(pDFStream);
    }

    private void addTexturePaint(Entry entry) throws IOException {
        TexturePaint texturePaint = (TexturePaint)entry.paint;
        PDFStream pDFStream = this.pdf.openStream(entry.name, null);
        pDFStream.entry("Type", this.pdf.name("Pattern"));
        pDFStream.entry("PatternType", 1);
        pDFStream.entry("PaintType", 1);
        BufferedImage bufferedImage = texturePaint.getImage();
        pDFStream.entry("TilingType", 1);
        double d2 = texturePaint.getAnchorRect().getWidth();
        double d3 = texturePaint.getAnchorRect().getHeight();
        double d4 = texturePaint.getAnchorRect().getX();
        double d5 = texturePaint.getAnchorRect().getY();
        pDFStream.entry("BBox", new double[]{0.0, 0.0, d2, d3});
        pDFStream.entry("XStep", d2);
        pDFStream.entry("YStep", d3);
        PDFDictionary pDFDictionary = pDFStream.openDictionary("Resources");
        pDFDictionary.entry("ProcSet", new Object[]{this.pdf.name("PDF"), this.pdf.name("ImageC")});
        pDFStream.close(pDFDictionary);
        this.setMatrix(pDFStream, entry, d4, d5);
        pDFStream.matrix(d2, 0.0, 0.0, -d3, 0.0, d3);
        pDFStream.inlineImage(bufferedImage, null, entry.writeAs);
        this.pdf.close(pDFStream);
    }

    private void setMatrix(PDFDictionary pDFDictionary, Entry entry, double d2, double d3) throws IOException {
        AffineTransform affineTransform = new AffineTransform(this.pageMatrix);
        affineTransform.concatenate(entry.trafo);
        affineTransform.translate(d2, d3);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        pDFDictionary.entry("Matrix", new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]});
    }

    private class Entry {
        private Paint paint;
        private String name;
        private AffineTransform trafo;
        private String writeAs;
        private boolean written;

        private Entry(Paint paint, AffineTransform affineTransform, String string) {
            this.paint = paint;
            this.trafo = affineTransform;
            this.writeAs = string;
            this.name = "Paint" + currentNumber++;
            this.written = false;
        }
    }
}

