/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import org.freehep.graphicsio.pdf.PDF;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFOutline;
import org.freehep.graphicsio.pdf.PDFOutlineList;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;

public class PDFObject
implements PDFConstants {
    protected PDF pdf;
    private PDFByteWriter out;
    private String open;
    private boolean ok;

    PDFObject(PDF pDF, PDFByteWriter pDFByteWriter, int n2, int n3) throws IOException {
        this.pdf = pDF;
        this.out = pDFByteWriter;
        this.out.println(n2 + " " + n3 + " obj");
        this.out.indent();
        this.ok = true;
    }

    void close() throws IOException {
        this.out.outdent();
        this.out.println("endobj");
        this.out.println();
        this.ok = false;
    }

    public void entry(int n2) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter: 'PDFObject' was closed");
        }
        this.out.println(n2);
    }

    public void entry(Object[] objectArray) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter: 'PDFObject' was closed");
        }
        this.out.print("[");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(objectArray[i2]);
        }
        this.out.printPlain("]");
        this.out.println();
    }

    PDFDictionary openDictionary() throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFDictionary";
        PDFDictionary pDFDictionary = new PDFDictionary(this.pdf, this.out, this);
        return pDFDictionary;
    }

    void close(PDFDictionary pDFDictionary) throws IOException {
        pDFDictionary.close();
        this.open = null;
    }

    PDFStream openStream(String string, String[] stringArray) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFStream' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFStream";
        PDFStream pDFStream = new PDFStream(this.pdf, this.out, string, this, stringArray);
        return pDFStream;
    }

    void close(PDFStream pDFStream) throws IOException {
        pDFStream.close();
        this.open = null;
    }

    PDFDocInfo openDocInfo(PDF pDF) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDocInfo' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFDocInfo";
        PDFDocInfo pDFDocInfo = new PDFDocInfo(pDF, this.out, this);
        return pDFDocInfo;
    }

    PDFCatalog openCatalog(PDF pDF, PDFRef pDFRef) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFCatalog' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFCatalog";
        PDFCatalog pDFCatalog = new PDFCatalog(pDF, this.out, this, pDFRef);
        return pDFCatalog;
    }

    PDFPageTree openPageTree(PDF pDF, PDFRef pDFRef) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFPageTree' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFPageTree";
        PDFPageTree pDFPageTree = new PDFPageTree(pDF, this.out, this, pDFRef);
        return pDFPageTree;
    }

    PDFPage openPage(PDF pDF, PDFRef pDFRef) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFPage' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFPage";
        PDFPage pDFPage = new PDFPage(pDF, this.out, this, pDFRef);
        return pDFPage;
    }

    PDFViewerPreferences openViewerPreferences(PDF pDF) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFViewerPreferences' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFViewerPreferences";
        PDFViewerPreferences pDFViewerPreferences = new PDFViewerPreferences(pDF, this.out, this);
        return pDFViewerPreferences;
    }

    PDFOutlineList openOutlineList(PDF pDF, PDFRef pDFRef, PDFRef pDFRef2) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFOutlineList' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFOutlineList";
        PDFOutlineList pDFOutlineList = new PDFOutlineList(pDF, this.out, this, pDFRef, pDFRef2);
        return pDFOutlineList;
    }

    PDFOutline openOutline(PDF pDF, PDFRef pDFRef, String string, PDFRef pDFRef2, PDFRef pDFRef3) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFOutline' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFOutline";
        PDFOutline pDFOutline = new PDFOutline(pDF, this.out, this, pDFRef, string, pDFRef2, pDFRef3);
        return pDFOutline;
    }
}

