/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFImageDelayQueue {
    private int currentNumber = 0;
    private Map imageMap;
    private List imageList;
    private PDFWriter pdf;

    public PDFImageDelayQueue(PDFWriter pDFWriter) {
        this.pdf = pDFWriter;
        this.imageMap = new HashMap();
        this.imageList = new LinkedList();
    }

    public PDFName delayImage(RenderedImage renderedImage, Color color, String string) {
        Entry entry = (Entry)this.imageMap.get(renderedImage);
        if (entry == null) {
            entry = new Entry(renderedImage, color, string);
            this.imageMap.put(renderedImage, entry);
            this.imageList.add(entry);
        }
        return this.pdf.name(entry.name);
    }

    public void processAll() throws IOException {
        Iterator iterator = this.imageList.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.written) continue;
            entry.written = true;
            PDFStream pDFStream = this.pdf.openStream(entry.name);
            pDFStream.entry("Subtype", this.pdf.name("Image"));
            if (entry.maskName != null) {
                pDFStream.entry("SMask", this.pdf.ref(entry.maskName));
            }
            pDFStream.image(entry.image, entry.bkg, entry.writeAs);
            this.pdf.close(pDFStream);
            if (entry.maskName == null) continue;
            PDFStream pDFStream2 = this.pdf.openStream(entry.maskName);
            pDFStream2.entry("Subtype", this.pdf.name("Image"));
            pDFStream2.imageMask(entry.image, entry.writeAs);
            this.pdf.close(pDFStream2);
        }
    }

    public int addXObjects() throws IOException {
        if (this.imageList.size() > 0) {
            PDFDictionary pDFDictionary = this.pdf.openDictionary("XObjects");
            Iterator iterator = this.imageList.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                pDFDictionary.entry(entry.name, this.pdf.ref(entry.name));
                if (entry.maskName == null) continue;
                pDFDictionary.entry(entry.maskName, this.pdf.ref(entry.maskName));
            }
            this.pdf.close(pDFDictionary);
        }
        return this.imageList.size();
    }

    private class Entry {
        private RenderedImage image;
        private String name;
        private String maskName;
        private Color bkg;
        private String writeAs;
        private boolean written;

        private Entry(RenderedImage renderedImage, Color color, String string) {
            this.image = renderedImage;
            this.bkg = color;
            this.writeAs = string;
            this.name = "Img" + PDFImageDelayQueue.this.currentNumber++;
            this.maskName = renderedImage.getColorModel().hasAlpha() && color == null ? this.name + "Mask" : null;
            this.written = false;
        }
    }
}

