/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFFontTable;
import org.freehep.graphicsio.pdf.PDFImageDelayQueue;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFOutline;
import org.freehep.graphicsio.pdf.PDFOutlineList;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFPaintDelayQueue;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;
import org.freehep.graphicsio.pdf.PDFWriter;
import org.freehep.util.UserProperties;

public class PDFGraphics2D
extends AbstractVectorGraphicsIO
implements MultiPageDocument,
FontUtilities.ShowString {
    private static final String rootKey = PDFGraphics2D.class.getName();
    public static final String VERSION6 = "Acrobat Reader 6.x";
    public static final String VERSION5 = "Acrobat Reader 5.x";
    public static final String VERSION4 = "Acrobat Reader 4.x";
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String PAGE_SIZE = rootKey + "." + "PageSize";
    public static final String PAGE_MARGINS = rootKey + "." + "PageMargins";
    public static final String ORIENTATION = rootKey + "." + "Orientation";
    public static final String FIT_TO_PAGE = rootKey + "." + "FitToPage";
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    public static final String EMBED_FONTS_AS = rootKey + "." + "EmbedFontsAs";
    public static final String THUMBNAILS = rootKey + ".Thumbnails";
    public static final String THUMBNAIL_SIZE = rootKey + ".ThumbnailSize";
    public static final String COMPRESS = rootKey + ".Compress";
    public static final String VERSION = rootKey + ".Version";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    public static final String AUTHOR = rootKey + "." + "Author";
    public static final String TITLE = rootKey + "." + "Title";
    public static final String SUBJECT = rootKey + "." + "Subject";
    public static final String KEYWORDS = rootKey + "." + "Keywords";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 10516 $";
    private static final String PDF_VERSION = "1.4";
    private static final String[] COMPRESS_FILTERS;
    private static final String[] NO_FILTERS;
    private static final double FONTSIZE_CORRECTION = 1.0;
    private OutputStream ros;
    private PDFWriter os;
    private PDFStream pageStream;
    private PDFFontTable fontTable;
    private PDFImageDelayQueue delayImageQueue;
    private PDFPaintDelayQueue delayPaintQueue;
    private int currentPage;
    private boolean multiPage;
    private TagString[] headerText;
    private int headerUnderline;
    private Font headerFont;
    private TagString[] footerText;
    private int footerUnderline;
    private Font footerFont;
    private List titles;
    int alphaIndex;
    Map extGStates;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties properties) {
        defaultProperties.setProperties(properties);
    }

    public PDFGraphics2D(File file, Dimension dimension) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), dimension);
    }

    public PDFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public PDFGraphics2D(OutputStream outputStream, Dimension dimension) {
        super(dimension, false);
        this.init(outputStream);
    }

    public PDFGraphics2D(OutputStream outputStream, Component component) {
        super(component, false);
        this.init(outputStream);
    }

    private void init(OutputStream outputStream) {
        this.ros = new BufferedOutputStream(outputStream);
        this.currentPage = 0;
        this.multiPage = false;
        this.titles = new ArrayList();
        this.initProperties(defaultProperties);
    }

    protected PDFGraphics2D(PDFGraphics2D pDFGraphics2D, boolean bl) {
        super(pDFGraphics2D, bl);
        this.os = pDFGraphics2D.os;
        this.pageStream = pDFGraphics2D.pageStream;
        this.delayImageQueue = pDFGraphics2D.delayImageQueue;
        this.delayPaintQueue = pDFGraphics2D.delayPaintQueue;
        this.fontTable = pDFGraphics2D.fontTable;
        this.currentPage = pDFGraphics2D.currentPage;
        this.multiPage = pDFGraphics2D.multiPage;
        this.titles = pDFGraphics2D.titles;
        this.alphaIndex = pDFGraphics2D.alphaIndex;
        this.extGStates = pDFGraphics2D.extGStates;
    }

    public void setMultiPage(boolean bl) {
        this.multiPage = bl;
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    public static void setClipEnabled(boolean bl) {
        defaultProperties.setProperty(CLIP, bl);
    }

    public void writeHeader() throws IOException {
        Object object;
        this.os = new PDFWriter(new BufferedOutputStream(this.ros), PDF_VERSION);
        this.delayImageQueue = new PDFImageDelayQueue(this.os);
        this.delayPaintQueue = new PDFPaintDelayQueue(this.os, this.delayImageQueue);
        this.fontTable = new PDFFontTable(this.os);
        String string = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            string = string + " " + version.substring(1, version.length() - 1);
        }
        PDFDocInfo pDFDocInfo = this.os.openDocInfo("DocInfo");
        pDFDocInfo.setTitle(this.getProperty(TITLE));
        pDFDocInfo.setAuthor(this.getProperty(AUTHOR));
        pDFDocInfo.setSubject(this.getProperty(SUBJECT));
        pDFDocInfo.setKeywords(this.getProperty(KEYWORDS));
        pDFDocInfo.setCreator(this.getCreator());
        pDFDocInfo.setProducer(string);
        if (!this.isDeviceIndependent()) {
            object = Calendar.getInstance();
            pDFDocInfo.setCreationDate((Calendar)object);
            pDFDocInfo.setModificationDate((Calendar)object);
        }
        pDFDocInfo.setTrapped("False");
        this.os.close(pDFDocInfo);
        object = this.os.openCatalog("Catalog", "RootPage");
        ((PDFCatalog)object).setOutlines("Outlines");
        ((PDFCatalog)object).setPageMode("UseOutlines");
        ((PDFCatalog)object).setViewerPreferences("Preferences");
        ((PDFCatalog)object).setOpenAction(new Object[]{this.os.ref("Page1"), this.os.name("Fit")});
        this.os.close((PDFCatalog)object);
        PDFViewerPreferences pDFViewerPreferences = this.os.openViewerPreferences("Preferences");
        pDFViewerPreferences.setFitWindow(true);
        pDFViewerPreferences.setCenterWindow(false);
        this.os.close(pDFViewerPreferences);
        this.alphaIndex = 1;
        this.extGStates = new HashMap();
        if (!this.isMultiPage()) {
            this.openPage(this.getSize(), null, this.getComponent());
        }
    }

    public void writeBackground() {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        PDFDictionary pDFDictionary;
        String string;
        Object object;
        PDFDictionary pDFDictionary2;
        if (!this.isMultiPage()) {
            this.closePage();
        }
        PDFPageTree pDFPageTree = this.os.openPageTree("RootPage", null);
        for (int i2 = 1; i2 <= this.currentPage; ++i2) {
            pDFPageTree.addPage("Page" + i2);
        }
        Dimension dimension = PageConstants.getSize(this.getProperty(PAGE_SIZE), this.getProperty(ORIENTATION));
        pDFPageTree.setMediaBox(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        pDFPageTree.setResources("Resources");
        this.os.close(pDFPageTree);
        this.os.object("PageProcSet", new Object[]{this.os.name("PDF"), this.os.name("Text"), this.os.name("ImageC")});
        int n2 = this.fontTable.addFontDictionary();
        int n3 = this.delayImageQueue.addXObjects();
        int n4 = this.delayPaintQueue.addPatterns();
        if (this.extGStates.size() > 0) {
            pDFDictionary2 = this.os.openDictionary("ExtGState");
            object = this.extGStates.keySet().iterator();
            while (object.hasNext()) {
                Float f2 = (Float)object.next();
                string = (String)this.extGStates.get(f2);
                pDFDictionary = pDFDictionary2.openDictionary(string);
                pDFDictionary.entry("ca", f2.floatValue());
                pDFDictionary.entry("CA", f2.floatValue());
                pDFDictionary.entry("BM", this.os.name("Normal"));
                pDFDictionary.entry("AIS", false);
                pDFDictionary2.close(pDFDictionary);
            }
            this.os.close(pDFDictionary2);
        }
        pDFDictionary2 = this.os.openDictionary("Resources");
        pDFDictionary2.entry("ProcSet", this.os.ref("PageProcSet"));
        if (n2 > 0) {
            pDFDictionary2.entry("Font", this.os.ref("FontList"));
        }
        if (n3 > 0) {
            pDFDictionary2.entry("XObject", this.os.ref("XObjects"));
        }
        if (n4 > 0) {
            pDFDictionary2.entry("Pattern", this.os.ref("Pattern"));
        }
        if (this.extGStates.size() > 0) {
            pDFDictionary2.entry("ExtGState", this.os.ref("ExtGState"));
        }
        this.os.close(pDFDictionary2);
        object = this.os.openOutlineList("Outlines", "Outline1", "Outline" + this.currentPage);
        this.os.close((PDFOutlineList)object);
        for (int i3 = 1; i3 <= this.currentPage; ++i3) {
            string = i3 > 1 ? "Outline" + (i3 - 1) : null;
            pDFDictionary = i3 < this.currentPage ? "Outline" + (i3 + 1) : null;
            PDFOutline pDFOutline = this.os.openOutline("Outline" + i3, (String)this.titles.get(i3 - 1), "Outlines", string, (String)((Object)pDFDictionary));
            pDFOutline.setDest(new Object[]{this.os.ref("Page" + i3), this.os.name("Fit")});
            this.os.close(pDFOutline);
        }
        this.processDelayed();
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    private void processDelayed() throws IOException {
        this.delayImageQueue.processAll();
        this.delayPaintQueue.processAll();
        this.fontTable.embedAll(this.getFontRenderContext(), this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
    }

    public void openPage(Component component) throws IOException {
        this.openPage(component.getSize(), component.getName(), component);
    }

    public void openPage(Dimension dimension, String string) throws IOException {
        this.openPage(dimension, string, null);
    }

    private void openPage(Dimension dimension, String string, Component component) throws IOException {
        Object object;
        if (dimension == null) {
            dimension = component.getSize();
        }
        this.resetClip(new Rectangle(0, 0, dimension.width, dimension.height));
        if (this.pageStream != null) {
            this.writeWarning("Page " + this.currentPage + " already open. " + "Call closePage() before starting a new one.");
            return;
        }
        BufferedImage bufferedImage = null;
        if (component != null && this.isProperty(THUMBNAILS)) {
            bufferedImage = ImageGraphics2D.generateThumbnail(component, this.getPropertyDimension(THUMBNAIL_SIZE));
        }
        ++this.currentPage;
        if (string == null) {
            string = "Page " + this.currentPage + " (untitled)";
        }
        this.titles.add(string);
        PDFPage pDFPage = this.os.openPage("Page" + this.currentPage, "RootPage");
        pDFPage.setContents("PageContents" + this.currentPage);
        if (bufferedImage != null) {
            pDFPage.setThumb("Thumb" + this.currentPage);
        }
        this.os.close(pDFPage);
        if (bufferedImage != null) {
            object = this.os.openStream("Thumb" + this.currentPage);
            ((PDFStream)object).image(bufferedImage, Color.black, "ZLIB");
            this.os.close((PDFStream)object);
        }
        this.pageStream = this.os.openStream("PageContents" + this.currentPage, this.isProperty(COMPRESS) ? COMPRESS_FILTERS : NO_FILTERS);
        object = new AffineTransform();
        ((AffineTransform)object).scale(1.0, -1.0);
        Dimension dimension2 = PageConstants.getSize(this.getProperty(PAGE_SIZE), this.getProperty(ORIENTATION));
        Insets insets = PageConstants.getMargins(this.getPropertyInsets(PAGE_MARGINS), this.getProperty(ORIENTATION));
        ((AffineTransform)object).translate(insets.left, -(dimension2.getHeight() - (double)insets.top));
        this.writeHeadline((AffineTransform)object);
        this.writeFootline((AffineTransform)object);
        double d2 = Math.min(this.getWidth() / (double)dimension.width, this.getHeight() / (double)dimension.height);
        if (d2 < 1.0 || this.isProperty(FIT_TO_PAGE)) {
            ((AffineTransform)object).scale(d2, d2);
        } else {
            d2 = 1.0;
        }
        double d3 = (this.getWidth() - (double)dimension.width * d2) / 2.0 / d2;
        double d4 = (this.getHeight() - (double)dimension.height * d2) / 2.0 / d2;
        ((AffineTransform)object).translate(d3, d4);
        this.writeTransform((AffineTransform)object);
        this.writeGraphicsSave();
        this.clipRect(0, 0, dimension.width, dimension.height);
        this.writeGraphicsSave();
        this.delayPaintQueue.setPageMatrix((AffineTransform)object);
        this.writeGraphicsState();
        this.writeBackground();
    }

    public void closePage() throws IOException {
        if (this.pageStream == null) {
            this.writeWarning("Page " + this.currentPage + " already closed. " + "Call openPage() to start a new one.");
            return;
        }
        this.writeGraphicsRestore();
        this.writeGraphicsRestore();
        this.os.close(this.pageStream);
        this.pageStream = null;
        this.processDelayed();
    }

    public void setHeader(Font font, TagString tagString, TagString tagString2, TagString tagString3, int n2) {
        this.headerFont = font;
        this.headerText = new TagString[3];
        this.headerText[0] = tagString;
        this.headerText[1] = tagString2;
        this.headerText[2] = tagString3;
        this.headerUnderline = n2;
    }

    public void setFooter(Font font, TagString tagString, TagString tagString2, TagString tagString3, int n2) {
        this.footerFont = font;
        this.footerText = new TagString[3];
        this.footerText[0] = tagString;
        this.footerText[1] = tagString2;
        this.footerText[2] = tagString3;
        this.footerUnderline = n2;
    }

    private void writeHeadline(AffineTransform affineTransform) throws IOException {
        if (this.headerText != null) {
            LineMetrics lineMetrics = this.headerFont.getLineMetrics("mM", this.getFontRenderContext());
            this.writeLine(affineTransform, this.headerFont, this.headerText, -lineMetrics.getLeading() - this.headerFont.getSize2D() / 2.0f, 3, -this.headerFont.getSize2D() / 2.0f, this.headerUnderline);
        }
    }

    private void writeFootline(AffineTransform affineTransform) throws IOException {
        if (this.footerText != null) {
            LineMetrics lineMetrics = this.footerFont.getLineMetrics("mM", this.getFontRenderContext());
            double d2 = this.getHeight() + (double)(this.footerFont.getSize2D() / 2.0f);
            this.writeLine(affineTransform, this.footerFont, this.footerText, d2 + (double)lineMetrics.getLeading(), 1, d2, this.footerUnderline);
        }
    }

    private void writeLine(AffineTransform affineTransform, Font font, TagString[] tagStringArray, double d2, int n2, double d3, int n3) throws IOException {
        this.writeGraphicsSave();
        this.setColor(Color.black);
        this.setFont(font);
        this.writeTransform(affineTransform);
        if (tagStringArray[0] != null) {
            this.drawString(tagStringArray[0], 0.0, d2, 1, n2);
        }
        if (tagStringArray[1] != null) {
            this.drawString(tagStringArray[1], this.getWidth() / 2.0, d2, 2, n2);
        }
        if (tagStringArray[2] != null) {
            this.drawString(tagStringArray[2], this.getWidth(), d2, 3, n2);
        }
        if (n3 >= 0) {
            this.setLineWidth((double)n3);
            this.drawLine(0.0, d3, this.getWidth(), d3);
        }
        this.writeGraphicsRestore();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return new PDFGraphics2D(this, true);
    }

    public Graphics create(double d2, double d3, double d4, double d5) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(this, true);
        pDFGraphics2D.translate(d2, d3);
        pDFGraphics2D.clipRect(0.0, 0.0, d4, d5);
        return pDFGraphics2D;
    }

    protected void writeGraphicsSave() throws IOException {
        this.pageStream.save();
    }

    protected void writeGraphicsRestore() throws IOException {
        this.pageStream.restore();
    }

    public void draw(Shape shape) {
        try {
            if (this.getStroke() instanceof BasicStroke) {
                this.pageStream.drawPath(shape);
                this.pageStream.stroke();
            } else {
                this.pageStream.drawPath(this.getStroke().createStrokedShape(shape));
                this.pageStream.fill();
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void fill(Shape shape) {
        try {
            boolean bl = this.pageStream.drawPath(shape);
            if (bl) {
                this.pageStream.fillEvenOdd();
            } else {
                this.pageStream.fill();
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage renderedImage, AffineTransform affineTransform, Color color) throws IOException {
        PDFName pDFName = this.delayImageQueue.delayImage(renderedImage, color, this.getProperty(WRITE_IMAGES_AS));
        AffineTransform affineTransform2 = new AffineTransform((double)renderedImage.getWidth(), 0.0, 0.0, (double)(-renderedImage.getHeight()), 0.0, (double)renderedImage.getHeight());
        affineTransform.concatenate(affineTransform2);
        this.writeGraphicsSave();
        this.pageStream.matrix(affineTransform);
        this.pageStream.xObject(pDFName);
        this.writeGraphicsRestore();
    }

    protected void writeString(String string, double d2, double d3) throws IOException {
        this.writeGraphicsSave();
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, d2, d3);
        affineTransform.concatenate(this.getFont().getTransform());
        affineTransform.scale(1.0, -1.0);
        this.writeTransform(affineTransform);
        this.pageStream.beginText();
        this.pageStream.text(0.0, 0.0);
        this.showCharacterCodes(string);
        this.pageStream.endText();
        this.writeGraphicsRestore();
    }

    protected void writeTransform(AffineTransform affineTransform) throws IOException {
        this.pageStream.matrix(affineTransform);
    }

    protected void writeSetClip(Shape shape) throws IOException {
        try {
            AffineTransform affineTransform = this.getTransform();
            Stroke stroke = this.getStroke();
            this.writeGraphicsRestore();
            this.writeGraphicsSave();
            this.writeStroke(stroke);
            this.writeTransform(affineTransform);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        this.writeClip(shape);
    }

    protected void writeClip(Shape shape) throws IOException {
        if (shape == null || !this.isProperty(CLIP)) {
            return;
        }
        if (shape instanceof Rectangle2D) {
            this.pageStream.move(((Rectangle2D)shape).getMinX(), ((Rectangle2D)shape).getMinY());
            this.pageStream.line(((Rectangle2D)shape).getMaxX(), ((Rectangle2D)shape).getMinY());
            this.pageStream.line(((Rectangle2D)shape).getMaxX(), ((Rectangle2D)shape).getMaxY());
            this.pageStream.line(((Rectangle2D)shape).getMinX(), ((Rectangle2D)shape).getMaxY());
            this.pageStream.closePath();
            this.pageStream.clip();
            this.pageStream.endPath();
        } else {
            boolean bl = this.pageStream.drawPath(shape);
            if (bl) {
                this.pageStream.clipEvenOdd();
            } else {
                this.pageStream.clip();
            }
            this.pageStream.endPath();
        }
    }

    protected void writeWidth(float f2) throws IOException {
        this.pageStream.width(f2);
    }

    protected void writeCap(int n2) throws IOException {
        switch (n2) {
            default: {
                this.pageStream.cap(0);
                break;
            }
            case 1: {
                this.pageStream.cap(1);
                break;
            }
            case 2: {
                this.pageStream.cap(2);
            }
        }
    }

    protected void writeJoin(int n2) throws IOException {
        switch (n2) {
            default: {
                this.pageStream.join(0);
                break;
            }
            case 1: {
                this.pageStream.join(1);
                break;
            }
            case 2: {
                this.pageStream.join(2);
            }
        }
    }

    protected void writeMiterLimit(float f2) throws IOException {
        this.pageStream.mitterLimit(f2);
    }

    protected void writeDash(float[] fArray, float f2) throws IOException {
        this.pageStream.dash(fArray, (double)f2);
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color color) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color color) throws IOException {
        float[] fArray = color.getRGBComponents(null);
        Float f2 = new Float(fArray[3]);
        String string = (String)this.extGStates.get(f2);
        if (string == null) {
            string = "Alpha" + this.alphaIndex;
            ++this.alphaIndex;
            this.extGStates.put(f2, string);
        }
        this.pageStream.state(this.os.name(string));
        this.pageStream.colorSpace(fArray[0], fArray[1], fArray[2]);
        this.pageStream.colorSpaceStroke(fArray[0], fArray[1], fArray[2]);
    }

    protected void writePaint(GradientPaint gradientPaint) throws IOException {
        this.writePaint((Paint)gradientPaint);
    }

    protected void writePaint(TexturePaint texturePaint) throws IOException {
        this.writePaint((Paint)texturePaint);
    }

    protected void writePaint(Paint paint) throws IOException {
        this.pageStream.colorSpace(this.os.name("Pattern"));
        this.pageStream.colorSpaceStroke(this.os.name("Pattern"));
        PDFName pDFName = this.delayPaintQueue.delayPaint(paint, this.getTransform(), this.getProperty(WRITE_IMAGES_AS));
        this.pageStream.colorSpace(null, pDFName);
        this.pageStream.colorSpaceStroke(new double[0], pDFName);
    }

    protected void setNonStrokeColor(Color color) throws IOException {
        float[] fArray = color.getRGBColorComponents(null);
        this.pageStream.colorSpace(fArray[0], fArray[1], fArray[2]);
    }

    protected void setStrokeColor(Color color) throws IOException {
        float[] fArray = color.getRGBColorComponents(null);
        this.pageStream.colorSpaceStroke(fArray[0], fArray[1], fArray[2]);
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public void writeComment(String string) throws IOException {
    }

    public String toString() {
        return "PDFGraphics2D";
    }

    public void showString(Font font, String string) throws IOException {
        String string2 = this.fontTable.fontReference(font, this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
        this.pageStream.font(this.os.name(string2), (double)font.getSize() * 1.0);
        this.pageStream.show(string);
    }

    private void showCharacterCodes(String string) throws IOException {
        FontUtilities.showString(this.getFont(), string, Lookup.getInstance().getTable("PDFLatin"), this);
    }

    private double getWidth() {
        Dimension dimension = PageConstants.getSize(this.getProperty(PAGE_SIZE), this.getProperty(ORIENTATION));
        Insets insets = PageConstants.getMargins(this.getPropertyInsets(PAGE_MARGINS), this.getProperty(ORIENTATION));
        return dimension.getWidth() - (double)insets.left - (double)insets.right;
    }

    private double getHeight() {
        Dimension dimension = PageConstants.getSize(this.getProperty(PAGE_SIZE), this.getProperty(ORIENTATION));
        Insets insets = PageConstants.getMargins(this.getPropertyInsets(PAGE_MARGINS), this.getProperty(ORIENTATION));
        return dimension.getHeight() - (double)insets.top - (double)insets.bottom;
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(VERSION, VERSION5);
        defaultProperties.setProperty(COMPRESS, false);
        defaultProperties.setProperty(PAGE_SIZE, "International");
        defaultProperties.setProperty(PAGE_MARGINS, PageConstants.getMargins("Small"));
        defaultProperties.setProperty(ORIENTATION, "Portrait");
        defaultProperties.setProperty(FIT_TO_PAGE, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(EMBED_FONTS_AS, "Type3");
        defaultProperties.setProperty(THUMBNAILS, defaultProperties.getProperty(VERSION).equals(VERSION4));
        defaultProperties.setProperty(THUMBNAIL_SIZE, new Dimension(128, 128));
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(AUTHOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(SUBJECT, "");
        defaultProperties.setProperty(KEYWORDS, "");
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        COMPRESS_FILTERS = new String[]{"Flate", "ASCII85"};
        NO_FILTERS = new String[0];
    }
}

