/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.graphicsio.font.FontIncluder;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType1;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType3;
import org.freehep.graphicsio.pdf.PDFFontIncluder;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontTable
extends FontTable {
    private int currentFontIndex = 1;
    private PDFWriter pdf;
    private PDFRedundanceTracker tracker;
    private static final Properties replaceFonts = new Properties();

    public PDFFontTable(PDFWriter pDFWriter) {
        this.pdf = pDFWriter;
        this.tracker = new PDFRedundanceTracker(pDFWriter);
    }

    public int addFontDictionary() throws IOException {
        Collection collection = this.getEntries();
        if (collection.size() > 0) {
            PDFDictionary pDFDictionary = this.pdf.openDictionary("FontList");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FontTable.Entry entry = (FontTable.Entry)iterator.next();
                pDFDictionary.entry(entry.getReference(), this.pdf.ref(entry.getReference()));
            }
            this.pdf.close(pDFDictionary);
        }
        return collection.size();
    }

    public void embedAll(FontRenderContext fontRenderContext, boolean bl, String string) throws IOException {
        Collection collection = this.getEntries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FontTable.Entry entry = (FontTable.Entry)iterator.next();
            if (entry.isWritten()) continue;
            entry.setWritten(true);
            FontIncluder fontIncluder = null;
            if (PDFFontIncluder.isStandardFont(entry.getFont())) {
                bl = false;
            }
            if (bl) {
                if (string.equals("Type3")) {
                    fontIncluder = new PDFFontEmbedderType3(fontRenderContext, this.pdf, entry.getReference(), this.tracker);
                } else if (string.equals("Type1")) {
                    fontIncluder = PDFFontEmbedderType1.create(fontRenderContext, this.pdf, entry.getReference(), this.tracker);
                } else {
                    System.out.println("PDFFontTable: invalid value for embedAs: " + string);
                }
            } else {
                fontIncluder = new PDFFontIncluder(fontRenderContext, this.pdf, entry.getReference(), this.tracker);
            }
            fontIncluder.includeFont(entry.getFont(), entry.getEncoding(), entry.getReference());
        }
        this.tracker.writeAll();
    }

    public CharTable getEncodingTable() {
        return Lookup.getInstance().getTable("PDFLatin");
    }

    public void firstRequest(FontTable.Entry entry, boolean bl, String string) {
    }

    protected Font substituteFont(Font font) {
        String string = replaceFonts.getProperty(font.getName(), null);
        if (string != null) {
            Font font2 = new Font(string, font.getSize(), font.getStyle());
            font = font2.deriveFont(font.getSize2D());
        }
        return font;
    }

    protected String createFontReference(Font font) {
        return "F" + this.currentFontIndex++;
    }

    static {
        replaceFonts.setProperty("Dialog", "Helvetica");
        replaceFonts.setProperty("DialogInput", "Courier");
        replaceFonts.setProperty("Serif", "TimesRoman");
        replaceFonts.setProperty("SansSerif", "Helvetica");
        replaceFonts.setProperty("Monospaced", "Courier");
    }
}

