/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.font.FontIncluder;
import org.freehep.graphicsio.pdf.PDFCharTableWriter;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontIncluder
extends FontIncluder {
    private static final int PLAIN = 0;
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int BOLDITALIC = 3;
    private static final int COURIER = 0;
    private static final int HELVETICA = 1;
    private static final int TIMES = 2;
    private static final int SYMBOL = 3;
    private static final int DINGBATS = 4;
    private static final String[][] STANDARD_FONT = new String[][]{{"Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique"}, {"Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique"}, {"Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic"}, {"Symbol"}, {"ZapfDingbats"}};
    private PDFWriter pdf;
    private String reference;
    private PDFRedundanceTracker redundanceTracker;

    public PDFFontIncluder(FontRenderContext fontRenderContext, PDFWriter pDFWriter, String string, PDFRedundanceTracker pDFRedundanceTracker) {
        super(fontRenderContext);
        this.pdf = pDFWriter;
        this.reference = string;
        this.redundanceTracker = pDFRedundanceTracker;
    }

    protected void openIncludeFont() throws IOException {
        int n2 = PDFFontIncluder.getFontStyle(this.getFont());
        int n3 = PDFFontIncluder.getFontBaseIndex(this.getFont());
        PDFDictionary pDFDictionary = this.pdf.openDictionary(this.reference);
        pDFDictionary.entry("Type", this.pdf.name("Font"));
        pDFDictionary.entry("Subtype", this.pdf.name("Type1"));
        pDFDictionary.entry("Name", this.pdf.name(this.reference));
        pDFDictionary.entry("BaseFont", this.pdf.name(STANDARD_FONT[n3][n2]));
        pDFDictionary.entry("Encoding", this.redundanceTracker.getReference(this.getEncodingTable(), PDFCharTableWriter.getInstance()));
        this.pdf.close(pDFDictionary);
    }

    protected void writeEncoding(CharTable charTable) throws IOException {
    }

    public static boolean isStandardFont(Font font) {
        String string = font.getName().toLowerCase();
        return string.indexOf("helvetica") >= 0 || string.indexOf("times") >= 0 || string.indexOf("courier") >= 0 || string.indexOf("symbol") >= 0 || string.indexOf("dingbats") >= 0;
    }

    private static int getFontBaseIndex(Font font) {
        String string = font.getName().toLowerCase();
        if (string.indexOf("helvetica") >= 0) {
            return 1;
        }
        if (string.indexOf("times") >= 0) {
            return 2;
        }
        if (string.indexOf("courier") >= 0) {
            return 0;
        }
        if (string.indexOf("symbol") >= 0) {
            return 3;
        }
        if (string.indexOf("dingbats") >= 0) {
            return 4;
        }
        return 1;
    }

    private static int getFontStyle(Font font) {
        int n2 = PDFFontIncluder.getFontBaseIndex(font);
        if (n2 >= 0 && STANDARD_FONT[n2].length == 1) {
            return 0;
        }
        if (n2 < 0) {
            return -1;
        }
        if (font.isBold()) {
            if (font.isItalic()) {
                return 3;
            }
            return 1;
        }
        if (font.isItalic()) {
            return 2;
        }
        return 0;
    }
}

