/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFFontEmbedder;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontEmbedderType3
extends PDFFontEmbedder {
    public PDFFontEmbedderType3(FontRenderContext fontRenderContext, PDFWriter pDFWriter, String string, PDFRedundanceTracker pDFRedundanceTracker) {
        super(fontRenderContext, pDFWriter, string, pDFRedundanceTracker);
    }

    protected String getSubtype() {
        return "Type3";
    }

    protected void addAdditionalEntries(PDFDictionary pDFDictionary) throws IOException {
        Rectangle2D rectangle2D = this.getFontBBox();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getX() + rectangle2D.getWidth();
        double d5 = rectangle2D.getY() + rectangle2D.getHeight();
        pDFDictionary.entry("FontBBox", new double[]{d2, d3, d4, d5});
        pDFDictionary.entry("FontMatrix", new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0});
        pDFDictionary.entry("CharProcs", this.pdf.ref(this.getReference() + "CharProcs"));
        PDFDictionary pDFDictionary2 = pDFDictionary.openDictionary("Resources");
        pDFDictionary2.entry("ProcSet", new Object[]{this.pdf.name("PDF")});
        pDFDictionary.close(pDFDictionary2);
    }

    protected void addAdditionalInitDicts() throws IOException {
        PDFDictionary pDFDictionary = this.pdf.openDictionary(this.getReference() + "CharProcs");
        for (int i2 = 0; i2 < 256; ++i2) {
            String string = this.getEncodingTable().toName(i2);
            if (string == null) continue;
            pDFDictionary.entry(string, this.pdf.ref(this.createCharacterReference(string)));
        }
        pDFDictionary.entry(".notdef", this.pdf.ref(this.createCharacterReference(".notdef")));
        this.pdf.close(pDFDictionary);
    }

    protected void writeGlyph(String string, Shape shape, GlyphMetrics glyphMetrics) throws IOException {
        PDFStream pDFStream = this.pdf.openStream(this.createCharacterReference(string), new String[]{"Flate", "ASCII85"});
        Rectangle2D rectangle2D = glyphMetrics != null ? glyphMetrics.getBounds2D() : shape.getBounds2D();
        double d2 = glyphMetrics != null ? (double)glyphMetrics.getAdvance() : this.getUndefinedWidth();
        pDFStream.glyph(d2, 0.0, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        boolean bl = pDFStream.drawPath(shape);
        if (bl) {
            pDFStream.fillEvenOdd();
        } else {
            pDFStream.fill();
        }
        this.pdf.close(pDFStream);
    }
}

