/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.freehep.graphicsio.font.FontEmbedderType1;
import org.freehep.graphicsio.pdf.PDFCharTableWriter;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontEmbedderType1
extends FontEmbedderType1 {
    private ByteArrayOutputStream byteBuffer;
    private String reference;
    private PDFWriter pdf;
    private PDFStream fontFile;
    private PDFRedundanceTracker redundanceTracker;

    public static PDFFontEmbedderType1 create(FontRenderContext fontRenderContext, PDFWriter pDFWriter, String string, PDFRedundanceTracker pDFRedundanceTracker) {
        return new PDFFontEmbedderType1(fontRenderContext, pDFWriter, string, new ByteArrayOutputStream(), pDFRedundanceTracker);
    }

    private PDFFontEmbedderType1(FontRenderContext fontRenderContext, PDFWriter pDFWriter, String string, ByteArrayOutputStream byteArrayOutputStream, PDFRedundanceTracker pDFRedundanceTracker) {
        super(fontRenderContext, byteArrayOutputStream, false);
        this.byteBuffer = byteArrayOutputStream;
        this.pdf = pDFWriter;
        this.reference = string;
        this.redundanceTracker = pDFRedundanceTracker;
    }

    private String getReference() {
        return this.reference;
    }

    protected void openIncludeFont() throws IOException {
        super.openIncludeFont();
        PDFDictionary pDFDictionary = this.pdf.openDictionary(this.reference);
        pDFDictionary.entry("Type", this.pdf.name("Font"));
        pDFDictionary.entry("Subtype", this.pdf.name("Type1"));
        pDFDictionary.entry("Name", this.pdf.name(this.getFontName()));
        pDFDictionary.entry("FirstChar", 0);
        pDFDictionary.entry("LastChar", 255);
        pDFDictionary.entry("Encoding", this.redundanceTracker.getReference(this.getEncodingTable(), PDFCharTableWriter.getInstance()));
        pDFDictionary.entry("Widths", this.pdf.ref(this.reference + "Widths"));
        pDFDictionary.entry("BaseFont", this.pdf.name(this.getFontName()));
        pDFDictionary.entry("FontDescriptor", this.pdf.ref(this.getReference() + "FontDescriptor"));
        this.pdf.close(pDFDictionary);
        PDFDictionary pDFDictionary2 = this.pdf.openDictionary(this.getReference() + "FontDescriptor");
        pDFDictionary2.entry("Type", this.pdf.name("FontDescriptor"));
        LineMetrics lineMetrics = this.getFont().getLineMetrics("mM", this.getContext());
        pDFDictionary2.entry("Ascent", lineMetrics.getAscent());
        pDFDictionary2.entry("Descent", lineMetrics.getDescent());
        pDFDictionary2.entry("FontName", this.pdf.name(this.getFontName()));
        pDFDictionary2.entry("Flags", 32);
        pDFDictionary2.entry("CapHeight", lineMetrics.getAscent());
        pDFDictionary2.entry("ItalicAngle", this.getFont().getItalicAngle());
        Rectangle2D rectangle2D = this.getFontBBox();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getX() + rectangle2D.getWidth();
        double d5 = rectangle2D.getY() + rectangle2D.getHeight();
        pDFDictionary2.entry("FontBBox", new double[]{d2, d3, d4, d5});
        pDFDictionary2.entry("FontFile", this.pdf.ref(this.getReference() + "FontFile"));
        this.pdf.close(pDFDictionary2);
    }

    protected void writeWidths(double[] dArray) throws IOException {
        super.writeWidths(dArray);
        Object[] objectArray = new Object[256];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = new Integer((int)Math.round(dArray[i2]));
        }
        this.pdf.object(this.reference + "Widths", objectArray);
    }

    protected void openGlyphs() throws IOException {
        super.openGlyphs();
    }

    protected void closeEmbedFont() throws IOException {
        super.closeEmbedFont();
        this.fontFile = this.pdf.openStream(this.getReference() + "FontFile", new String[]{"Flate", "ASCII85"});
        this.fontFile.entry("Length1", this.getAsciiLength());
        this.fontFile.entry("Length2", this.getEncryptedLength());
        this.fontFile.entry("Length3", 0);
        String string = this.byteBuffer.toString("US-ASCII");
        this.fontFile.print(string);
        this.pdf.close(this.fontFile);
    }
}

