/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.font.FontRenderContext;
import java.io.IOException;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.font.FontEmbedder;
import org.freehep.graphicsio.pdf.PDFCharTableWriter;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFWriter;

public abstract class PDFFontEmbedder
extends FontEmbedder {
    protected PDFWriter pdf;
    private PDFDictionary fontDict;
    private String reference;
    private PDFRedundanceTracker redundanceTracker;

    public PDFFontEmbedder(FontRenderContext fontRenderContext, PDFWriter pDFWriter, String string, PDFRedundanceTracker pDFRedundanceTracker) {
        super(fontRenderContext);
        this.pdf = pDFWriter;
        this.reference = string;
        this.redundanceTracker = pDFRedundanceTracker;
    }

    protected abstract String getSubtype();

    protected abstract void addAdditionalEntries(PDFDictionary var1) throws IOException;

    protected abstract void addAdditionalInitDicts() throws IOException;

    protected String getReference() {
        return this.reference;
    }

    protected void openIncludeFont() throws IOException {
        this.fontDict = this.pdf.openDictionary(this.reference);
        this.fontDict.entry("Type", this.pdf.name("Font"));
        this.fontDict.entry("Subtype", this.pdf.name(this.getSubtype()));
        this.fontDict.entry("Name", this.pdf.name(this.getFontName()));
        this.fontDict.entry("FirstChar", 0);
        this.fontDict.entry("LastChar", 255);
        this.fontDict.entry("Encoding", this.redundanceTracker.getReference(this.getEncodingTable(), PDFCharTableWriter.getInstance()));
        this.fontDict.entry("Widths", this.pdf.ref(this.reference + "Widths"));
        this.addAdditionalEntries(this.fontDict);
        this.pdf.close(this.fontDict);
        this.addAdditionalInitDicts();
    }

    protected void closeEmbedFont() {
    }

    protected void writeWidths(double[] dArray) throws IOException {
        Object[] objectArray = new Object[256];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = new Double(dArray[i2]);
        }
        this.pdf.object(this.reference + "Widths", objectArray);
    }

    protected void writeEncoding(CharTable charTable) throws IOException {
    }

    public static void writeEncoding(PDFWriter pDFWriter, String string, CharTable charTable) throws IOException {
        PDFDictionary pDFDictionary = pDFWriter.openDictionary(string);
        pDFDictionary.entry("Type", pDFWriter.name("Encoding"));
        Object[] objectArray = new Object[257];
        objectArray[0] = new Integer(0);
        for (int i2 = 0; i2 < 256; ++i2) {
            String string2 = charTable.toName(i2);
            objectArray[i2 + 1] = string2 != null ? pDFWriter.name(string2) : pDFWriter.name(".notdef");
        }
        pDFDictionary.entry("Differences", objectArray);
        pDFWriter.close(pDFDictionary);
    }

    protected String createCharacterReference(String string) {
        return "Glyph_" + this.reference + ":" + string;
    }
}

