/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.FontPanel;
import org.freehep.graphicsio.exportchooser.ImageTypePanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.PageLayoutPanel;
import org.freehep.graphicsio.exportchooser.PageMarginPanel;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.util.UserProperties;

public class PDFExportFileType
extends AbstractExportFileType {
    private static final String[] versionList = new String[]{"Acrobat Reader 4.x", "Acrobat Reader 5.x"};

    public String getDescription() {
        return "Portable Document Format";
    }

    public String[] getExtensions() {
        return new String[]{"pdf"};
    }

    public String[] getMIMETypes() {
        return new String[]{"application/pdf"};
    }

    public boolean isMultipageCapable() {
        return true;
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties properties) {
        UserProperties userProperties = new UserProperties(properties, PDFGraphics2D.getDefaultProperties());
        OptionPanel optionPanel = new OptionPanel("Format");
        OptionComboBox optionComboBox = new OptionComboBox(userProperties, PDFGraphics2D.VERSION, versionList);
        optionPanel.add("0 * [5 15 5 15] r", new JLabel("PDF Version"));
        optionPanel.add("1 * [5 15 5 15] lw", optionComboBox);
        optionPanel.add("0 * * 1 [5 15 5 15] w", new OptionCheckBox(userProperties, PDFGraphics2D.COMPRESS, "Compress"));
        OptionPanel optionPanel2 = new OptionPanel("Preview");
        OptionCheckBox optionCheckBox = new OptionCheckBox(userProperties, PDFGraphics2D.THUMBNAILS, "Include Thumbnail");
        optionCheckBox.setToolTipText("Thumbnails are automatically generated by Acrobat Reader 5");
        optionPanel2.add("0 * * 1 [5 15 5 15] w", optionCheckBox);
        optionComboBox.selects("Acrobat Reader 4.x", optionCheckBox);
        String string = PDFGraphics2D.class.getName();
        String string2 = AbstractVectorGraphicsIO.class.getName();
        InfoPanel infoPanel = new InfoPanel(userProperties, string, new String[]{"Author", "Title", "Subject", "Keywords"});
        OptionPanel optionPanel3 = new OptionPanel();
        optionPanel3.add("0 * wt", new PageLayoutPanel(userProperties, string));
        optionPanel3.add("0 * wt", new PageMarginPanel(userProperties, string));
        optionPanel3.add("0 * wh", new JLabel());
        OptionPanel optionPanel4 = new OptionPanel();
        optionPanel4.add("0 * wt", optionPanel);
        optionPanel4.add("0 * wt", optionPanel2);
        optionPanel4.add("0 * wt", new BackgroundPanel(userProperties, string, true));
        optionPanel4.add("0 * wt", new ImageTypePanel(userProperties, string, new String[]{"Smallest Size", "ZLIB", "JPG"}));
        optionPanel4.add("0 * wt", new FontPanel(userProperties, string, string2));
        optionPanel4.add("0 * wh", new JLabel());
        OptionPanel optionPanel5 = new OptionPanel();
        optionPanel5.add("0 0 [5 5 5 5] wt", optionPanel3);
        optionPanel5.add("1 0 [5 5 5 5] wt", optionPanel4);
        optionPanel5.add("0 1 2 1 [5 5 5 5] wt", infoPanel);
        optionPanel5.add("0 * wh", new JLabel());
        return optionPanel5;
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Component component) throws IOException {
        return new PDFGraphics2D(outputStream, component);
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Dimension dimension) throws IOException {
        return new PDFGraphics2D(outputStream, dimension);
    }
}

