/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.util.Calendar;
import org.freehep.graphicsio.pdf.PDF;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFObject;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFUtil;

public class PDFDictionary
implements PDFConstants {
    private String open = null;
    protected PDFByteWriter out;
    private boolean ok;
    private PDFObject object;
    protected PDF pdf;

    PDFDictionary(PDF pDF, PDFByteWriter pDFByteWriter) throws IOException {
        this(pDF, pDFByteWriter, null);
    }

    PDFDictionary(PDF pDF, PDFByteWriter pDFByteWriter, PDFObject pDFObject) throws IOException {
        this.pdf = pDF;
        this.object = pDFObject;
        this.out = pDFByteWriter;
        this.out.println("<< ");
        this.out.indent();
        this.ok = true;
    }

    void close() throws IOException {
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.out.outdent();
        this.out.println(">>");
        if (this.object != null) {
            this.object.close();
        }
        this.ok = false;
    }

    public void entry(String string, String string2) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + string + " (" + PDFUtil.escape(string2) + ")");
    }

    public void entry(String string, PDFName pDFName) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + string + " " + pDFName);
    }

    public void entry(String string, int n2) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + string + " " + n2);
    }

    public void entry(String string, double d2) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + string + " " + PDFUtil.fixedPrecision(d2));
    }

    public void entry(String string, boolean bl) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + string + " " + (bl ? "true" : "false"));
    }

    public void entry(String string, PDFRef pDFRef) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + string + " " + pDFRef);
    }

    public void entry(String string, Calendar calendar) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.println("/" + string + " " + PDFUtil.date(calendar));
    }

    public void entry(String string, Object[] objectArray) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + string + " [");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(objectArray[i2]);
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public void entry(String string, int[] nArray) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + string + " [");
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(nArray[i2]);
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public void entry(String string, double[] dArray) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + string + " [");
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (i2 != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(PDFUtil.fixedPrecision(dArray[i2]));
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public void entry(String string, boolean[] blArray) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        this.out.print("/" + string + " [");
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (i2 != 0) {
                this.out.printPlain(" ");
            }
            this.out.printPlain(blArray[i2] ? "true" : "false");
        }
        this.out.printPlain("]");
        this.out.println();
    }

    public PDFDictionary openDictionary(String string) throws IOException {
        if (!this.ok) {
            System.err.println("PDFWriter error: 'PDFDictionary' was closed");
        }
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFDictionary: " + string;
        this.out.println("/" + string);
        PDFDictionary pDFDictionary = new PDFDictionary(this.pdf, this.out);
        return pDFDictionary;
    }

    public void close(PDFDictionary pDFDictionary) throws IOException {
        pDFDictionary.close();
        this.open = null;
    }
}

