/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.util.io.CountedByteOutputStream;

public class PDFByteWriter
extends CountedByteOutputStream
implements PDFConstants {
    private int indent = 0;
    private String indentString = "   ";

    PDFByteWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(String string) throws IOException {
        this.write(string.getBytes("ISO-8859-1"));
    }

    public void close() throws IOException {
        this.out.close();
        super.close();
    }

    public void print(String string) throws IOException {
        for (int i2 = 0; i2 < this.indent; ++i2) {
            this.write(this.indentString);
        }
        this.printPlain(string);
    }

    public void printPlain(String string) throws IOException {
        this.write(string);
    }

    public void println() throws IOException {
        this.write(EOL);
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void print(int n2) throws IOException {
        this.print(Integer.toString(n2));
    }

    public void println(int n2) throws IOException {
        this.print(n2);
        this.println();
    }

    public void printPlain(int n2) throws IOException {
        this.printPlain(Integer.toString(n2));
    }

    public void print(double d2) throws IOException {
        this.print(Double.toString(d2));
    }

    public void println(double d2) throws IOException {
        this.print(d2);
        this.println();
    }

    public void printPlain(double d2) throws IOException {
        this.printPlain(Double.toString(d2));
    }

    public void print(Object object) throws IOException {
        this.print(object.toString());
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.println();
    }

    public void printPlain(Object object) throws IOException {
        this.printPlain(object.toString());
    }
}

