/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFRef;

public class PDF {
    private int generationNumber = 0;
    private Hashtable refsByName = new Hashtable();
    private Vector refsByNumber = new Vector();
    private Vector xrefsByNumber = new Vector();
    private int startXref = 0;
    protected PDFByteWriter out;

    PDF(PDFByteWriter pDFByteWriter) {
        this.out = pDFByteWriter;
        this.refsByNumber.addElement(new PDFRef("Dummy", 0, 0));
        this.xrefsByNumber.addElement(new Integer(999999));
    }

    public PDFName name(String string) {
        return new PDFName(string);
    }

    public PDFRef ref(String string) {
        if (string == null) {
            return null;
        }
        PDFRef pDFRef = (PDFRef)this.refsByName.get(string);
        if (pDFRef == null) {
            int n2 = this.refsByNumber.size();
            pDFRef = new PDFRef(string, n2, this.generationNumber);
            this.refsByName.put(string, pDFRef);
            this.refsByNumber.add(pDFRef);
            this.xrefsByNumber.add(null);
        }
        return pDFRef;
    }

    public PDFRef[] ref(String[] stringArray) {
        PDFRef[] pDFRefArray = new PDFRef[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            pDFRefArray[i2] = this.ref(stringArray[i2]);
        }
        return pDFRefArray;
    }

    protected void setXRef(int n2, int n3) {
        this.xrefsByNumber.set(n2, new Integer(n3));
    }

    protected void xref() throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("0000000000");
        DecimalFormat decimalFormat2 = new DecimalFormat("00000");
        this.startXref = this.out.getCount();
        this.out.printPlain("xref");
        this.out.println();
        this.out.printPlain("0 " + this.xrefsByNumber.size());
        this.out.println();
        this.out.printPlain(decimalFormat.format(0L) + " " + decimalFormat2.format(65535L) + " f\r\n");
        for (int i2 = 1; i2 < this.xrefsByNumber.size(); ++i2) {
            Integer n2 = (Integer)this.xrefsByNumber.get(i2);
            if (n2 != null) {
                int n3 = n2;
                this.out.printPlain(decimalFormat.format(n3) + " " + decimalFormat2.format(0L) + " n\r\n");
                continue;
            }
            PDFRef pDFRef = (PDFRef)this.refsByNumber.get(i2);
            System.err.println("PDFWriter: PDFRef '" + pDFRef.getName() + "' is used but not defined.");
        }
        this.out.println();
    }

    protected void trailer(String string, String string2) throws IOException {
        this.out.println("trailer");
        PDFDictionary pDFDictionary = new PDFDictionary(this, this.out);
        pDFDictionary.entry("Size", this.refsByName.size());
        pDFDictionary.entry("Root", this.ref(string));
        if (string2 != null) {
            pDFDictionary.entry("Info", this.ref(string2));
        }
        pDFDictionary.close();
        this.out.println();
    }

    protected void startxref() throws IOException {
        this.out.println("startxref");
        this.out.println(this.startXref);
        this.out.println();
    }
}

