/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.freehep.graphicsio.ImageGraphics2D;

class ImageBytes {
    private String format;
    private byte[] bytes;

    public ImageBytes(RenderedImage renderedImage, Color color, String string, String string2) throws IOException {
        if ("ZLIB".equals(string) || renderedImage.getColorModel().hasAlpha() && color == null) {
            this.bytes = this.toZLIB(renderedImage, color, string2);
            this.format = "ZLIB";
        } else if ("JPEG".equals(string)) {
            this.bytes = this.toJPG(renderedImage);
            this.format = "JPG";
        } else {
            byte[] byArray;
            byte[] byArray2 = this.toJPG(renderedImage);
            if ((double)byArray2.length < 0.5 * (double)(byArray = this.toZLIB(renderedImage, color, string2)).length) {
                this.bytes = byArray2;
                this.format = "JPG";
            } else {
                this.bytes = byArray;
                this.format = "ZLIB";
            }
        }
    }

    private byte[] toZLIB(RenderedImage renderedImage, Color color, String string) throws IOException {
        return ImageGraphics2D.toByteArray(renderedImage, "RAW", "Flate-ASCII85", ImageGraphics2D.getRAWProperties(color, string));
    }

    private byte[] toJPG(RenderedImage renderedImage) throws IOException {
        return ImageGraphics2D.toByteArray(renderedImage, "JPG", "ASCII85", null);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getFormat() {
        return this.format;
    }
}

