/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

public class NeuQuant {
    public static final int ncycles = 100;
    public static final int netsize = 255;
    public static final int specials = 3;
    public static final int bgColour = 2;
    public static final int cutnetsize = 252;
    public static final int maxnetpos = 254;
    public static final int initrad = 31;
    public static final int radiusbiasshift = 6;
    public static final int radiusbias = 64;
    public static final int initBiasRadius = 1984;
    public static final int radiusdec = 30;
    public static final int alphabiasshift = 10;
    public static final int initalpha = 1024;
    public static final double gamma = 1024.0;
    public static final double beta = 9.765625E-4;
    public static final double betagamma = 1.0;
    private double[][] network = new double[255][3];
    protected int[][] colormap = new int[255][4];
    private int[] netindex = new int[256];
    private double[] bias = new double[255];
    private double[] freq = new double[255];
    public static final int prime1 = 499;
    public static final int prime2 = 491;
    public static final int prime3 = 487;
    public static final int prime4 = 503;
    public static final int maxprime = 503;
    protected int[][] pixels = null;
    private int samplefac = 0;

    public NeuQuant(int n2, int[][] nArray) {
        if (n2 < 1) {
            throw new RuntimeException("Sample must be 1..30");
        }
        if (n2 > 30) {
            throw new RuntimeException("Sample must be 1..30");
        }
        this.samplefac = n2;
        this.setPixels(nArray);
        this.setUpArrays();
    }

    public int getColorCount() {
        return 255;
    }

    public int[] getColorMap() {
        int[] nArray = new int[256];
        nArray[0] = 0;
        for (int i2 = 0; i2 < 255; ++i2) {
            nArray[i2 + 1] = this.colormap[i2][0] | this.colormap[i2][1] << 8 | this.colormap[i2][2] << 16 | 0xFF000000;
        }
        return nArray;
    }

    protected void setUpArrays() {
        int n2;
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 1.0;
        this.network[1][1] = 1.0;
        this.network[1][2] = 1.0;
        for (n2 = 0; n2 < 3; ++n2) {
            this.freq[n2] = 0.00392156862745098;
            this.bias[n2] = 0.0;
        }
        for (n2 = 3; n2 < 255; ++n2) {
            double[] dArray = this.network[n2];
            dArray[0] = 256.0 * (double)(n2 - 3) / 252.0;
            dArray[1] = 256.0 * (double)(n2 - 3) / 252.0;
            dArray[2] = 256.0 * (double)(n2 - 3) / 252.0;
            this.freq[n2] = 0.00392156862745098;
            this.bias[n2] = 0.0;
        }
    }

    private void setPixels(int[][] nArray) {
        if (nArray.length * nArray[0].length < 503) {
            throw new RuntimeException("Image is too small");
        }
        this.pixels = nArray;
    }

    public void init() {
        this.learn();
        this.fix();
        this.inxbuild();
    }

    private void altersingle(double d2, int n2, double d3, double d4, double d5) {
        double[] dArray = this.network[n2];
        dArray[0] = dArray[0] - d2 * (dArray[0] - d3);
        dArray[1] = dArray[1] - d2 * (dArray[1] - d4);
        dArray[2] = dArray[2] - d2 * (dArray[2] - d5);
    }

    private void alterneigh(double d2, int n2, int n3, double d3, double d4, double d5) {
        int n4;
        int n5 = n3 - n2;
        if (n5 < 2) {
            n5 = 2;
        }
        if ((n4 = n3 + n2) > 255) {
            n4 = 255;
        }
        int n6 = n3 + 1;
        int n7 = n3 - 1;
        int n8 = 0;
        while (n6 < n4 || n7 > n5) {
            double[] dArray;
            double d6 = d2 * (double)(n2 * n2 - n8 * n8) / (double)(n2 * n2);
            ++n8;
            if (n6 < n4) {
                dArray = this.network[n6];
                dArray[0] = dArray[0] - d6 * (dArray[0] - d3);
                dArray[1] = dArray[1] - d6 * (dArray[1] - d4);
                dArray[2] = dArray[2] - d6 * (dArray[2] - d5);
                ++n6;
            }
            if (n7 <= n5) continue;
            dArray = this.network[n7];
            dArray[0] = dArray[0] - d6 * (dArray[0] - d3);
            dArray[1] = dArray[1] - d6 * (dArray[1] - d4);
            dArray[2] = dArray[2] - d6 * (dArray[2] - d5);
            --n7;
        }
    }

    private int contest(double d2, double d3, double d4) {
        int n2;
        double d5;
        double d6 = d5 = 3.4028234663852886E38;
        int n3 = n2 = -1;
        for (int i2 = 3; i2 < 255; ++i2) {
            double d7;
            double d8;
            double[] dArray = this.network[i2];
            double d9 = dArray[0] - d2;
            if (d9 < 0.0) {
                d9 = -d9;
            }
            if ((d8 = dArray[1] - d3) < 0.0) {
                d8 = -d8;
            }
            d9 += d8;
            d8 = dArray[2] - d4;
            if (d8 < 0.0) {
                d8 = -d8;
            }
            if ((d9 += d8) < d5) {
                d5 = d9;
                n2 = i2;
            }
            if ((d7 = d9 - this.bias[i2]) < d6) {
                d6 = d7;
                n3 = i2;
            }
            int n4 = i2;
            this.freq[n4] = this.freq[n4] - 9.765625E-4 * this.freq[i2];
            int n5 = i2;
            this.bias[n5] = this.bias[n5] + 1.0 * this.freq[i2];
        }
        int n6 = n2;
        this.freq[n6] = this.freq[n6] + 9.765625E-4;
        int n7 = n2;
        this.bias[n7] = this.bias[n7] - 1.0;
        return n3;
    }

    private int specialFind(double d2, double d3, double d4) {
        for (int i2 = 0; i2 < 3; ++i2) {
            double[] dArray = this.network[i2];
            if (dArray[0] != d2 || dArray[1] != d3 || dArray[2] != d4) continue;
            return i2;
        }
        return -1;
    }

    private void learn() {
        int n2 = 1984;
        int n3 = 30 + (this.samplefac - 1) / 3;
        int n4 = this.pixels.length * this.pixels[0].length;
        int n5 = n4 / this.samplefac;
        int n6 = n5 / 100;
        int n7 = 1024;
        int n8 = 0;
        int n9 = n2 >> 6;
        if (n9 <= 1) {
            n9 = 0;
        }
        int n10 = 0;
        int n11 = 0;
        n10 = n4 % 499 != 0 ? 499 : (n4 % 491 != 0 ? 491 : (n4 % 487 != 0 ? 487 : 503));
        n8 = 0;
        while (n8 < n5) {
            int n12;
            int n13 = this.pixels[n11 / this.pixels[0].length][n11 % this.pixels[0].length];
            int n14 = n13 >> 16 & 0xFF;
            int n15 = n13 >> 8 & 0xFF;
            int n16 = n13 & 0xFF;
            double d2 = n16;
            double d3 = n15;
            double d4 = n14;
            if (n8 == 0) {
                this.network[2][0] = d2;
                this.network[2][1] = d3;
                this.network[2][2] = d4;
            }
            int n17 = n12 = (n12 = this.specialFind(d2, d3, d4)) < 0 ? this.contest(d2, d3, d4) : n12;
            if (n12 >= 3) {
                double d5 = 1.0 * (double)n7 / 1024.0;
                this.altersingle(d5, n12, d2, d3, d4);
                if (n9 > 0) {
                    this.alterneigh(d5, n9, n12, d2, d3, d4);
                }
            }
            n11 += n10;
            while (n11 >= n4) {
                n11 -= n4;
            }
            if (++n8 % n6 != 0) continue;
            n7 -= n7 / n3;
            if ((n9 = (n2 -= n2 / 30) >> 6) > 1) continue;
            n9 = 0;
        }
    }

    private void fix() {
        for (int i2 = 0; i2 < 255; ++i2) {
            for (int i3 = 0; i3 < 3; ++i3) {
                int n2 = (int)(0.5 + this.network[i2][i3]);
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > 255) {
                    n2 = 255;
                }
                this.colormap[i2][i3] = n2;
            }
            this.colormap[i2][3] = i2;
        }
    }

    private void inxbuild() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 255; ++n2) {
            int n5;
            int[] nArray = this.colormap[n2];
            int[] nArray2 = null;
            int n6 = n2;
            int n7 = nArray[1];
            for (n5 = n2 + 1; n5 < 255; ++n5) {
                nArray2 = this.colormap[n5];
                if (nArray2[1] >= n7) continue;
                n6 = n5;
                n7 = nArray2[1];
            }
            nArray2 = this.colormap[n6];
            if (n2 != n6) {
                n5 = nArray2[0];
                nArray2[0] = nArray[0];
                nArray[0] = n5;
                n5 = nArray2[1];
                nArray2[1] = nArray[1];
                nArray[1] = n5;
                n5 = nArray2[2];
                nArray2[2] = nArray[2];
                nArray[2] = n5;
                n5 = nArray2[3];
                nArray2[3] = nArray[3];
                nArray[3] = n5;
            }
            if (n7 == n3) continue;
            this.netindex[n3] = n4 + n2 >> 1;
            for (n5 = n3 + 1; n5 < n7; ++n5) {
                this.netindex[n5] = n2;
            }
            n3 = n7;
            n4 = n2;
        }
        this.netindex[n3] = n4 + 254 >> 1;
        for (n2 = n3 + 1; n2 < 256; ++n2) {
            this.netindex[n2] = 254;
        }
    }

    public int convert(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        int n7 = this.inxsearch(n6, n5, n4);
        int n8 = this.colormap[n7][0];
        int n9 = this.colormap[n7][1];
        int n10 = this.colormap[n7][2];
        return n3 << 24 | n10 << 16 | n9 << 8 | n8;
    }

    public int lookup(int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        int n6 = this.inxsearch(n5, n4, n3);
        return n6 + 1;
    }

    private int not_used_slow_inxsearch(int n2, int n3, int n4) {
        int n5 = 1000;
        int n6 = -1;
        for (int i2 = 0; i2 < 255; ++i2) {
            int n7;
            int[] nArray = this.colormap[i2];
            int n8 = nArray[1] - n3;
            if (n8 < 0) {
                n8 = -n8;
            }
            if ((n7 = nArray[0] - n2) < 0) {
                n7 = -n7;
            }
            n8 += n7;
            n7 = nArray[2] - n4;
            if (n7 < 0) {
                n7 = -n7;
            }
            if ((n8 += n7) >= n5) continue;
            n5 = n8;
            n6 = i2;
        }
        return n6;
    }

    protected int inxsearch(int n2, int n3, int n4) {
        int n5 = 1000;
        int n6 = -1;
        int n7 = this.netindex[n3];
        int n8 = n7 - 1;
        while (n7 < 255 || n8 >= 0) {
            int n9;
            int n10;
            int[] nArray;
            if (n7 < 255) {
                nArray = this.colormap[n7];
                n10 = nArray[1] - n3;
                if (n10 >= n5) {
                    n7 = 255;
                } else {
                    if (n10 < 0) {
                        n10 = -n10;
                    }
                    if ((n9 = nArray[0] - n2) < 0) {
                        n9 = -n9;
                    }
                    if ((n10 += n9) < n5) {
                        n9 = nArray[2] - n4;
                        if (n9 < 0) {
                            n9 = -n9;
                        }
                        if ((n10 += n9) < n5) {
                            n5 = n10;
                            n6 = n7;
                        }
                    }
                    ++n7;
                }
            }
            if (n8 < 0) continue;
            nArray = this.colormap[n8];
            n10 = n3 - nArray[1];
            if (n10 >= n5) {
                n8 = -1;
                continue;
            }
            if (n10 < 0) {
                n10 = -n10;
            }
            if ((n9 = nArray[0] - n2) < 0) {
                n9 = -n9;
            }
            if ((n10 += n9) < n5) {
                n9 = nArray[2] - n4;
                if (n9 < 0) {
                    n9 = -n9;
                }
                if ((n10 += n9) < n5) {
                    n5 = n10;
                    n6 = n8;
                }
            }
            --n8;
        }
        return n6;
    }
}

