/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import org.freehep.graphics2d.ScreenConstants;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class ImageSizePanel
extends OptionPanel {
    private static final String[] imageSizeList = new String[]{"ImageSize", "Custom", "600x480", "800x600", "1024x768", "1280x1024", "1400x1050", "1600x1200"};
    private String key;
    private Dimension initialDimension;
    private JComboBox imageSizeCombo;
    private JFormattedTextField imageWidth;
    private JFormattedTextField imageHeight;

    public ImageSizePanel(Properties properties, String string) {
        super("Image Size");
        this.key = string + "." + "ImageSize";
        UserProperties userProperties = new UserProperties(properties);
        this.initialDimension = userProperties.getPropertyDimension(this.key);
        this.imageSizeCombo = new JComboBox<String>(imageSizeList);
        this.add("0 * [5 15 5 15] r", new JLabel("Preset Sizes"));
        this.add("1 * [5 15 5 15] lw", this.imageSizeCombo);
        this.add("0 * [5 15 5 15] r", new JLabel("Width"));
        this.imageWidth = new JFormattedTextField(new TextFieldFormatter());
        this.imageWidth.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.imageWidth);
        this.add("0 * [5 15 5 15] r", new JLabel("Height"));
        this.imageHeight = new JFormattedTextField(new TextFieldFormatter());
        this.imageHeight.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.imageHeight);
        this.imageSizeCombo.addItemListener(new ComboListener());
        this.imageWidth.addActionListener(new TextFieldListener());
        this.imageHeight.addActionListener(new TextFieldListener());
        this.imageWidth.setValue(new Integer(this.initialDimension.width));
        this.imageHeight.setValue(new Integer(this.initialDimension.height));
        new TextFieldListener().actionPerformed(null);
        new ComboListener().itemStateChanged(null);
    }

    public boolean applyChangedOptions(Properties properties) {
        boolean bl = false;
        Dimension dimension = new Dimension(((Number)this.imageWidth.getValue()).intValue(), ((Number)this.imageHeight.getValue()).intValue());
        if (!dimension.equals(this.initialDimension)) {
            properties.setProperty(this.key, dimension.width + ", " + dimension.height);
            bl = true;
        }
        return bl;
    }

    private class ComboListener
    implements ItemListener {
        private ComboListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n2 = ImageSizePanel.this.imageSizeCombo.getSelectedIndex();
            switch (n2) {
                case 0: {
                    ImageSizePanel.this.imageWidth.setEnabled(false);
                    ImageSizePanel.this.imageHeight.setEnabled(false);
                    ImageSizePanel.this.imageWidth.setValue(new Integer(0));
                    ImageSizePanel.this.imageHeight.setValue(new Integer(0));
                    break;
                }
                case 1: {
                    ImageSizePanel.this.imageWidth.setEnabled(true);
                    ImageSizePanel.this.imageHeight.setEnabled(true);
                    break;
                }
                default: {
                    ImageSizePanel.this.imageWidth.setEnabled(true);
                    ImageSizePanel.this.imageHeight.setEnabled(true);
                    Dimension dimension = ScreenConstants.getSize(imageSizeList[n2]);
                    ImageSizePanel.this.imageWidth.setValue(new Integer(dimension.width));
                    ImageSizePanel.this.imageHeight.setValue(new Integer(dimension.height));
                }
            }
        }
    }

    private class TextFieldFormatter
    extends JFormattedTextField.AbstractFormatter {
        JFormattedTextField field;

        private TextFieldFormatter() {
        }

        public void install(JFormattedTextField jFormattedTextField) {
            super.install(jFormattedTextField);
            this.field = jFormattedTextField;
        }

        public void uninstall() {
            this.field = null;
        }

        public Object stringToValue(String string) throws ParseException {
            try {
                Integer n2 = new Integer(string);
                if (n2 < 0) {
                    throw new NumberFormatException();
                }
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                Object object = this.field.getValue();
                this.field.setValue(object);
                return object;
            }
        }

        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                return "0";
            }
            return object.toString();
        }
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = ((Number)ImageSizePanel.this.imageWidth.getValue()).intValue();
            int n3 = ((Number)ImageSizePanel.this.imageHeight.getValue()).intValue();
            if (n2 == 0 && n3 == 0) {
                ImageSizePanel.this.imageSizeCombo.setSelectedIndex(0);
                return;
            }
            for (int i2 = 2; i2 < imageSizeList.length; ++i2) {
                Dimension dimension = ScreenConstants.getSize(imageSizeList[i2]);
                if (n2 != dimension.width || n3 != dimension.height) continue;
                ImageSizePanel.this.imageSizeCombo.setSelectedIndex(i2);
                return;
            }
            ImageSizePanel.this.imageSizeCombo.setSelectedIndex(1);
        }
    }
}

