/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.OptionTextField;
import org.freehep.util.UserProperties;

public class ImageExportFileType
extends AbstractExportFileType {
    protected String format;
    protected ImageWriterSpi spi;
    protected ImageWriteParam param;
    protected OptionCheckBox antialias;
    protected OptionCheckBox antialiasText;
    protected OptionCheckBox progressive;
    protected OptionCheckBox compress;
    protected OptionComboBox compressMode;
    protected OptionComboBox compressDescription;
    protected OptionTextField compressQuality;

    protected ImageExportFileType(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            this.format = string;
            this.spi = imageWriter.getOriginatingProvider();
            this.param = imageWriter.getDefaultWriteParam();
            return;
        }
        throw new IllegalArgumentException(this.getClass() + ": Format not valid: " + string);
    }

    public ImageExportFileType(ImageWriterSpi imageWriterSpi) {
        this.format = imageWriterSpi.getFormatNames()[0];
        this.spi = imageWriterSpi;
        try {
            this.param = imageWriterSpi.createWriterInstance().getDefaultWriteParam();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to create Writer instance", iOException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ImageExportFileType) {
            ImageExportFileType imageExportFileType = (ImageExportFileType)object;
            return this.spi.getClass().equals(imageExportFileType.spi.getClass());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.spi.getClass().hashCode();
    }

    public static ImageExportFileType getInstance(String string) {
        if ((string = string.toLowerCase()).equals("GIF".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.gif.GIFExportFileType");
        }
        if (string.equals("PNG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.png.PNGExportFileType");
        }
        if (string.equals("JPG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.jpg.JPGExportFileType");
        }
        if (string.equals("RAW".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.raw.RawExportFileType");
        }
        if (string.equals("BMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.bmp.BMPExportFileType");
        }
        if (string.equals("WBMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.wbmp.WBMPExportFileType");
        }
        return null;
    }

    private static ImageExportFileType exportFileType(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (ImageExportFileType)clazz.newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public String getDescription() {
        return this.spi.getDescription(Locale.getDefault());
    }

    public String[] getExtensions() {
        return this.spi.getFileSuffixes();
    }

    public String[] getMIMETypes() {
        return this.spi.getMIMETypes();
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties properties) {
        UserProperties userProperties = new UserProperties(properties, ImageGraphics2D.getDefaultProperties(this.format));
        OptionPanel optionPanel = new OptionPanel(this.format.toUpperCase() + " Format");
        String string = "org.freehep.graphicsio." + this.format;
        optionPanel.add("0 * * 1 [5 15 5 15] w", new BackgroundPanel(userProperties, string, ImageGraphics2D.canWriteTransparent(this.format), null));
        this.antialias = new OptionCheckBox(userProperties, string + ".Antialias", "Antialias");
        optionPanel.add("0 * * 1 [5 15 5 15] w", this.antialias);
        this.antialiasText = new OptionCheckBox(userProperties, string + ".AntialiasText", "Antialias Text");
        optionPanel.add("0 * * 1 [5 15 5 15] w", this.antialiasText);
        this.progressive = new OptionCheckBox(userProperties, string + ".Progressive", "Progressive");
        if (this.param.canWriteProgressive()) {
            optionPanel.add("0 * * 1 [5 15 5 15] w", this.progressive);
        }
        this.compress = new OptionCheckBox(userProperties, string + ".Compress", "Compress");
        if (this.param.canWriteCompressed() && ImageGraphics2D.canWriteUncompressed(this.format)) {
            optionPanel.add("0 * * 1 [5 15 5 15] w", this.compress);
            this.param.setCompressionMode(userProperties.isProperty(string + ".Compress") ? 2 : 0);
        }
        if (this.param.canWriteCompressed() && this.param.getCompressionMode() == 2) {
            String[] stringArray = this.param.getCompressionTypes();
            JLabel jLabel = new JLabel("Compression Mode");
            this.compressMode = new OptionComboBox(userProperties, string + ".CompressMode", stringArray);
            if (stringArray.length > 1) {
                optionPanel.add("0 * [5 15 5 15] r", jLabel);
                optionPanel.add("1 * [5 15 5 15] lw", this.compressMode);
                this.compress.enables(jLabel);
                this.compress.enables(this.compressMode);
            }
            JLabel jLabel2 = new JLabel("Quality Value");
            optionPanel.add("0 * [5 15 5 15] r", jLabel2);
            this.compressQuality = new OptionTextField(userProperties, string + ".CompressQuality", 5);
            optionPanel.add("1 * [5 15 5 15] lw", this.compressQuality);
            this.compress.enables(jLabel2);
            this.compress.enables(this.compressQuality);
        }
        return optionPanel;
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Component component) throws IOException {
        return new ImageGraphics2D(outputStream, component, this.format);
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Dimension dimension) throws IOException {
        return new ImageGraphics2D(outputStream, dimension, this.format);
    }

    public String toString() {
        return super.toString() + " for " + this.format + " using " + this.spi;
    }
}

