/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdi.Text;

public class TextW
extends Text {
    public TextW(Point point, String string, int n2, Rectangle rectangle, int[] nArray) {
        super(point, string, n2, rectangle, nArray);
    }

    public static TextW read(EMFInputStream eMFInputStream) throws IOException {
        Point point = eMFInputStream.readPOINTL();
        int n2 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int n3 = eMFInputStream.readDWORD();
        Rectangle rectangle = eMFInputStream.readRECTL();
        eMFInputStream.readDWORD();
        String string = new String(eMFInputStream.readBYTE(2 * n2), "UTF-16LE");
        if (2 * n2 % 4 != 0) {
            for (int i2 = 0; i2 < 4 - 2 * n2 % 4; ++i2) {
                eMFInputStream.readBYTE();
            }
        }
        int[] nArray = new int[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            nArray[i3] = eMFInputStream.readDWORD();
        }
        return new TextW(point, string, n3, rectangle, nArray);
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        int n2;
        eMFOutputStream.writePOINTL(this.pos);
        eMFOutputStream.writeDWORD(this.string.length());
        eMFOutputStream.writeDWORD(76);
        eMFOutputStream.writeDWORD(this.options);
        eMFOutputStream.writeRECTL(this.bounds);
        int n3 = 2 * this.string.length() % 4;
        if (n3 > 0) {
            n3 = 4 - n3;
        }
        eMFOutputStream.writeDWORD(76 + 2 * this.string.length() + n3);
        eMFOutputStream.writeBYTE(this.string.getBytes("UTF-16LE"));
        for (n2 = 0; n2 < n3; ++n2) {
            eMFOutputStream.writeBYTE(0);
        }
        for (n2 = 0; n2 < this.string.length(); ++n2) {
            eMFOutputStream.writeDWORD(this.widths[n2]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.string.length(); ++i2) {
            stringBuffer.append(",");
            stringBuffer.append(this.widths[i2]);
        }
        stringBuffer.append(']');
        stringBuffer.setCharAt(0, '[');
        return "  TextW\n    pos: " + this.pos + "\n    options: " + this.options + "\n    bounds: " + this.bounds + "\n    string: " + this.string + "\n    widths: " + stringBuffer;
    }
}

