/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFImageLoader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.BitmapInfo;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.util.io.NoCloseOutputStream;

public class StretchDIBits
extends EMFTag
implements EMFConstants {
    public static final int size = 80;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xSrc;
    private int ySrc;
    private int widthSrc;
    private int heightSrc;
    private int usage;
    private int dwROP;
    private Color bkg;
    private BitmapInfo bmi;
    private BufferedImage image;

    public StretchDIBits() {
        super(81, 1);
    }

    public StretchDIBits(Rectangle rectangle, int n2, int n3, int n4, int n5, BufferedImage bufferedImage, Color color) {
        this();
        this.bounds = rectangle;
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.xSrc = 0;
        this.ySrc = 0;
        this.widthSrc = bufferedImage.getWidth();
        this.heightSrc = bufferedImage.getHeight();
        this.usage = 0;
        this.dwROP = 0xCC0020;
        this.bkg = color;
        this.image = bufferedImage;
        this.bmi = null;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        StretchDIBits stretchDIBits = new StretchDIBits();
        stretchDIBits.bounds = eMFInputStream.readRECTL();
        stretchDIBits.x = eMFInputStream.readLONG();
        stretchDIBits.y = eMFInputStream.readLONG();
        stretchDIBits.xSrc = eMFInputStream.readLONG();
        stretchDIBits.ySrc = eMFInputStream.readLONG();
        stretchDIBits.width = eMFInputStream.readLONG();
        stretchDIBits.height = eMFInputStream.readLONG();
        eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        stretchDIBits.usage = eMFInputStream.readDWORD();
        stretchDIBits.dwROP = eMFInputStream.readDWORD();
        stretchDIBits.widthSrc = eMFInputStream.readLONG();
        stretchDIBits.heightSrc = eMFInputStream.readLONG();
        stretchDIBits.bmi = new BitmapInfo(eMFInputStream);
        stretchDIBits.image = EMFImageLoader.readImage(stretchDIBits.bmi.getHeader(), stretchDIBits.width, stretchDIBits.height, eMFInputStream, n3 - 72 - 40, null);
        return stretchDIBits;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeLONG(this.x);
        eMFOutputStream.writeLONG(this.y);
        eMFOutputStream.writeLONG(this.xSrc);
        eMFOutputStream.writeLONG(this.ySrc);
        eMFOutputStream.writeLONG(this.widthSrc);
        eMFOutputStream.writeLONG(this.heightSrc);
        eMFOutputStream.writeDWORD(80);
        eMFOutputStream.writeDWORD(40);
        eMFOutputStream.writeDWORD(120);
        eMFOutputStream.pushBuffer();
        int n3 = 0;
        ImageGraphics2D.writeImage(this.image, "RAW".toLowerCase(), (Properties)ImageGraphics2D.getRAWProperties(this.bkg, "BGR"), (OutputStream)new NoCloseOutputStream(eMFOutputStream));
        int n4 = eMFOutputStream.popBuffer();
        eMFOutputStream.writeDWORD(n4);
        eMFOutputStream.writeDWORD(this.usage);
        eMFOutputStream.writeDWORD(this.dwROP);
        eMFOutputStream.writeLONG(this.width);
        eMFOutputStream.writeLONG(this.height);
        BitmapInfoHeader bitmapInfoHeader = new BitmapInfoHeader(this.widthSrc, this.heightSrc, 24, n3, n4, 0, 0, 0, 0);
        this.bmi = new BitmapInfo(bitmapInfoHeader);
        this.bmi.write(eMFOutputStream);
        eMFOutputStream.append();
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n  xSrc, ySrc, widthSrc, heightSrc: " + this.xSrc + " " + this.ySrc + " " + this.widthSrc + " " + this.heightSrc + "\n  usage: " + this.usage + "\n  dwROP: " + this.dwROP + "\n  bkg: " + this.bkg + "\n" + this.bmi.toString();
    }

    public void render(EMFRenderer eMFRenderer) {
        if (this.image != null) {
            eMFRenderer.drawImage(this.image, this.x, this.y, this.widthSrc, this.heightSrc);
        }
    }
}

