/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class SetMapMode
extends EMFTag
implements EMFConstants {
    private int mode;

    public SetMapMode() {
        super(17, 1);
    }

    public SetMapMode(int n2) {
        this();
        this.mode = n2;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        return new SetMapMode(eMFInputStream.readDWORD());
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeDWORD(this.mode);
    }

    public String toString() {
        return super.toString() + "\n  mode: " + this.mode;
    }

    public void render(EMFRenderer eMFRenderer) {
        if (this.mode == 8) {
            eMFRenderer.setMapModeIsotropic(false);
        } else if (this.mode == 5) {
            double d2 = 0.0254;
            eMFRenderer.setMapModeTransform(AffineTransform.getScaleInstance(d2, d2));
        } else if (this.mode == 3) {
            double d3 = 0.01;
            eMFRenderer.setMapModeTransform(AffineTransform.getScaleInstance(d3, d3));
        } else if (this.mode == 7) {
            eMFRenderer.setMapModeIsotropic(true);
            eMFRenderer.fixViewportSize();
        } else if (this.mode == 4) {
            double d4 = 0.254;
            eMFRenderer.setMapModeTransform(AffineTransform.getScaleInstance(d4, d4));
        } else if (this.mode == 2) {
            double d5 = 0.1;
            eMFRenderer.setMapModeTransform(AffineTransform.getScaleInstance(d5, d5));
        } else if (this.mode == 1) {
            eMFRenderer.setMapModeTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        } else if (this.mode == 6) {
            eMFRenderer.setMapModeTransform(AffineTransform.getScaleInstance(EMFRenderer.TWIP_SCALE, EMFRenderer.TWIP_SCALE));
        }
    }
}

