/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class Region {
    private Rectangle bounds;
    private Rectangle region;

    public Region(Rectangle rectangle, Rectangle rectangle2) {
        this.bounds = rectangle;
        this.region = rectangle2;
    }

    public Region(EMFInputStream eMFInputStream) throws IOException {
        eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int n2 = eMFInputStream.readDWORD();
        this.bounds = eMFInputStream.readRECTL();
        this.region = eMFInputStream.readRECTL();
        for (int i2 = 16; i2 < n2; i2 += 16) {
            eMFInputStream.readRECTL();
        }
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeDWORD(32);
        eMFOutputStream.writeDWORD(1);
        eMFOutputStream.writeDWORD(1);
        eMFOutputStream.writeDWORD(16);
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeRECTL(this.region);
    }

    public int length() {
        return 48;
    }

    public String toString() {
        return "  Region\n    bounds: " + this.bounds + "\n    region: " + this.region;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }
}

