/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolygon;

public class Polyline
extends AbstractPolygon {
    public Polyline() {
        super(4, 1, null, 0, null);
    }

    public Polyline(Rectangle rectangle, int n2, Point[] pointArray) {
        super(4, 1, rectangle, n2, pointArray);
    }

    protected Polyline(int n2, int n3, Rectangle rectangle, int n4, Point[] pointArray) {
        super(n2, n3, rectangle, n4, pointArray);
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n4 = eMFInputStream.readDWORD();
        return new Polyline(rectangle, n4, eMFInputStream.readPOINTL(n4));
    }

    public void render(EMFRenderer eMFRenderer) {
        Point[] pointArray = this.getPoints();
        int n2 = this.getNumberOfPoints();
        if (pointArray != null && pointArray.length > 0) {
            GeneralPath generalPath = new GeneralPath(eMFRenderer.getWindingRule());
            for (int i2 = 0; i2 < n2; ++i2) {
                Point point = pointArray[i2];
                if (i2 > 0) {
                    generalPath.lineTo((float)point.getX(), (float)point.getY());
                    continue;
                }
                generalPath.moveTo((float)point.getX(), (float)point.getY());
            }
            eMFRenderer.drawOrAppend(generalPath);
        }
    }
}

