/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolyPolyline;

public class PolyPolyline16
extends AbstractPolyPolyline {
    private int numberOfPolys;

    public PolyPolyline16() {
        super(90, 1, null, null, null);
    }

    public PolyPolyline16(Rectangle rectangle, int n2, int[] nArray, Point[][] pointArray) {
        super(90, 1, rectangle, nArray, pointArray);
        this.numberOfPolys = n2;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        int n4;
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n5 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int[] nArray = new int[n5];
        Point[][] pointArray = new Point[n5][];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = eMFInputStream.readDWORD();
            pointArray[n4] = new Point[nArray[n4]];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            pointArray[n4] = eMFInputStream.readPOINTS(nArray[n4]);
        }
        return new PolyPolyline16(rectangle, n5, nArray, pointArray);
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        int n3;
        int[] nArray = this.getNumberOfPoints();
        Point[][] pointArray = this.getPoints();
        eMFOutputStream.writeRECTL(this.getBounds());
        eMFOutputStream.writeDWORD(this.numberOfPolys);
        int n4 = 0;
        for (n3 = 0; n3 < this.numberOfPolys; ++n3) {
            n4 += nArray[n3];
        }
        eMFOutputStream.writeDWORD(n4);
        for (n3 = 0; n3 < this.numberOfPolys; ++n3) {
            eMFOutputStream.writeDWORD(nArray[n3]);
        }
        for (n3 = 0; n3 < this.numberOfPolys; ++n3) {
            eMFOutputStream.writePOINTS(nArray[n3], pointArray[n3]);
        }
    }
}

