/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolyPolyline;

public class PolyPolyline
extends AbstractPolyPolyline {
    private int start;
    private int end;

    public PolyPolyline() {
        super(7, 1, null, null, null);
    }

    public PolyPolyline(Rectangle rectangle, int n2, int n3, int[] nArray, Point[][] pointArray) {
        super(7, 1, rectangle, nArray, pointArray);
        this.start = n2;
        this.end = Math.min(n3, nArray.length - 1);
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        int n4;
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n5 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int[] nArray = new int[n5];
        Point[][] pointArray = new Point[n5][];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = eMFInputStream.readDWORD();
            pointArray[n4] = new Point[nArray[n4]];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            pointArray[n4] = eMFInputStream.readPOINTL(nArray[n4]);
        }
        return new PolyPolyline(rectangle, 0, n5 - 1, nArray, pointArray);
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        int n3;
        int[] nArray = this.getNumberOfPoints();
        Point[][] pointArray = this.getPoints();
        eMFOutputStream.writeRECTL(this.getBounds());
        eMFOutputStream.writeDWORD(this.end - this.start + 1);
        int n4 = 0;
        for (n3 = this.start; n3 < this.end + 1; ++n3) {
            n4 += nArray[n3];
        }
        eMFOutputStream.writeDWORD(n4);
        for (n3 = this.start; n3 < this.end + 1; ++n3) {
            eMFOutputStream.writeDWORD(nArray[n3]);
        }
        for (n3 = this.start; n3 < this.end + 1; ++n3) {
            eMFOutputStream.writePOINTL(nArray[n3], pointArray[n3]);
        }
    }
}

