/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolygon;

public class PolyBezierTo
extends AbstractPolygon {
    public PolyBezierTo() {
        super(5, 1, null, 0, null);
    }

    public PolyBezierTo(Rectangle rectangle, int n2, Point[] pointArray) {
        super(5, 1, rectangle, n2, pointArray);
    }

    protected PolyBezierTo(int n2, int n3, Rectangle rectangle, int n4, Point[] pointArray) {
        super(n2, n3, rectangle, n4, pointArray);
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n4 = eMFInputStream.readDWORD();
        return new PolyBezierTo(rectangle, n4, eMFInputStream.readPOINTL(n4));
    }

    public void render(EMFRenderer eMFRenderer) {
        Point[] pointArray = this.getPoints();
        int n2 = this.getNumberOfPoints();
        GeneralPath generalPath = eMFRenderer.getFigure();
        if (pointArray != null && pointArray.length > 0) {
            for (int i2 = 0; i2 < n2; i2 += 3) {
                Point point = pointArray[i2];
                Point point2 = pointArray[i2 + 1];
                Point point3 = pointArray[i2 + 2];
                generalPath.curveTo((float)point.getX(), (float)point.getY(), (float)point2.getX(), (float)point2.getY(), (float)point3.getX(), (float)point3.getY());
            }
        }
    }
}

