/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.AbstractPen;

public class LogPen
extends AbstractPen {
    private int penStyle;
    private int width;
    private Color color;

    public LogPen(int n2, int n3, Color color) {
        this.penStyle = n2;
        this.width = n3;
        this.color = color;
    }

    public LogPen(EMFInputStream eMFInputStream) throws IOException {
        this.penStyle = eMFInputStream.readDWORD();
        this.width = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        this.color = eMFInputStream.readCOLORREF();
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeDWORD(this.penStyle);
        eMFOutputStream.writeDWORD(this.width);
        eMFOutputStream.writeDWORD(0);
        eMFOutputStream.writeCOLORREF(this.color);
    }

    public String toString() {
        return "  LogPen\n    penstyle: " + this.penStyle + "\n    width: " + this.width + "\n    color: " + this.color;
    }

    public void render(EMFRenderer eMFRenderer) {
        eMFRenderer.setUseCreatePen(true);
        eMFRenderer.setPenPaint(this.color);
        eMFRenderer.setPenStroke(this.createStroke(eMFRenderer, this.penStyle, null, this.width));
    }
}

