/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Font;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.GDIObject;

public class LogFontW
implements EMFConstants,
GDIObject {
    private int height;
    private int width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charSet;
    private int outPrecision;
    private int clipPrecision;
    private int quality;
    private int pitchAndFamily;
    private String faceFamily;
    private Font font;

    public LogFontW(int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, int n7, int n8, int n9, int n10, int n11, String string) {
        this.height = n2;
        this.width = n3;
        this.escapement = n4;
        this.orientation = n5;
        this.weight = n6;
        this.italic = bl;
        this.underline = bl2;
        this.strikeout = bl3;
        this.charSet = n7;
        this.outPrecision = n8;
        this.clipPrecision = n9;
        this.quality = n10;
        this.pitchAndFamily = n11;
        this.faceFamily = string;
    }

    public LogFontW(Font font) {
        this.height = -font.getSize();
        this.width = 0;
        this.escapement = 0;
        this.orientation = 0;
        this.weight = font.isBold() ? 700 : 400;
        this.italic = font.isItalic();
        this.underline = false;
        this.strikeout = false;
        this.charSet = 0;
        this.outPrecision = 0;
        this.clipPrecision = 0;
        this.quality = 4;
        this.pitchAndFamily = 0;
        this.faceFamily = font.getName();
    }

    public LogFontW(EMFInputStream eMFInputStream) throws IOException {
        this.height = eMFInputStream.readLONG();
        this.width = eMFInputStream.readLONG();
        this.escapement = eMFInputStream.readLONG();
        this.orientation = eMFInputStream.readLONG();
        this.weight = eMFInputStream.readLONG();
        this.italic = eMFInputStream.readBOOLEAN();
        this.underline = eMFInputStream.readBOOLEAN();
        this.strikeout = eMFInputStream.readBOOLEAN();
        this.charSet = eMFInputStream.readBYTE();
        this.outPrecision = eMFInputStream.readBYTE();
        this.clipPrecision = eMFInputStream.readBYTE();
        this.quality = eMFInputStream.readBYTE();
        this.pitchAndFamily = eMFInputStream.readBYTE();
        this.faceFamily = eMFInputStream.readWCHAR(32);
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeLONG(this.height);
        eMFOutputStream.writeLONG(this.width);
        eMFOutputStream.writeLONG(this.escapement);
        eMFOutputStream.writeLONG(this.orientation);
        eMFOutputStream.writeLONG(this.weight);
        eMFOutputStream.writeBYTE(this.italic);
        eMFOutputStream.writeBYTE(this.underline);
        eMFOutputStream.writeBYTE(this.strikeout);
        eMFOutputStream.writeBYTE(this.charSet);
        eMFOutputStream.writeBYTE(this.outPrecision);
        eMFOutputStream.writeBYTE(this.clipPrecision);
        eMFOutputStream.writeBYTE(this.quality);
        eMFOutputStream.writeBYTE(this.pitchAndFamily);
        eMFOutputStream.writeWCHAR(this.faceFamily, 32);
    }

    public Font getFont() {
        if (this.font == null) {
            int n2 = 0;
            if (this.italic) {
                n2 |= 2;
            }
            if (this.weight > 400) {
                n2 |= 1;
            }
            int n3 = Math.abs(this.height);
            this.font = new Font(this.faceFamily, n2, n3);
        }
        return this.font;
    }

    public String toString() {
        return "  LogFontW\n    height: " + this.height + "\n    width: " + this.width + "\n    orientation: " + this.orientation + "\n    weight: " + this.weight + "\n    italic: " + this.italic + "\n    underline: " + this.underline + "\n    strikeout: " + this.strikeout + "\n    charSet: " + this.charSet + "\n    outPrecision: " + this.outPrecision + "\n    clipPrecision: " + this.clipPrecision + "\n    quality: " + this.quality + "\n    pitchAndFamily: " + this.pitchAndFamily + "\n    faceFamily: " + this.faceFamily;
    }

    public void render(EMFRenderer eMFRenderer) {
        eMFRenderer.setFont(this.font);
    }
}

