/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import java.util.logging.Logger;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.GDIObject;

public class LogBrush32
implements EMFConstants,
GDIObject {
    private int style;
    private Color color;
    private int hatch;

    public LogBrush32(int n2, Color color, int n3) {
        this.style = n2;
        this.color = color;
        this.hatch = n3;
    }

    public LogBrush32(EMFInputStream eMFInputStream) throws IOException {
        this.style = eMFInputStream.readUINT();
        this.color = eMFInputStream.readCOLORREF();
        this.hatch = eMFInputStream.readULONG();
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeUINT(this.style);
        eMFOutputStream.writeCOLORREF(this.color);
        eMFOutputStream.writeULONG(this.hatch);
    }

    public String toString() {
        return "  LogBrush32\n    style: " + this.style + "\n    color: " + this.color + "\n    hatch: " + this.hatch;
    }

    public void render(EMFRenderer eMFRenderer) {
        if (this.style == 0) {
            eMFRenderer.setBrushPaint(this.color);
        } else if (this.style == 1) {
            eMFRenderer.setBrushPaint(new Color(0, 0, 0, 0));
        } else {
            Logger logger = Logger.getLogger("org.freehep.graphicsio.emf");
            logger.warning("LogBrush32 style not supported: " + this.toString());
            eMFRenderer.setBrushPaint(this.color);
        }
    }
}

