/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.Gradient;
import org.freehep.graphicsio.emf.gdi.GradientRectangle;
import org.freehep.graphicsio.emf.gdi.GradientTriangle;
import org.freehep.graphicsio.emf.gdi.TriVertex;

public class GradientFill
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private int mode;
    private TriVertex[] vertices;
    private Gradient[] gradients;

    public GradientFill() {
        super(118, 1);
    }

    public GradientFill(Rectangle rectangle, int n2, TriVertex[] triVertexArray, Gradient[] gradientArray) {
        this();
        this.bounds = rectangle;
        this.mode = n2;
        this.vertices = triVertexArray;
        this.gradients = gradientArray;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        int n4;
        Rectangle rectangle = eMFInputStream.readRECTL();
        TriVertex[] triVertexArray = new TriVertex[eMFInputStream.readDWORD()];
        Gradient[] gradientArray = new Gradient[eMFInputStream.readDWORD()];
        int n5 = eMFInputStream.readULONG();
        for (n4 = 0; n4 < triVertexArray.length; ++n4) {
            triVertexArray[n4] = new TriVertex(eMFInputStream);
        }
        for (n4 = 0; n4 < gradientArray.length; ++n4) {
            gradientArray[n4] = n5 == 2 ? new GradientTriangle(eMFInputStream) : new GradientRectangle(eMFInputStream);
        }
        return new GradientFill(rectangle, n5, triVertexArray, gradientArray);
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        int n3;
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeDWORD(this.vertices.length);
        eMFOutputStream.writeDWORD(this.gradients.length);
        eMFOutputStream.writeULONG(this.mode);
        for (n3 = 0; n3 < this.vertices.length; ++n3) {
            this.vertices[n3].write(eMFOutputStream);
        }
        for (n3 = 0; n3 < this.gradients.length; ++n3) {
            this.gradients[n3].write(eMFOutputStream);
        }
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        stringBuffer.append("  bounds: ");
        stringBuffer.append(this.bounds);
        stringBuffer.append("\n");
        stringBuffer.append("  mode: ");
        stringBuffer.append(this.mode);
        stringBuffer.append("\n");
        for (n2 = 0; n2 < this.vertices.length; ++n2) {
            stringBuffer.append("  vertex[");
            stringBuffer.append(n2);
            stringBuffer.append("]: ");
            stringBuffer.append(this.vertices[n2]);
            stringBuffer.append("\n");
        }
        for (n2 = 0; n2 < this.gradients.length; ++n2) {
            stringBuffer.append("  gradient[");
            stringBuffer.append(n2);
            stringBuffer.append("]: ");
            stringBuffer.append(this.gradients[n2]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

