/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class GDIComment
extends EMFTag {
    private int type;
    private String comment = "";
    private Image image;

    public GDIComment() {
        super(70, 1);
    }

    public GDIComment(String string) {
        this();
        this.comment = string;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        GDIComment gDIComment = new GDIComment();
        int n4 = eMFInputStream.readDWORD();
        gDIComment.type = eMFInputStream.readDWORD();
        if (gDIComment.type == 726027589) {
            eMFInputStream.readByte(n4 - 4);
            if (n4 % 4 != 0) {
                eMFInputStream.readBYTE(4 - n4 % 4);
            }
        } else if (gDIComment.type == 2) {
            eMFInputStream.readRECTL();
            int n5 = eMFInputStream.readDWORD();
            if (n5 > 0) {
                gDIComment.comment = new String(eMFInputStream.readByte(n5));
            }
        } else if (gDIComment.type != 3) {
            if (gDIComment.type == 0x40000004) {
                eMFInputStream.readRECTL();
                eMFInputStream.readDWORD();
                n4 = n4 - 4 - 8;
                gDIComment.comment = new String(eMFInputStream.readBYTE(n4));
                if (n4 % 4 != 0) {
                    eMFInputStream.readBYTE(4 - n4 % 4);
                }
            } else {
                if (gDIComment.type == -2147483647) {
                    eMFInputStream.readDWORD();
                    eMFInputStream.readDWORD();
                    eMFInputStream.readDWORD();
                    int n6 = eMFInputStream.readDWORD();
                    byte[] byArray = eMFInputStream.readByte(n6);
                    gDIComment.image = ImageIO.read(new ByteArrayInputStream(byArray));
                    return this;
                }
                if ((n4 -= 4) > 0) {
                    gDIComment.comment = new String(eMFInputStream.readBYTE(n4));
                    if (n4 % 4 != 0) {
                        eMFInputStream.readBYTE(4 - n4 % 4);
                    }
                } else {
                    this.comment = "";
                }
            }
        }
        return gDIComment;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        byte[] byArray = this.comment.getBytes();
        eMFOutputStream.writeDWORD(byArray.length);
        eMFOutputStream.writeBYTE(byArray);
        if (byArray.length % 4 != 0) {
            for (int i2 = 0; i2 < 4 - byArray.length % 4; ++i2) {
                eMFOutputStream.writeBYTE(0);
            }
        }
    }

    public String toString() {
        return super.toString() + "\n  length: " + this.comment.length();
    }

    public void render(EMFRenderer eMFRenderer) {
    }
}

