/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.AbstractPen;

public class ExtLogPen
extends AbstractPen {
    private int penStyle;
    private int width;
    private int brushStyle;
    private Color color;
    private int hatch;
    private int[] style;

    public ExtLogPen(int n2, int n3, int n4, Color color, int n5, int[] nArray) {
        this.penStyle = n2;
        this.width = n3;
        this.brushStyle = n4;
        this.color = color;
        this.hatch = n5;
        this.style = nArray;
    }

    public ExtLogPen(EMFInputStream eMFInputStream) throws IOException {
        this.penStyle = eMFInputStream.readDWORD();
        this.width = eMFInputStream.readDWORD();
        this.brushStyle = eMFInputStream.readUINT();
        this.color = eMFInputStream.readCOLORREF();
        this.hatch = eMFInputStream.readULONG();
        int n2 = eMFInputStream.readDWORD();
        if (n2 == 0) {
            eMFInputStream.readDWORD();
        }
        this.style = eMFInputStream.readDWORD(n2);
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeDWORD(this.penStyle);
        eMFOutputStream.writeDWORD(this.width);
        eMFOutputStream.writeUINT(this.brushStyle);
        eMFOutputStream.writeCOLORREF(this.color);
        eMFOutputStream.writeULONG(this.hatch);
        eMFOutputStream.writeDWORD(this.style.length);
        if (this.style.length == 0) {
            eMFOutputStream.writeDWORD(0);
        }
        eMFOutputStream.writeDWORD(this.style);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ExtLogPen\n");
        stringBuffer.append("    penStyle: ");
        stringBuffer.append(Integer.toHexString(this.penStyle));
        stringBuffer.append("\n");
        stringBuffer.append("    width: ");
        stringBuffer.append(this.width);
        stringBuffer.append("\n");
        stringBuffer.append("    brushStyle: ");
        stringBuffer.append(this.brushStyle);
        stringBuffer.append("\n");
        stringBuffer.append("    color: ");
        stringBuffer.append(this.color);
        stringBuffer.append("\n");
        stringBuffer.append("    hatch: ");
        stringBuffer.append(this.hatch);
        stringBuffer.append("\n");
        for (int i2 = 0; i2 < this.style.length; ++i2) {
            stringBuffer.append("      style[");
            stringBuffer.append(i2);
            stringBuffer.append("]: ");
            stringBuffer.append(this.style[i2]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void render(EMFRenderer eMFRenderer) {
        eMFRenderer.setUseCreatePen(false);
        eMFRenderer.setPenPaint(this.color);
        eMFRenderer.setPenStroke(this.createStroke(eMFRenderer, this.penStyle, this.style, this.width));
    }
}

